package net.wicp.tams.common.os.pool;

import java.util.List;

import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;

import net.wicp.tams.common.beans.Host;

/***
 * 不能治理连接泄漏情况，应用应手动关闭连接
 * 
 * @author 偏锋书生
 *
 *         2018年8月22日
 */
public class SSHPoolByKey extends GenericKeyedObjectPool<Host, SSHConnection> {

	public SSHPoolByKey(List<Host> conf, GenericKeyedObjectPoolConfig<SSHConnection> poolConfig) {
		super(new SSHFactoryByKey(conf), poolConfig);
	}

	public SSHPoolByKey(List<Host> conf) {
		super(new SSHFactoryByKey(conf));
	}

	public SSHPoolByKey() {
		super(new SSHFactoryByKey(null));
	}

}
