package net.wicp.tams.common.micro.quartz.exe;

import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

import net.wicp.tams.common.micro.ConfigInit;
import net.wicp.tams.common.micro.quartz.JobTaskService;
import net.wicp.tams.common.micro.quartz.bean.ScheduleJob;

/***
 * 若一个方法一次执行不完下次轮转时则等待改方法执行完后才执行下一次操作
 * 
 * @author zhoujunhui
 *
 */
@DisallowConcurrentExecution
public class QuartzJobFull implements Job {

	@Override
	public void execute(JobExecutionContext context) throws JobExecutionException {
		ScheduleJob scheduleJob = (ScheduleJob) context.getMergedJobDataMap().get(JobTaskService.poNameInJobDataMap);
		JobTaskService jobTaskService = ConfigInit.context.getBean(JobTaskService.class);
		jobTaskService.callBusiExe(scheduleJob);
	}
}