/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.micro.metric;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.ryantenney.metrics.spring.config.annotation.EnableMetrics;
import com.ryantenney.metrics.spring.config.annotation.MetricsConfigurerAdapter;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.metrics.core.JsonReporter;
import net.wicp.tams.common.metrics.utility.TsLogger;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableMetrics(proxyTargetClass=true, exposeProxy=true)
public class SpringConfiguringClass
extends MetricsConfigurerAdapter {
    public void configureReporters(MetricRegistry metricRegistry) {
        JsonReporter.Builder reporter = JsonReporter.forRegistry((MetricRegistry)metricRegistry);
        reporter.outputTo(TsLogger.getTamsLogger()).filter(this.metricFilterPattern(Conf.get((String)"common.micro.metric.filter.pattern")));
        ((JsonReporter)this.registerReporter((Closeable)reporter.build())).start(1L, TimeUnit.MINUTES);
    }

    protected MetricFilter metricFilterPattern(final String pattern) {
        final Pattern filter = Pattern.compile(pattern);
        return new MetricFilter(){

            public boolean matches(String name, Metric metric) {
                if (StringUtil.isNull((Object)pattern) || "none".equals(pattern)) {
                    return true;
                }
                return filter.matcher(name).matches();
            }

            public String toString() {
                return "[MetricFilter regex=" + (StringUtil.isNull((Object)pattern) || "none".equals(pattern) ? "all" : filter.pattern()) + "]";
            }
        };
    }
}

