/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.micro.quartz;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.micro.quartz.IScheduleJobStore;
import net.wicp.tams.common.micro.quartz.bean.ScheduleJob;
import net.wicp.tams.common.micro.quartz.exe.IJob;
import net.wicp.tams.common.micro.quartz.exe.QuartzJobFull;
import net.wicp.tams.common.micro.quartz.exe.QuartzJobLess;
import org.apache.log4j.Logger;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@ConditionalOnBean(value={IScheduleJobStore.class})
@ConditionalOnProperty(name={"common.micro.quartz.enable"}, havingValue="true")
public class JobTaskService {
    public final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private SchedulerFactoryBean schedulerFactoryBean;
    @Autowired
    private IScheduleJobStore scheduleJobMapper;
    @Autowired
    private ApplicationContext applicationContext;
    public static String poNameInJobDataMap = "scheduleJob";

    public List<ScheduleJob> getAllTask() {
        return this.scheduleJobMapper.getAll(null);
    }

    public Result addTask(ScheduleJob job) {
        try {
            this.addJob(job);
            job.setCreateTime(new Date());
            this.scheduleJobMapper.insert(job);
            return Result.getSuc();
        }
        catch (SchedulerException e) {
            this.log.error((Object)"\u6dfb\u52a0job\u5931\u8d25", (Throwable)e);
            return Result.getError((String)e.getMessage());
        }
    }

    public ScheduleJob getTaskById(Long jobId) {
        return this.scheduleJobMapper.selectByPrimaryKey(jobId);
    }

    public ScheduleJob getTaskByGroupAndName(String jobGroup, String jobName) {
        return this.scheduleJobMapper.selectByGroupAndName(jobGroup, jobName);
    }

    public void changeStatus(Long jobId, String cmd) throws SchedulerException {
        ScheduleJob job = this.getTaskById(jobId);
        if (job == null) {
            return;
        }
        if ("stop".equals(cmd)) {
            this.deleteJob(job);
            job.setIsActiv(YesOrNo.no);
        } else if ("start".equals(cmd)) {
            job.setIsActiv(YesOrNo.yes);
            this.addJob(job);
        }
        this.scheduleJobMapper.updateByPrimaryKey(job);
    }

    public void updateCron(Long jobId, String cron) throws SchedulerException {
        if (!this.checkEnable()) {
            return;
        }
        ScheduleJob job = this.getTaskById(jobId);
        if (job == null) {
            return;
        }
        job.setCronExpression(cron);
        if (job.getIsActiv() == YesOrNo.yes) {
            this.updateJobCron(job);
        }
        this.scheduleJobMapper.updateByPrimaryKey(job);
    }

    public void addJob(ScheduleJob job) throws SchedulerException {
        if (!this.checkEnable()) {
            return;
        }
        if (job == null || YesOrNo.yes != job.getIsActiv()) {
            return;
        }
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        this.log.debug((Object)(scheduler + ".......................................................................................add"));
        TriggerKey triggerKey = TriggerKey.triggerKey((String)job.getJobName(), (String)job.getJobGroup());
        CronTrigger trigger = (CronTrigger)scheduler.getTrigger(triggerKey);
        if (null == trigger) {
            Class clazz = YesOrNo.yes == job.getIsConcurrent() ? QuartzJobLess.class : QuartzJobFull.class;
            JobDetail jobDetail = JobBuilder.newJob(clazz).withIdentity(job.getJobName(), job.getJobGroup()).build();
            jobDetail.getJobDataMap().put(poNameInJobDataMap, (Object)job);
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getCronExpression());
            trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(job.getJobName(), job.getJobGroup()).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        } else {
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getCronExpression());
            trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
        }
    }

    private boolean checkEnable() {
        return StringUtil.isNotNull((Object)Conf.get((String)"common.micro.quartz.enable")) && "true".equals(Conf.get((String)"common.micro.quartz.enable"));
    }

    @PostConstruct
    public void init() throws Exception {
        List<ScheduleJob> jobList = this.scheduleJobMapper.getAll(YesOrNo.yes);
        for (ScheduleJob job : jobList) {
            this.addJob(job);
        }
    }

    public List<ScheduleJob> getAllJob() throws SchedulerException {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        GroupMatcher matcher = GroupMatcher.anyJobGroup();
        Set jobKeys = scheduler.getJobKeys(matcher);
        ArrayList<ScheduleJob> jobList = new ArrayList<ScheduleJob>();
        for (JobKey jobKey : jobKeys) {
            List triggers = scheduler.getTriggersOfJob(jobKey);
            for (Trigger trigger : triggers) {
                ScheduleJob job = new ScheduleJob();
                job.setJobName(jobKey.getName());
                job.setJobGroup(jobKey.getGroup());
                job.setDescription("\u89e6\u53d1\u5668:" + trigger.getKey());
                Trigger.TriggerState triggerState = scheduler.getTriggerState(trigger.getKey());
                job.setJobStatus(triggerState);
                if (trigger instanceof CronTrigger) {
                    CronTrigger cronTrigger = (CronTrigger)trigger;
                    String cronExpression = cronTrigger.getCronExpression();
                    job.setCronExpression(cronExpression);
                }
                jobList.add(job);
            }
        }
        return jobList;
    }

    public List<ScheduleJob> getRunningJob() throws SchedulerException {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        List executingJobs = scheduler.getCurrentlyExecutingJobs();
        ArrayList<ScheduleJob> jobList = new ArrayList<ScheduleJob>(executingJobs.size());
        for (JobExecutionContext executingJob : executingJobs) {
            ScheduleJob job = new ScheduleJob();
            JobDetail jobDetail = executingJob.getJobDetail();
            JobKey jobKey = jobDetail.getKey();
            Trigger trigger = executingJob.getTrigger();
            job.setJobName(jobKey.getName());
            job.setJobGroup(jobKey.getGroup());
            job.setDescription("\u89e6\u53d1\u5668:" + trigger.getKey());
            Trigger.TriggerState triggerState = scheduler.getTriggerState(trigger.getKey());
            job.setJobStatus(triggerState);
            if (trigger instanceof CronTrigger) {
                CronTrigger cronTrigger = (CronTrigger)trigger;
                String cronExpression = cronTrigger.getCronExpression();
                job.setCronExpression(cronExpression);
            }
            jobList.add(job);
        }
        return jobList;
    }

    public void pauseJob(ScheduleJob scheduleJob) throws SchedulerException {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobKey jobKey = JobKey.jobKey((String)scheduleJob.getJobName(), (String)scheduleJob.getJobGroup());
        scheduler.pauseJob(jobKey);
    }

    public void resumeJob(ScheduleJob scheduleJob) throws SchedulerException {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobKey jobKey = JobKey.jobKey((String)scheduleJob.getJobName(), (String)scheduleJob.getJobGroup());
        scheduler.resumeJob(jobKey);
    }

    public void deleteJob(ScheduleJob scheduleJob) throws SchedulerException {
        if (!this.checkEnable()) {
            return;
        }
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobKey jobKey = JobKey.jobKey((String)scheduleJob.getJobName(), (String)scheduleJob.getJobGroup());
        scheduler.deleteJob(jobKey);
    }

    public void deleteJobDb(Long jobId) {
        this.scheduleJobMapper.deleteByPrimaryKey(jobId);
    }

    public void runAJobNow(ScheduleJob scheduleJob) throws SchedulerException {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        JobKey jobKey = JobKey.jobKey((String)scheduleJob.getJobName(), (String)scheduleJob.getJobGroup());
        scheduler.triggerJob(jobKey);
    }

    public void updateJobCron(ScheduleJob scheduleJob) throws SchedulerException {
        if (!this.checkEnable()) {
            return;
        }
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        TriggerKey triggerKey = TriggerKey.triggerKey((String)scheduleJob.getJobName(), (String)scheduleJob.getJobGroup());
        CronTrigger trigger = (CronTrigger)scheduler.getTrigger(triggerKey);
        CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)scheduleJob.getCronExpression());
        trigger = (CronTrigger)trigger.getTriggerBuilder().withIdentity(triggerKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
        scheduler.rescheduleJob(triggerKey, (Trigger)trigger);
    }

    public void callBusiExe(ScheduleJob scheduleJob) {
        IJob job = null;
        if (StringUtil.isNotNull((Object)scheduleJob.getSpringName())) {
            job = (IJob)this.applicationContext.getBean(scheduleJob.getSpringName());
        } else {
            try {
                Class<?> clazz = Class.forName(scheduleJob.getBeanClass());
                job = (IJob)clazz.newInstance();
            }
            catch (Exception e) {
                this.log.error((Object)("\u5f97\u5230\u7c7b[" + scheduleJob.getBeanClass() + "]\u9519\u8bef."), (Throwable)e);
            }
        }
        if (job != null) {
            job.exe();
        }
    }
}

