/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.micro;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.stereotype.Service;

@Service
public class SpringBootAssit {
    @Autowired
    private Environment environment;
    private String[] lastConfNeedStart = new String[]{"configService:"};

    public Map<String, String> findAllProps() {
        Map<String, LinkedHashMap<String, String>> retlist = this.findAllPropsCollect();
        LinkedHashMap<String, String> allMap = new LinkedHashMap<String, String>();
        ArrayList<LinkedHashMap<String, String>> lastPut = new ArrayList<LinkedHashMap<String, String>>();
        for (String string : retlist.keySet()) {
            boolean isLast = false;
            for (String lastconf : this.lastConfNeedStart) {
                if (!string.startsWith(lastconf)) continue;
                isLast = true;
                break;
            }
            if (isLast) {
                lastPut.add(retlist.get(string));
                continue;
            }
            LinkedHashMap<String, String> tempmap = retlist.get(string);
            allMap.putAll(tempmap);
        }
        for (LinkedHashMap linkedHashMap : lastPut) {
            allMap.putAll(linkedHashMap);
        }
        return allMap;
    }

    public Map<String, LinkedHashMap<String, String>> findAllPropsCollect() {
        LinkedHashMap<String, LinkedHashMap<String, String>> result = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        for (Map.Entry<String, PropertySource<?>> entry : this.getPropertySources().entrySet()) {
            PropertySource<?> source = entry.getValue();
            String sourceName = entry.getKey();
            if (!(source instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            for (String name : enumerable.getPropertyNames()) {
                properties.put(name, String.valueOf(enumerable.getProperty(name)));
            }
            if (properties == null || !MapUtils.isNotEmpty(properties)) continue;
            result.put(sourceName, properties);
        }
        return result;
    }

    private Map<String, PropertySource<?>> getPropertySources() {
        LinkedHashMap map = new LinkedHashMap();
        MutablePropertySources sources = null;
        sources = this.environment != null && this.environment instanceof ConfigurableEnvironment ? ((ConfigurableEnvironment)this.environment).getPropertySources() : new StandardEnvironment().getPropertySources();
        for (PropertySource source : sources) {
            this.extract("", map, source);
        }
        return map;
    }

    private void extract(String root, Map<String, PropertySource<?>> map, PropertySource<?> source) {
        if (source instanceof CompositePropertySource) {
            for (PropertySource nest : ((CompositePropertySource)source).getPropertySources()) {
                this.extract(source.getName() + ":", map, nest);
            }
        } else {
            map.put(root + source.getName(), source);
        }
    }
}

