/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.micro;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.connector.executor.IBusiManager;
import net.wicp.tams.common.connector.executor.IConfigManager;
import net.wicp.tams.common.connector.executor.busi.KeyConfigManager;
import net.wicp.tams.common.connector.executor.impl.CommonService;
import net.wicp.tams.common.micro.SpringBootAssit;
import net.wicp.tams.common.micro.connector.ConnectorServlet;
import net.wicp.tams.common.micro.connector.SpringBusiManager;
import net.wicp.tams.common.micro.quartz.IScheduleJobStore;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.web.client.RestTemplate;

@Configuration
public class ConfigInit {
    private static final Logger log = LoggerFactory.getLogger(ConfigInit.class);
    public static ApplicationContext context;
    @Autowired
    private SpringBootAssit springBootAssit;

    @PostConstruct
    private void init() {
        Properties inputpamas = new Properties();
        Properties tpProps = Conf.copyProperties();
        Map<String, String> allMap = this.springBootAssit.findAllProps();
        for (Object key : tpProps.keySet()) {
            String keystr = String.valueOf(key);
            if (!allMap.containsKey(keystr)) continue;
            inputpamas.put(keystr, String.valueOf(allMap.get(keystr)));
        }
        log.info("input parmas:{}", (Object)inputpamas.toString());
        Conf.overProp((Properties)inputpamas);
    }

    @Bean
    @LoadBalanced
    @ConditionalOnProperty(name={"common.micro.restTemplate.enable"}, havingValue="true", matchIfMissing=false)
    public RestTemplate restTemplate(@Autowired RestTemplateBuilder builder) {
        return builder.build();
    }

    @Bean
    @ConditionalOnBean(value={IScheduleJobStore.class})
    public SchedulerFactoryBean quartzJob() {
        return new SchedulerFactoryBean();
    }

    @Configuration
    @ConditionalOnClass(name={"com.alibaba.druid.pool.DruidDataSource"})
    @ConditionalOnEnabledEndpoint(value="env")
    public class DruidDBConfig {
        @Bean(value={"primaryDatasource"})
        @Primary
        @ConditionalOnClass(name={"com.alibaba.druid.pool.DruidDataSource"})
        public DataSource dataSource() {
            String connectionProperties;
            DruidDataSource datasource = new DruidDataSource();
            datasource.setUrl(Conf.get((String)"common.micro.spring.datasource.url"));
            datasource.setUsername(Conf.get((String)"common.micro.spring.datasource.username"));
            datasource.setPassword(Conf.get((String)"common.micro.spring.datasource.password"));
            datasource.setDriverClassName(Conf.get((String)"common.micro.spring.datasource.driverClassName"));
            datasource.setInitialSize(Integer.parseInt(Conf.get((String)"common.micro.spring.datasource.initialSize")));
            datasource.setMinIdle(Integer.parseInt(Conf.get((String)"common.micro.spring.datasource.minIdle")));
            datasource.setMaxActive(Integer.parseInt(Conf.get((String)"common.micro.spring.datasource.maxActive")));
            datasource.setMaxWait((long)Integer.parseInt(Conf.get((String)"common.micro.spring.datasource.maxWait")));
            datasource.setTimeBetweenEvictionRunsMillis((long)Integer.parseInt(Conf.get((String)"common.micro.spring.datasource.timeBetweenEvictionRunsMillis")));
            datasource.setMinEvictableIdleTimeMillis((long)Integer.parseInt(Conf.get((String)"common.micro.spring.datasource.minEvictableIdleTimeMillis")));
            datasource.setValidationQuery(Conf.get((String)"common.micro.spring.datasource.validationQuery"));
            datasource.setTestWhileIdle(Boolean.getBoolean(Conf.get((String)"common.micro.spring.datasource.testWhileIdle")));
            datasource.setTestOnBorrow(Boolean.getBoolean(Conf.get((String)"common.micro.spring.datasource.testOnBorrow")));
            datasource.setTestOnReturn(Boolean.getBoolean(Conf.get((String)"common.micro.spring.datasource.testOnReturn")));
            datasource.setPoolPreparedStatements(Boolean.getBoolean(Conf.get((String)"common.micro.spring.datasource.poolPreparedStatements")));
            datasource.setMaxPoolPreparedStatementPerConnectionSize(Integer.parseInt(Conf.get((String)"common.micro.spring.datasource.maxPoolPreparedStatementPerConnectionSize")));
            String filters = Conf.get((String)"common.micro.spring.datasource.filters");
            if (StringUtils.isNotBlank((CharSequence)filters) && !"none".equals(filters)) {
                try {
                    datasource.setFilters(filters);
                }
                catch (SQLException e) {
                    log.error("druid configuration initialization filter", (Throwable)e);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(connectionProperties = Conf.get((String)"common.micro.spring.datasource.connectionProperties"))) && !"none".equals(connectionProperties)) {
                datasource.setConnectionProperties(connectionProperties);
            }
            return datasource;
        }
    }

    @Configuration
    @ConditionalOnClass(value={CommonService.class})
    @Order(value=0x7FFFFFFF)
    public class ConnectionConfig {
        @Bean
        @ConditionalOnMissingBean
        protected IConfigManager createIConfigManager() {
            KeyConfigManager manage = new KeyConfigManager();
            return manage;
        }

        @Bean
        protected CommonService createExecutor(ApplicationContext context, IConfigManager configManager) {
            CommonService executor = new CommonService();
            SpringBusiManager busi = new SpringBusiManager(context);
            executor.setBusiManager((IBusiManager)busi);
            executor.setConfigManager(configManager);
            return executor;
        }

        @Bean
        public ConnectorServlet servlet() {
            return new ConnectorServlet();
        }

        @Bean
        public ServletRegistrationBean confServlet(ConnectorServlet servlet) {
            ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)servlet, new String[0]);
            registration.setEnabled(true);
            registration.addUrlMappings(new String[]{"/connector"});
            return registration;
        }
    }

    @Configuration
    @Order(value=-2147483648)
    protected class InitContext
    implements ApplicationContextAware {
        protected InitContext() {
        }

        public void setApplicationContext(ApplicationContext arg0) throws BeansException {
            context = arg0;
        }
    }
}

