package net.wicp.tams.common.micro.connector.quartz;

import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.connector.beans.CusDynaBean;
import net.wicp.tams.common.connector.executor.IBusiApp;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.micro.quartz.JobTaskService;
import net.wicp.tams.common.micro.quartz.bean.ScheduleJob;

@Service(value = "quartz.delete")
@Slf4j
@ConditionalOnProperty(name = "common.micro.quartz.enable", havingValue = "true")
public class QuartzDelete implements IBusiApp {
	@Autowired
	private JobTaskService jobTaskService;

	@Override
	public CusDynaBean exe(CusDynaBean inputBean, CusDynaBean outBeanOri) throws ProjectException {
		String jobName = inputBean.getStrValueByName("jobName");
		String jobGroup = inputBean.getStrValueByName("jobGroup");

		ScheduleJob job = jobTaskService.getTaskByGroupAndName(jobGroup, jobName);
		try {
			jobTaskService.deleteJob(job);
			jobTaskService.deleteJobDb(job.getId());
			outBeanOri.setResult(Result.getSuc());
		} catch (SchedulerException e) {
			log.error("删除job错误", e);
			outBeanOri.setResult(Result.getError(e.getMessage()));
		}
		return outBeanOri;
	}
}
