/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.micro;

import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.connector.executor.IBusiManager;
import net.wicp.tams.common.connector.executor.IConfigManager;
import net.wicp.tams.common.connector.executor.busi.KeyConfigManager;
import net.wicp.tams.common.connector.executor.busi.SpringBusiManager;
import net.wicp.tams.common.connector.executor.impl.CommonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration
public class ConfigInit {
    private static final Logger log = LoggerFactory.getLogger(ConfigInit.class);

    @Configuration
    @ConditionalOnClass(name={"com.alibaba.druid.pool.DruidDataSource"})
    public class DruidDBConfig {
        @Value(value="${spring.datasource.url}")
        private String dbUrl;
        @Value(value="${spring.datasource.username}")
        private String username;
        @Value(value="${spring.datasource.password}")
        private String password;
        @Value(value="${spring.datasource.driverClassName}")
        private String driverClassName;
        @Value(value="${spring.datasource.initialSize}")
        private int initialSize;
        @Value(value="${spring.datasource.minIdle}")
        private int minIdle;
        @Value(value="${spring.datasource.maxActive}")
        private int maxActive;
        @Value(value="${spring.datasource.maxWait}")
        private int maxWait;
        @Value(value="${spring.datasource.timeBetweenEvictionRunsMillis}")
        private int timeBetweenEvictionRunsMillis;
        @Value(value="${spring.datasource.minEvictableIdleTimeMillis}")
        private int minEvictableIdleTimeMillis;
        @Value(value="${spring.datasource.validationQuery}")
        private String validationQuery;
        @Value(value="${spring.datasource.testWhileIdle}")
        private boolean testWhileIdle;
        @Value(value="${spring.datasource.testOnBorrow}")
        private boolean testOnBorrow;
        @Value(value="${spring.datasource.testOnReturn}")
        private boolean testOnReturn;
        @Value(value="${spring.datasource.poolPreparedStatements}")
        private boolean poolPreparedStatements;
        @Value(value="${spring.datasource.maxPoolPreparedStatementPerConnectionSize:5}")
        private int maxPoolPreparedStatementPerConnectionSize;
        @Value(value="${spring.datasource.filters:}")
        private String filters;
        @Value(value="{spring.datasource.connectionProperties:}")
        private String connectionProperties;

        @Bean
        @Primary
        @ConditionalOnClass(name={"com.alibaba.druid.pool.DruidDataSource"})
        public DataSource dataSource() {
            DruidDataSource datasource = new DruidDataSource();
            datasource.setUrl(this.dbUrl);
            datasource.setUsername(this.username);
            datasource.setPassword(this.password);
            datasource.setDriverClassName(this.driverClassName);
            datasource.setInitialSize(this.initialSize);
            datasource.setMinIdle(this.minIdle);
            datasource.setMaxActive(this.maxActive);
            datasource.setMaxWait((long)this.maxWait);
            datasource.setTimeBetweenEvictionRunsMillis((long)this.timeBetweenEvictionRunsMillis);
            datasource.setMinEvictableIdleTimeMillis((long)this.minEvictableIdleTimeMillis);
            datasource.setValidationQuery(this.validationQuery);
            datasource.setTestWhileIdle(this.testWhileIdle);
            datasource.setTestOnBorrow(this.testOnBorrow);
            datasource.setTestOnReturn(this.testOnReturn);
            datasource.setPoolPreparedStatements(this.poolPreparedStatements);
            datasource.setMaxPoolPreparedStatementPerConnectionSize(this.maxPoolPreparedStatementPerConnectionSize);
            try {
                datasource.setFilters(this.filters);
            }
            catch (SQLException e) {
                log.error("druid configuration initialization filter", (Throwable)e);
            }
            datasource.setConnectionProperties(this.connectionProperties);
            return datasource;
        }
    }

    @Configuration
    @ConditionalOnClass(value={CommonService.class})
    @Order(value=0x7FFFFFFF)
    public class ConnectionConfig {
        @Bean
        @ConditionalOnMissingBean
        protected IConfigManager createIConfigManager() {
            KeyConfigManager manage = new KeyConfigManager();
            return manage;
        }

        @Bean
        protected CommonService createExecutor(ApplicationContext context, IConfigManager configManager) {
            CommonService executor = new CommonService();
            SpringBusiManager busi = new SpringBusiManager(context);
            executor.setBusiManager((IBusiManager)busi);
            executor.setConfigManager(configManager);
            return executor;
        }
    }

    @Configuration
    @Order(value=-2147483648)
    protected class InitContext
    implements ApplicationContextAware,
    EnvironmentAware {
        protected InitContext() {
        }

        public void setEnvironment(Environment environment) {
            Properties inputpamas = new Properties();
            Properties tpProps = Conf.copyProperties();
            for (Object key : tpProps.keySet()) {
                String keystr = String.valueOf(key);
                if (!environment.containsProperty(keystr)) continue;
                inputpamas.put(keystr, environment.getProperty(keystr));
            }
            log.info("input parmas:{}", (Object)inputpamas.toString());
            Conf.overProp((Properties)inputpamas);
        }

        public void setApplicationContext(ApplicationContext arg0) throws BeansException {
        }
    }
}

