/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.metrics.core;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.metrics.entity.statisticbean.StatisticCounterBean;
import net.wicp.tams.common.metrics.entity.statisticbean.StatisticGaugeBean;
import net.wicp.tams.common.metrics.entity.statisticbean.StatisticHistogramBean;
import net.wicp.tams.common.metrics.entity.statisticbean.StatisticMeterBean;
import net.wicp.tams.common.metrics.entity.statisticbean.StatisticTimerBean;

public class TsMetricsSerializer
extends Module {
    static final Version VERSION = new Version(3, 0, 0, "", "com.codahale.metrics", "metrics-json");
    private final TimeUnit rateUnit;
    private final TimeUnit durationUnit;
    private final boolean showSamples;
    private final MetricFilter filter;

    public TsMetricsSerializer(TimeUnit rateUnit, TimeUnit durationUnit, boolean showSamples) {
        this(rateUnit, durationUnit, showSamples, MetricFilter.ALL);
    }

    public TsMetricsSerializer(TimeUnit rateUnit, TimeUnit durationUnit, boolean showSamples, MetricFilter filter) {
        this.rateUnit = rateUnit;
        this.durationUnit = durationUnit;
        this.showSamples = showSamples;
        this.filter = filter;
    }

    public String getModuleName() {
        return "metrics";
    }

    public Version version() {
        return VERSION;
    }

    public void setupModule(Module.SetupContext context) {
        context.addSerializers((Serializers)new SimpleSerializers(Arrays.asList(new JsonSerializer[]{new StatisticGaugeBeanSerializer(), new StatisticCounterBeanSerializer(), new StatisticHistogramBeanSerializer(this.showSamples), new StatisticMeterBeanSerializer(this.rateUnit), new StatisticTimerBeanSerializer(this.rateUnit, this.durationUnit, this.showSamples), new MetricRegistrySerializer(this.filter)})));
    }

    private static String calculateRateUnit(TimeUnit unit, String name) {
        String s = unit.toString().toLowerCase(Locale.US);
        return name + '/' + s.substring(0, s.length() - 1);
    }

    private static class MetricRegistrySerializer
    extends StdSerializer<MetricRegistry> {
        private final MetricFilter filter;

        private MetricRegistrySerializer(MetricFilter filter) {
            super(MetricRegistry.class);
            this.filter = filter;
        }

        public void serialize(MetricRegistry registry, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeStringField("version", VERSION.toString());
            json.writeObjectField("gauges", (Object)registry.getGauges(this.filter));
            json.writeObjectField("counters", (Object)registry.getCounters(this.filter));
            json.writeObjectField("histograms", (Object)registry.getHistograms(this.filter));
            json.writeObjectField("meters", (Object)registry.getMeters(this.filter));
            json.writeObjectField("timers", (Object)registry.getTimers(this.filter));
            json.writeEndObject();
        }
    }

    private static class StatisticTimerBeanSerializer
    extends StdSerializer<StatisticTimerBean> {
        private final String rateUnit;
        private final double rateFactor;
        private final String durationUnit;
        private final double durationFactor;
        private final boolean showSamples;

        private StatisticTimerBeanSerializer(TimeUnit rateUnit, TimeUnit durationUnit, boolean showSamples) {
            super(StatisticTimerBean.class);
            this.rateUnit = TsMetricsSerializer.calculateRateUnit(rateUnit, "calls");
            this.rateFactor = rateUnit.toSeconds(1L);
            this.durationUnit = durationUnit.toString().toLowerCase(Locale.US);
            this.durationFactor = 1.0 / (double)durationUnit.toNanos(1L);
            this.showSamples = showSamples;
        }

        public void serialize(StatisticTimerBean statisticTimerBean, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            Snapshot snapshot = statisticTimerBean.getTimer().getSnapshot();
            json.writeStringField("name", statisticTimerBean.getName());
            json.writeStringField("type", "TIMER");
            json.writeNumberField("count", statisticTimerBean.getTimer().getCount());
            json.writeNumberField("max", (double)snapshot.getMax() * this.durationFactor);
            json.writeNumberField("mean", snapshot.getMean() * this.durationFactor);
            json.writeNumberField("min", (double)snapshot.getMin() * this.durationFactor);
            json.writeNumberField("p50", snapshot.getMedian() * this.durationFactor);
            json.writeNumberField("p75", snapshot.get75thPercentile() * this.durationFactor);
            json.writeNumberField("p95", snapshot.get95thPercentile() * this.durationFactor);
            json.writeNumberField("p98", snapshot.get98thPercentile() * this.durationFactor);
            json.writeNumberField("p99", snapshot.get99thPercentile() * this.durationFactor);
            json.writeNumberField("p999", snapshot.get999thPercentile() * this.durationFactor);
            if (this.showSamples) {
                long[] values = snapshot.getValues();
                double[] scaledValues = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    scaledValues[i] = (double)values[i] * this.durationFactor;
                }
                json.writeObjectField("values", (Object)scaledValues);
            }
            json.writeNumberField("stddev", snapshot.getStdDev() * this.durationFactor);
            json.writeNumberField("m15_rate", statisticTimerBean.getTimer().getFifteenMinuteRate() * this.rateFactor);
            json.writeNumberField("m1_rate", statisticTimerBean.getTimer().getOneMinuteRate() * this.rateFactor);
            json.writeNumberField("m5_rate", statisticTimerBean.getTimer().getFiveMinuteRate() * this.rateFactor);
            json.writeNumberField("mean_rate", statisticTimerBean.getTimer().getMeanRate() * this.rateFactor);
            json.writeStringField("duration_units", this.durationUnit);
            json.writeStringField("rate_units", this.rateUnit);
            json.writeEndObject();
        }
    }

    private static class StatisticMeterBeanSerializer
    extends StdSerializer<StatisticMeterBean> {
        private final String rateUnit;
        private final double rateFactor;

        public StatisticMeterBeanSerializer(TimeUnit rateUnit) {
            super(StatisticMeterBean.class);
            this.rateFactor = rateUnit.toSeconds(1L);
            this.rateUnit = TsMetricsSerializer.calculateRateUnit(rateUnit, "events");
        }

        public void serialize(StatisticMeterBean statisticMeterBean, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeStringField("name", statisticMeterBean.getName());
            json.writeStringField("type", "METER");
            json.writeNumberField("count", statisticMeterBean.getMeter().getCount());
            json.writeNumberField("m15_rate", statisticMeterBean.getMeter().getFifteenMinuteRate() * this.rateFactor);
            json.writeNumberField("m1_rate", statisticMeterBean.getMeter().getOneMinuteRate() * this.rateFactor);
            json.writeNumberField("m5_rate", statisticMeterBean.getMeter().getFiveMinuteRate() * this.rateFactor);
            json.writeNumberField("mean_rate", statisticMeterBean.getMeter().getMeanRate() * this.rateFactor);
            json.writeStringField("units", this.rateUnit);
            json.writeEndObject();
        }
    }

    private static class StatisticHistogramBeanSerializer
    extends StdSerializer<StatisticHistogramBean> {
        private final boolean showSamples;

        private StatisticHistogramBeanSerializer(boolean showSamples) {
            super(StatisticHistogramBean.class);
            this.showSamples = showSamples;
        }

        public void serialize(StatisticHistogramBean statisticHistogramBean, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            Snapshot snapshot = statisticHistogramBean.getHistogram().getSnapshot();
            json.writeStringField("name", statisticHistogramBean.getName());
            json.writeStringField("type", "HISTOGRAM");
            json.writeNumberField("count", statisticHistogramBean.getHistogram().getCount());
            json.writeNumberField("max", snapshot.getMax());
            json.writeNumberField("mean", snapshot.getMean());
            json.writeNumberField("min", snapshot.getMin());
            json.writeNumberField("p50", snapshot.getMedian());
            json.writeNumberField("p75", snapshot.get75thPercentile());
            json.writeNumberField("p95", snapshot.get95thPercentile());
            json.writeNumberField("p98", snapshot.get98thPercentile());
            json.writeNumberField("p99", snapshot.get99thPercentile());
            json.writeNumberField("p999", snapshot.get999thPercentile());
            if (this.showSamples) {
                json.writeObjectField("values", (Object)snapshot.getValues());
            }
            json.writeNumberField("stddev", snapshot.getStdDev());
            json.writeEndObject();
        }
    }

    private static class StatisticCounterBeanSerializer
    extends StdSerializer<StatisticCounterBean> {
        private StatisticCounterBeanSerializer() {
            super(StatisticCounterBean.class);
        }

        public void serialize(StatisticCounterBean statisticCounterBean, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeStringField("name", statisticCounterBean.getName());
            json.writeStringField("type", "COUNTER");
            json.writeNumberField("count", statisticCounterBean.getCounter().getCount());
            json.writeEndObject();
        }
    }

    private static class StatisticGaugeBeanSerializer
    extends StdSerializer<StatisticGaugeBean> {
        private StatisticGaugeBeanSerializer() {
            super(StatisticGaugeBean.class);
        }

        public void serialize(StatisticGaugeBean statisticGaugeBean, JsonGenerator json, SerializerProvider provider) throws IOException {
            json.writeStartObject();
            json.writeStringField("name", statisticGaugeBean.getName());
            json.writeStringField("type", "GAUGE");
            try {
                Object value = statisticGaugeBean.getGauge().getValue();
                json.writeObjectField("value", value);
            }
            catch (RuntimeException e) {
                json.writeObjectField("error", (Object)e.toString());
            }
            json.writeEndObject();
        }
    }
}

