/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.metrics.annotation;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.metrics.core.TsMetricAbstractGroup;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@Order(value=0x7FFFFFFF)
public class MetricsConfig {
    @Bean
    public TsMetricAbstractGroup metrics() {
        System.setProperty("metricsfilename", Conf.get((String)"common.metrics.sink.json.env_file_name"));
        System.setProperty("metricspath", Conf.get((String)"common.metrics.sink.json.env_file_root"));
        return new TamsMetricAbstractGroup(Conf.get((String)"common.metrics.sink.json.serviceName"));
    }

    private class TamsMetricAbstractGroup
    extends TsMetricAbstractGroup {
        @Override
        public <T> Gauge<T> newGauge(Gauge<T> gauge, Class<?> tClass, String metricUniqMark) {
            Gauge newGauge = null;
            try {
                newGauge = super.newGauge(gauge, tClass, metricUniqMark);
            }
            catch (Throwable e) {
                String name = this.metricName(tClass, metricUniqMark);
                Metric metric = (Metric)super.getMetrics().getMetrics().get(name);
                newGauge = (Gauge)metric;
            }
            return newGauge;
        }

        public TamsMetricAbstractGroup(String serviceName) {
            super(serviceName);
        }
    }
}

