/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.metrics.utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsLogger {
    public static final String TS_LOGGER_NAME = "net.wicp.tams.common.metrics";
    public static final String ENV_FILE_NAME = "metricsfilename";
    public static final String ENV_FILE_ROOT = "metricspath";
    private static Logger log;

    private static void initializeLogger() {
        if (System.getProperty(ENV_FILE_ROOT) == null || "".equals(System.getProperty(ENV_FILE_ROOT))) {
            String logRoot = System.getenv(ENV_FILE_ROOT);
            logRoot = logRoot == null || "".equals(logRoot) ? "/alidata1/admin" : logRoot;
            System.setProperty(ENV_FILE_ROOT, logRoot);
        }
        if (System.getProperty(ENV_FILE_NAME) == null || "".equals(System.getProperty(ENV_FILE_NAME))) {
            System.setProperty(ENV_FILE_NAME, "ts_statistic");
        } else {
            System.setProperty(ENV_FILE_NAME, System.getProperty(ENV_FILE_NAME).replace(".log", ""));
        }
        String logConfigFilePath = System.getProperty("ts.log.configFile", System.getenv("TS_LOG_CONFIGFILE"));
        Boolean isLoadConfig = Boolean.parseBoolean(System.getProperty("ts.log.loadconfig", "true"));
        String log4j_resource_file = System.getProperty("ts.log4j.resource.fileName", "logger/log4j_ts_clients.xml");
        String logback_resource_file = System.getProperty("ts.logback.resource.fileName", "logger/logback_ts_clients.xml");
        String log4j2_resource_file = System.getProperty("ts.log4j2.resource.fileName", "logger/log4j2_ts_clients.xml");
        if (isLoadConfig.booleanValue()) {
            try {
                ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
                Class<?> classType = iLoggerFactory.getClass();
                if (classType.getName().equals("org.slf4j.impl.Log4jLoggerFactory")) {
                    Class<?> DOMConfigurator = null;
                    Object DOMConfiguratorObj = null;
                    DOMConfigurator = Class.forName("org.apache.log4j.xml.DOMConfigurator");
                    DOMConfiguratorObj = DOMConfigurator.newInstance();
                    if (null == logConfigFilePath) {
                        Method configure = DOMConfiguratorObj.getClass().getMethod("configure", URL.class);
                        URL url = TsLogger.class.getClassLoader().getResource(log4j_resource_file);
                        configure.invoke(DOMConfiguratorObj, url);
                    } else {
                        Method configure = DOMConfiguratorObj.getClass().getMethod("configure", String.class);
                        configure.invoke(DOMConfiguratorObj, logConfigFilePath);
                    }
                } else if (classType.getName().equals("ch.qos.logback.classic.LoggerContext")) {
                    Class<?> joranConfigurator = null;
                    Class<?> context = Class.forName("ch.qos.logback.core.Context");
                    Object joranConfiguratorObj = null;
                    joranConfigurator = Class.forName("ch.qos.logback.classic.joran.JoranConfigurator");
                    joranConfiguratorObj = joranConfigurator.newInstance();
                    Method setContext = joranConfiguratorObj.getClass().getMethod("setContext", context);
                    setContext.invoke(joranConfiguratorObj, iLoggerFactory);
                    if (null == logConfigFilePath) {
                        URL url = TsLogger.class.getClassLoader().getResource(logback_resource_file);
                        Method doConfigure = joranConfiguratorObj.getClass().getMethod("doConfigure", URL.class);
                        doConfigure.invoke(joranConfiguratorObj, url);
                    } else {
                        Method doConfigure = joranConfiguratorObj.getClass().getMethod("doConfigure", String.class);
                        doConfigure.invoke(joranConfiguratorObj, logConfigFilePath);
                    }
                } else if (classType.getName().equals("org.apache.logging.slf4j.Log4jLoggerFactory")) {
                    Class<?> configurationSourceCls = Class.forName("org.apache.logging.log4j.core.config.ConfigurationSource");
                    Class<?> xmlConfigurationCls = Class.forName("org.apache.logging.log4j.core.config.xml.XmlConfiguration");
                    Class<?> configurationCls = Class.forName("org.apache.logging.log4j.core.config.Configuration");
                    Class<?> loggerContextCls = Class.forName("org.apache.logging.log4j.core.LoggerContext");
                    Class<?> log4jLoggerCls = Class.forName("org.apache.logging.slf4j.Log4jLogger");
                    Class<?> extendedLoggerCls = Class.forName("org.apache.logging.log4j.spi.ExtendedLogger");
                    Constructor<?> configSourceConstructor = configurationSourceCls.getDeclaredConstructor(InputStream.class);
                    Constructor<?> xmlConfigurationConstructor = xmlConfigurationCls.getDeclaredConstructor(configurationSourceCls);
                    Constructor<?> loggerContextConstructor = loggerContextCls.getDeclaredConstructor(String.class);
                    Constructor<?> log4jLoggerConstructor = log4jLoggerCls.getDeclaredConstructor(extendedLoggerCls, String.class);
                    InputStream configFileInput = null;
                    configFileInput = null == logConfigFilePath ? TsLogger.class.getClassLoader().getResourceAsStream(log4j2_resource_file) : new FileInputStream(new File(logConfigFilePath));
                    Object configurationSourceInst = configSourceConstructor.newInstance(configFileInput);
                    Object xmlConfigurationInst = xmlConfigurationConstructor.newInstance(configurationSourceInst);
                    Object loggerContextInst = loggerContextConstructor.newInstance(TsLogger.class.getName());
                    Method loggerContextStartMethod = loggerContextCls.getDeclaredMethod("start", configurationCls);
                    loggerContextStartMethod.invoke(loggerContextInst, xmlConfigurationInst);
                    Method loggerContextGetLoggerMethod = loggerContextCls.getDeclaredMethod("getLogger", String.class);
                    log = (Logger)log4jLoggerConstructor.newInstance(loggerContextGetLoggerMethod.invoke(loggerContextInst, TS_LOGGER_NAME), TS_LOGGER_NAME);
                    return;
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        log = LoggerFactory.getLogger((String)TS_LOGGER_NAME);
    }

    public static Logger getTamsLogger() {
        return log;
    }

    static {
        TsLogger.initializeLogger();
    }
}

