/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.metrics.constant;

import com.alibaba.fastjson.JSONObject;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleCollector;
import io.prometheus.client.Summary;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.metrics.callback.IPrometheusMetricsCreator;
import org.apache.commons.lang3.StringUtils;

public enum MetricsType implements IEnumCombobox
{
    counter("\u53ea\u589e\u4e0d\u51cf\u7684\u8ba1\u6570\u5668", new IPrometheusMetricsCreator<Counter.Builder>(){

        @Override
        public Counter.Builder getMetricsBuild(String name, String help, String ... lables) {
            return (Counter.Builder)Counter.build((String)name, (String)help).labelNames(lables);
        }
    }),
    gauge("\u53ef\u589e\u53ef\u51cf\u7684\u4eea\u8868\u76d8", new IPrometheusMetricsCreator<Gauge.Builder>(){

        @Override
        public Gauge.Builder getMetricsBuild(String name, String help, String ... lables) {
            return (Gauge.Builder)Gauge.build((String)name, (String)help).labelNames(lables);
        }
    }),
    histogram("\u67f1\u72b6\u56fe", new IPrometheusMetricsCreator<Histogram.Builder>(){

        @Override
        public Histogram.Builder getMetricsBuild(String name, String help, String ... lables) {
            return (Histogram.Builder)Histogram.build((String)name, (String)help).labelNames(lables);
        }
    }),
    summary("\u6458\u8981\u5206\u6790", new IPrometheusMetricsCreator<Summary.Builder>(){

        @Override
        public Summary.Builder getMetricsBuild(String name, String help, String ... lables) {
            return (Summary.Builder)Summary.build((String)name, (String)help).labelNames(lables);
        }
    });

    private final String desc;
    private final IPrometheusMetricsCreator<?> metricsCreator;

    public IPrometheusMetricsCreator<?> getMetricsCreator() {
        return this.metricsCreator;
    }

    private MetricsType(String desc, IPrometheusMetricsCreator<?> metricsCreator) {
        this.desc = desc;
        this.metricsCreator = metricsCreator;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name();
    }

    public SimpleCollector.Builder buildMitrices(String name, String help, JSONObject lables) {
        String[] values = JSONUtil.getValues((JSONObject)lables);
        return this.metricsCreator.getMetricsBuild(name, help, values);
    }

    public SimpleCollector.Builder buildMitrices(String name, String help, String ... lables) {
        return this.metricsCreator.getMetricsBuild(name, help, lables);
    }

    public void doWith(SimpleCollector simpleCollector, String value) {
        switch (this) {
            case counter: {
                Counter c = (Counter)simpleCollector;
                c.inc(Double.parseDouble(value));
                break;
            }
            case gauge: {
                Gauge g = (Gauge)simpleCollector;
                g.set(Double.parseDouble(value));
                break;
            }
        }
    }

    public String getDesc_zh() {
        return this.desc;
    }

    public String getDesc_en() {
        return this.name();
    }

    public static MetricsType find(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        for (MetricsType ele : MetricsType.values()) {
            if (!name.equalsIgnoreCase(ele.name())) continue;
            return ele;
        }
        return null;
    }
}

