/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.metrics.annotation;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import net.wicp.tams.common.metrics.annotation.CounterTams;
import net.wicp.tams.common.metrics.annotation.GaugeTams;
import net.wicp.tams.common.metrics.annotation.HistogramTams;
import net.wicp.tams.common.metrics.annotation.MeterTams;
import net.wicp.tams.common.metrics.annotation.TimerTams;
import net.wicp.tams.common.metrics.core.TsMetricAbstractGroup;
import net.wicp.tams.common.spring.autoconfig.beans.FieldBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsAnnotationDo
extends FieldBean<Object> {
    private static final Logger log = LoggerFactory.getLogger(MetricsAnnotationDo.class);

    public MetricsAnnotationDo(Annotation annotationInst, Field field) {
        super(annotationInst, field);
    }

    private Class getClass(Class classz, boolean isThisClass) {
        if (classz.getName().equals("java.lang.Object")) {
            if (isThisClass) {
                return this.field.getDeclaringClass();
            }
            return TsMetricAbstractGroup.class;
        }
        return classz;
    }

    public Object doWithAnnotation() {
        TsMetricAbstractGroup tsgroup = (TsMetricAbstractGroup)this.applicationContext.getBean(TsMetricAbstractGroup.class);
        Gauge<Integer> metric = null;
        if (this.annotationInst instanceof CounterTams) {
            CounterTams counterTams = (CounterTams)this.annotationInst;
            metric = tsgroup.newCounter(this.getClass(counterTams.classz(), counterTams.isThisClass()), counterTams.value());
        } else if (this.annotationInst instanceof MeterTams) {
            MeterTams meterTams = (MeterTams)this.annotationInst;
            metric = tsgroup.newMeter(this.getClass(meterTams.classz(), meterTams.isThisClass()), meterTams.value());
        } else if (this.annotationInst instanceof HistogramTams) {
            HistogramTams histogramTams = (HistogramTams)this.annotationInst;
            metric = tsgroup.newHistogram(this.getClass(histogramTams.classz(), histogramTams.isThisClass()), histogramTams.value());
        } else if (this.annotationInst instanceof TimerTams) {
            TimerTams timerTams = (TimerTams)this.annotationInst;
            metric = tsgroup.newTimer(this.getClass(timerTams.classz(), timerTams.isThisClass()), timerTams.value());
        } else if (this.annotationInst instanceof GaugeTams) {
            GaugeTams gaugeTams = (GaugeTams)this.annotationInst;
            final Counter newCounter = tsgroup.newCounter(this.getClass(gaugeTams.classz(), gaugeTams.isThisClass()), gaugeTams.counterValue());
            metric = tsgroup.newGauge(new Gauge<Integer>(){

                public Integer getValue() {
                    return (int)newCounter.getCount();
                }
            }, this.getClass(gaugeTams.classz(), gaugeTams.isThisClass()), gaugeTams.value());
        }
        log.info("the field:{} has inited", (Object)this.field.getName());
        return metric;
    }
}

