/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.metrics.constant;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSONObject;

import io.prometheus.client.SimpleCollector;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.metrics.callback.IPrometheusMetricsCreator;

/***
 * 是与否枚举
 * 
 * @author andy.zhou
 * 
 */
@SuppressWarnings("rawtypes")
public enum MetricsType implements IEnumCombobox {
	counter("只增不减的计数器", new IPrometheusMetricsCreator<io.prometheus.client.Counter.Builder>() {
		public io.prometheus.client.Counter.Builder getMetricsBuild(String name,String help, String... lables) {
			return io.prometheus.client.Counter.build(name,help).labelNames(lables);
		}
	}),

	gauge("可增可减的仪表盘", new IPrometheusMetricsCreator<io.prometheus.client.Gauge.Builder>() {
		public io.prometheus.client.Gauge.Builder getMetricsBuild(String name,String help, String... lables) {
			return io.prometheus.client.Gauge.build(name,help).labelNames(lables);
		}
	}),

	histogram("柱状图", new IPrometheusMetricsCreator<io.prometheus.client.Histogram.Builder>() {
		public io.prometheus.client.Histogram.Builder getMetricsBuild(String name,String help, String... lables) {
			return io.prometheus.client.Histogram.build(name,help).labelNames(lables);
		}
	}),

	summary("摘要分析", new IPrometheusMetricsCreator<io.prometheus.client.Summary.Builder>() {
		public io.prometheus.client.Summary.Builder getMetricsBuild(String name,String help, String... lables) {
			return io.prometheus.client.Summary.build(name,help).labelNames(lables);
		}
	});

	private final String desc;

	private final IPrometheusMetricsCreator<?> metricsCreator;// 得到相关的metricsBuild

	public IPrometheusMetricsCreator<?> getMetricsCreator() {
		return metricsCreator;
	}

	private MetricsType(String desc, IPrometheusMetricsCreator<?> metricsCreator) {
		this.desc = desc;
		this.metricsCreator = metricsCreator;
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	public SimpleCollector.Builder buildMitrices(String name, String help, JSONObject lables) {
		String[] values = JSONUtil.getValues(lables);
		return this.metricsCreator.getMetricsBuild(name, help, values);
	}

	public SimpleCollector.Builder buildMitrices(String name, String help, String... lables) {
		return this.metricsCreator.getMetricsBuild(name, help, lables);
	}

	public void doWith(SimpleCollector simpleCollector, String value) {
		switch (this) {
		case counter:
			io.prometheus.client.Counter c = (io.prometheus.client.Counter) simpleCollector;
			c.inc(Double.parseDouble(value));
			break;
		case gauge:
			io.prometheus.client.Gauge g = (io.prometheus.client.Gauge) simpleCollector;
			g.set(Double.parseDouble(value));
			break;
		default:
			break;
		}
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public static MetricsType find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (MetricsType ele : MetricsType.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}
}
