/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.metrics.core;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import metrics_influxdb.HttpInfluxdbProtocol;
import metrics_influxdb.InfluxdbProtocol;
import metrics_influxdb.InfluxdbReporter;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.metrics.constant.ReportType;
import net.wicp.tams.common.metrics.core.JsonReporter;
import net.wicp.tams.common.metrics.utility.TsLogger;
import net.wicp.tams.common.metrics.utility.Utils;

public class TsMetricFacotory {
    private static final MetricRegistry metrics = new MetricRegistry();
    private final String factoryId;
    private final String IpAddress;
    private final String serviceName;

    public TsMetricFacotory(String serviceName) {
        this.serviceName = serviceName;
        this.factoryId = String.format("%d_%d", Utils.getPid(), System.currentTimeMillis());
        this.IpAddress = Utils.getLocalAddress();
    }

    protected String getIpAddress() {
        return this.IpAddress;
    }

    protected String getFactoryId() {
        return this.factoryId;
    }

    protected String getServiceName() {
        return this.serviceName;
    }

    protected MetricRegistry getMetrics() {
        return metrics;
    }

    public Counter newCounter(Class<?> tClass, String metricUniqMark) {
        String name = this.metricName(tClass, metricUniqMark);
        return metrics.counter(name);
    }

    public Histogram newHistogram(Class<?> tClass, String metricUniqMark) {
        String name = this.metricName(tClass, metricUniqMark);
        return metrics.histogram(name);
    }

    public <T> Gauge<T> newGauge(Gauge<T> gauge, Class<?> tClass, String metricUniqMark) {
        String name = this.metricName(tClass, metricUniqMark);
        return (Gauge)metrics.register(name, gauge);
    }

    public Meter newMeter(Class<?> tClass, String metricUniqMark) {
        String name = this.metricName(tClass, metricUniqMark);
        return metrics.meter(name);
    }

    public Timer newTimer(Class<?> tClass, String metricUniqMark) {
        String name = this.metricName(tClass, metricUniqMark);
        return metrics.timer(name);
    }

    protected String metricName(Class<?> tClass, String metricUniqMark) {
        String name = MetricRegistry.name((String)this.IpAddress, (String[])new String[]{this.serviceName, String.valueOf(this.factoryId), tClass.getName(), metricUniqMark});
        return name;
    }

    public void destroyAllMetrics() {
        String rmNameTags = MetricRegistry.name((String)this.IpAddress, (String[])new String[]{this.serviceName, String.valueOf(this.factoryId)});
        this.removeMetrics(rmNameTags);
    }

    public void destroyMetricByMark(String metricUniqMark) {
        String rmNameTags = MetricRegistry.name((String)this.IpAddress, (String[])new String[]{this.serviceName, String.valueOf(this.factoryId), ".*", metricUniqMark});
        this.removeMetrics(rmNameTags);
    }

    public void destroyMetric(final Metric pMetric) {
        metrics.removeMatching(new MetricFilter(){

            public boolean matches(String name, Metric metric) {
                return pMetric == metric;
            }
        });
    }

    private final void removeMetrics(String rmNameTags) {
        final Pattern rmPat = Pattern.compile(".*" + rmNameTags + ".*");
        metrics.removeMatching(new MetricFilter(){

            public boolean matches(String name, Metric metric) {
                return rmPat.matcher(name).matches();
            }
        });
    }

    static {
        ReportType sink = (ReportType)Conf.getEnum(ReportType.class, (String)"common.metrics.sink");
        TimeUnit rateUnit = (TimeUnit)Conf.getEnum(TimeUnit.class, (String)"common.metrics.rateUnit");
        Integer period = Conf.getInt((String)"common.metrics.period");
        TimeUnit unit = (TimeUnit)Conf.getEnum(TimeUnit.class, (String)"common.metrics.unit");
        TimeUnit durationsTo = (TimeUnit)Conf.getEnum(TimeUnit.class, (String)"common.metrics.durationsTo");
        switch (sink) {
            case json: {
                JsonReporter reporter = JsonReporter.forRegistry(metrics).outputTo(TsLogger.getTamsLogger()).convertRatesTo(rateUnit).convertDurationsTo(durationsTo).build();
                reporter.start(period.intValue(), unit);
                break;
            }
            case influxdb: {
                InfluxdbReporter.Builder influxdbBuilder = InfluxdbReporter.forRegistry((MetricRegistry)metrics);
                if (StringUtil.isNotNull((Object)Conf.get((String)"common.metrics.sink.influxdb.user")) && StringUtil.isNotNull((Object)Conf.get((String)"common.metrics.sink.influxdb.password"))) {
                    influxdbBuilder.protocol((InfluxdbProtocol)new HttpInfluxdbProtocol(Conf.get((String)"common.metrics.sink.influxdb.ip"), Conf.getInt((String)"common.metrics.sink.influxdb.port").intValue(), Conf.get((String)"common.metrics.sink.influxdb.user"), Conf.get((String)"common.metrics.sink.influxdb.password"), Conf.get((String)"common.metrics.sink.influxdb.defaultdb")));
                } else {
                    influxdbBuilder.protocol((InfluxdbProtocol)new HttpInfluxdbProtocol(Conf.get((String)"common.metrics.sink.influxdb.ip"), Conf.getInt((String)"common.metrics.sink.influxdb.port").intValue(), Conf.get((String)"common.metrics.sink.influxdb.defaultdb")));
                }
                influxdbBuilder.convertRatesTo(rateUnit).convertDurationsTo(durationsTo).filter(MetricFilter.ALL).skipIdleMetrics(false);
                Map tags = Conf.getPre((String)Conf.get((String)"common.metrics.sink.influxdb.tagPrefix"), (boolean)true);
                for (String key : tags.keySet()) {
                    influxdbBuilder.tag(key, (String)tags.get(key));
                }
                influxdbBuilder.build().start((long)period.intValue(), unit);
                break;
            }
        }
    }
}

