/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.metrics.core;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.metrics.core.TsMetricsSerializer;
import net.wicp.tams.common.metrics.entity.statisticbean.StatisticBean;
import net.wicp.tams.common.metrics.entity.statisticbean.StatisticCounterBean;
import net.wicp.tams.common.metrics.entity.statisticbean.StatisticGaugeBean;
import net.wicp.tams.common.metrics.entity.statisticbean.StatisticGroupBean;
import net.wicp.tams.common.metrics.entity.statisticbean.StatisticHistogramBean;
import net.wicp.tams.common.metrics.entity.statisticbean.StatisticMeterBean;
import net.wicp.tams.common.metrics.entity.statisticbean.StatisticTimerBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class JsonReporter
extends ScheduledReporter {
    private StatisticCounterBean scb = new StatisticCounterBean();
    private StatisticTimerBean stb = new StatisticTimerBean();
    private StatisticGaugeBean sgb = new StatisticGaugeBean();
    private StatisticMeterBean smb = new StatisticMeterBean();
    private StatisticHistogramBean shb = new StatisticHistogramBean();
    private List<StatisticGroupBean> sgbs = new ArrayList<StatisticGroupBean>();
    private static final ObjectMapper mapper = new ObjectMapper().registerModule((Module)new TsMetricsSerializer(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false, MetricFilter.ALL));
    private final JsonLoggerProxy loggerProxy;
    private final Marker marker;

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private JsonReporter(MetricRegistry registry, JsonLoggerProxy loggerProxy, Marker marker, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter) {
        super(registry, "logger-reporter", filter, rateUnit, durationUnit);
        this.loggerProxy = loggerProxy;
        this.marker = marker;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            StatisticGaugeBean sgb = new StatisticGaugeBean();
            sgb.setName(entry.getKey());
            sgb.setGauge(entry.getValue());
            this.group(sgb);
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            StatisticCounterBean scb = new StatisticCounterBean();
            scb.setName(entry.getKey());
            scb.setCounter((Counter)entry.getValue());
            this.group(scb);
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            StatisticHistogramBean shb = new StatisticHistogramBean();
            shb.setName(entry.getKey());
            shb.setHistogram((Histogram)entry.getValue());
            this.group(shb);
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            StatisticMeterBean smb = new StatisticMeterBean();
            smb.setName(entry.getKey());
            smb.setMeter((Meter)entry.getValue());
            this.group(smb);
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            StatisticTimerBean stb = new StatisticTimerBean();
            stb.setName(entry.getKey());
            stb.setTimer((Timer)entry.getValue());
            this.group(stb);
        }
        this.logJsonGroup();
    }

    private void group(StatisticBean sb) {
        for (StatisticGroupBean sgb : this.sgbs) {
            if (!sb.getName().contains(sgb.getGroupName())) continue;
            sgb.getMetricSet().add(sb);
            return;
        }
        String[] strs = sb.getName().split("\\.");
        if (strs.length < 6) {
            return;
        }
        String groupName = strs[4] + "." + strs[5];
        StatisticGroupBean newSgb = new StatisticGroupBean(groupName);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        newSgb.setTimestamp(df.format(new Date()));
        newSgb.getMetricSet().add(sb);
        this.sgbs.add(newSgb);
    }

    private void logJsonGroup() {
        try {
            for (StatisticGroupBean sgb : this.sgbs) {
                this.loggerProxy.log(this.marker, "{}", mapper.writeValueAsString((Object)sgb));
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        for (StatisticGroupBean sgb : this.sgbs) {
            sgb.getMetricSet().clear();
        }
        this.sgbs.clear();
    }

    private void logJsonTimer(String name, Timer timer) {
        try {
            this.stb.setName(name);
            this.stb.setTimer(timer);
            this.loggerProxy.log(this.marker, "{}", mapper.writeValueAsString((Object)this.stb));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private void logJsonMeter(String name, Meter meter) {
        try {
            this.smb.setName(name);
            this.smb.setMeter(meter);
            this.loggerProxy.log(this.marker, "{}", mapper.writeValueAsString((Object)this.smb));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private void logJsonHistogram(String name, Histogram histogram) {
        try {
            this.shb.setName(name);
            this.shb.setHistogram(histogram);
            this.loggerProxy.log(this.marker, "{}", mapper.writeValueAsString((Object)this.shb));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private void logJsonCounter(String name, Counter counter) {
        this.scb.setName(name);
        this.scb.setCounter(counter);
        try {
            this.loggerProxy.log(this.marker, "{}", mapper.writeValueAsString((Object)this.scb));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    private void logJsonGauge(String name, Gauge gauge) {
        try {
            this.sgb.setName(name);
            this.sgb.setGauge(gauge);
            this.loggerProxy.log(this.marker, "{}", mapper.writeValueAsString((Object)this.sgb));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
    }

    protected String getRateUnit() {
        return "events/" + super.getRateUnit();
    }

    private static class ErrorJsonLoggerProxy
    extends JsonLoggerProxy {
        public ErrorJsonLoggerProxy(Logger logger) {
            super(logger);
        }

        @Override
        public void log(Marker marker, String format, Object ... arguments) {
            this.logger.error(marker, format, arguments);
        }
    }

    private static class WarnJsonLoggerProxy
    extends JsonLoggerProxy {
        public WarnJsonLoggerProxy(Logger logger) {
            super(logger);
        }

        @Override
        public void log(Marker marker, String format, Object ... arguments) {
            this.logger.warn(marker, format, arguments);
        }
    }

    private static class InfoJsonLoggerProxy
    extends JsonLoggerProxy {
        public InfoJsonLoggerProxy(Logger logger) {
            super(logger);
        }

        @Override
        public void log(Marker marker, String format, Object ... arguments) {
            this.logger.info(marker, format, arguments);
        }
    }

    private static class TraceJsonLoggerProxy
    extends JsonLoggerProxy {
        public TraceJsonLoggerProxy(Logger logger) {
            super(logger);
        }

        @Override
        public void log(Marker marker, String format, Object ... arguments) {
            this.logger.trace(marker, format, arguments);
        }
    }

    private static class DebugJsonLoggerProxy
    extends JsonLoggerProxy {
        public DebugJsonLoggerProxy(Logger logger) {
            super(logger);
        }

        @Override
        public void log(Marker marker, String format, Object ... arguments) {
            this.logger.debug(marker, format, arguments);
        }
    }

    static abstract class JsonLoggerProxy {
        protected final Logger logger;

        public JsonLoggerProxy(Logger logger) {
            this.logger = logger;
        }

        abstract void log(Marker var1, String var2, Object ... var3);
    }

    public static class Builder {
        private final MetricRegistry registry;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private Logger logger;
        private JsonLoggingLevel loggingLevel;
        private Marker marker;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.logger = LoggerFactory.getLogger((String)"mectrics");
            this.marker = null;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.loggingLevel = JsonLoggingLevel.INFO;
        }

        public Builder outputTo(Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder markWith(Marker marker) {
            this.marker = marker;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder withLoggingLevel(JsonLoggingLevel loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        public JsonReporter build() {
            JsonLoggerProxy loggerProxy;
            switch (this.loggingLevel) {
                case TRACE: {
                    loggerProxy = new TraceJsonLoggerProxy(this.logger);
                    break;
                }
                case INFO: {
                    loggerProxy = new InfoJsonLoggerProxy(this.logger);
                    break;
                }
                case WARN: {
                    loggerProxy = new WarnJsonLoggerProxy(this.logger);
                    break;
                }
                case ERROR: {
                    loggerProxy = new ErrorJsonLoggerProxy(this.logger);
                    break;
                }
                default: {
                    loggerProxy = new DebugJsonLoggerProxy(this.logger);
                }
            }
            return new JsonReporter(this.registry, loggerProxy, this.marker, this.rateUnit, this.durationUnit, this.filter);
        }
    }

    public static enum JsonLoggingLevel {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

