/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.kudu.plugin;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.binlog.alone.DuckulaAssit;
import net.wicp.tams.common.binlog.alone.ListenerConf.ColHis;
import net.wicp.tams.common.binlog.alone.ListenerConf.DuckulaEvent;
import net.wicp.tams.common.binlog.alone.ListenerConf.OptType;
import net.wicp.tams.common.binlog.alone.PluginAssit;
import net.wicp.tams.common.binlog.alone.binlog.bean.Rule;
import net.wicp.tams.common.binlog.alone.binlog.bean.RuleItem;
import net.wicp.tams.common.binlog.alone.binlog.listener.AbsBinlogListener;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.constant.ods.AddColName;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.kudu.KuduAssit;

@Slf4j
public class ListenerKudu extends AbsBinlogListener {

	private final KuduAssit kuduAssit;

	public ListenerKudu() {
		this.kuduAssit = new KuduAssit("default");
	}

	// TODO impala表重建
	@Override
	public Result doAlterTableCallBack(Rule rule, ColHis colHis, String sql, String[] addColNames, String updateColName,
			String[] deleteColNames, FieldFormart fieldFormart, String newDb, String newTb) {
		try {
			if (addColNames != null && addColNames.length > 0) {
				String tbTrue = String.format("%s.%s", newDb, newTb);
				kuduAssit.addTableColumn(tbTrue, colHis, addColNames);
			}
		} catch (Exception e) {
			log.error("添加字段失败 sql={}", sql, e);
			throw new ProjectExceptionRuntime(ExceptAll.Project_default, "添加新字段失败", e);
		}
		return Result.getSuc();
	}

	@Override
	public void doInit(Rule rule, int index) {
		Validate.isTrue(StringUtil.isNotNull(rule.getItems().get(RuleItem.db)), "每组规则都需要配置db。");
		// TODO RuleItem.dbtbConver 可配置后面再想
		// Validate.isTrue(StringUtil.isNotNull(rule.getItems().get(RuleItem.tbConver)),
		// "每组规则都需表的转换规则");
	}

	private void doBusiTrue(Rule rule, DuckulaEvent duckulaEvent, Map<AddColName, Serializable> addValues,
			boolean isSplit, boolean logicDel) {
		try {
			OptType optType = duckulaEvent.getOptType();
			List<Map<String, String>> keysValues = new ArrayList<Map<String, String>>();
			for (int i = 0; i < duckulaEvent.getItemsCount(); i++) {
				Map<String, String> valueMap = new HashMap<String, String>();
				valueMap.putAll(DuckulaAssit.getValueMap(duckulaEvent, i));
				if (MapUtils.isNotEmpty(addValues)) {
					for (AddColName addColName : addValues.keySet()) {
						valueMap.put(addColName.getColNameTrue(), String.valueOf(addValues.get(addColName)));
					}
				}
				keysValues.add(valueMap);
			}
			Pair<String, String> newDbTb = PluginAssit.getNewDbTb(rule, duckulaEvent);
			String tbTrue = String.format("%s.%s", newDbTb.getLeft(), newDbTb.getRight());
			if (optType == OptType.delete && !logicDel) {
				kuduAssit.dataDelete(tbTrue, keysValues);
			} else {
				kuduAssit.upsertRow(tbTrue, keysValues);
			}
		} catch (Exception e) {
			throw new ProjectExceptionRuntime(ExceptAll.duckula_datanofit, "保存kudu数据失败", e);
		} finally {

		}
	}

	@Override
	public void doBusiAsyncTrue(boolean isSplit, boolean logicDel,
			Map<Rule, List<Pair<DuckulaEvent, Map<AddColName, Serializable>>>> sendDataCase) {
		for (Rule rule : sendDataCase.keySet()) {
			for (Pair<DuckulaEvent, Map<AddColName, Serializable>> data : sendDataCase.get(rule)) {
				doBusiTrue(rule, data.getLeft(), data.getRight(), isSplit, logicDel);
			}
		}
	}

	public static void main(String[] args) throws Exception {
		String a = "2021-12-27'T'09:17:38'Z'";

		Date d = DateFormatCase.TZyyyyMMddHHmmss.getInstanc().parse(a);
		String dd = DateFormatCase.YYYY_MM_DD_hhmmss.getInstanc().format(d);
		System.out.println(dd);
	}

}