/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.kudu.plugin;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.DbType;
import net.wicp.tams.common.constant.dic.YesOrNo;

import java.sql.Connection;
import java.sql.DriverManager;

/***
 * jdbc工具类，纯jdbc没有连接池
 * common-extapi中没有impala相关依赖，插件的形式启动时自定义了classloader，双亲委派模式下不会再加载common-kudu中依赖的common-extapi,因此重写此类仅在kudu中用。
 * @author zhoujunhui
 *
 */
@Slf4j
public abstract class JdbcConnection {

	public static Connection getConnection(String driverName, String dburl, String userName, String pwd) {
		Connection conn = null;
		try {
			Class.forName(driverName);
			if (StringUtil.isNull(userName) || StringUtil.isNull(pwd)) {
				conn = DriverManager.getConnection(dburl);
			} else {
				conn = DriverManager.getConnection(dburl, userName, pwd);
			}
			return conn;
		} catch (Exception e) {
			log.error(String.format("连接错误，地址[%s]", dburl), e);
		}
		return null;
	}

	public static Connection getConnection(String driverName, String dburl) {
		return getConnection(driverName, dburl, null, null);
	}

	public static Connection getConnectionMyql(String dburl) {
		return getConnection("com.mysql.jdbc.Driver", dburl);
	}

	public static Connection getConnectionMyql(String dburl, String userName, String pwd) {
		return getConnection("com.mysql.jdbc.Driver", dburl, userName, pwd);
	}

	public static Connection getConnectionMyql(String host, int port, String user, String pwd, YesOrNo isSsh) {
		String url= DbType.mysql.geturl(host, port);
		Connection conn = JdbcConnection.getConnectionMyql(url, user, pwd);
		return conn;
	}

	public static void close(Connection conn) {
		try {
			conn.close();
		} catch (Exception e) {
		}
	}

}
