/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common
 * 项目描述：公共的工具集
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.kudu.plugin;

import java.io.Serializable;
import java.util.Map;

import org.apache.commons.collections.MapUtils;

import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.constant.ods.AddColName;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.kudu.KuduAssit;

/***
 * 需要把界面的dump配置转成Dump对象
 * 
 * @author andy.zhou
 *
 */
public class DumperKudu implements IBusiSender<DumpEvent> {

	private final KuduAssit kuduAssit;

	public DumperKudu() {
		this.kuduAssit = new KuduAssit("default");
	}

	@Override
	public void init(Dump dump) {
	}

	

	@Override
	public void doSend(DumpEvent dumpEvent, Map<AddColName, Serializable> addValues, String newDb, String newTb,
			boolean isSplit) {
		try {
			String tbTrue = String.format("%s.%s", newDb, newTb);
			if (MapUtils.isNotEmpty(addValues)) {// 20211209 支持附加字段
				for (AddColName addValue : addValues.keySet()) {
					for (Map<String, String> data : dumpEvent.getDatas()) {
						data.put(addValue.getColNameTrue(), String.valueOf(addValues.get(addValue)));
					}
				}
			}
			kuduAssit.upsertRow(tbTrue, dumpEvent.getDatas());
		} catch (Exception e) {
			throw new ProjectExceptionRuntime(ExceptAll.Project_default, "更新失败", e);
		}
	}



}
