/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kudu;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.DateUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.MySqlColBean;
import net.wicp.tams.common.binlog.alone.ListenerConf;
import net.wicp.tams.common.constant.DbType;
import net.wicp.tams.common.constant.FieldFormart;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.jdbc.MySqlAssitExt;
import net.wicp.tams.common.kudu.plugin.JdbcConnection;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.AlterTableOptions;
import org.apache.kudu.client.AlterTableResponse;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.Delete;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.Upsert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduAssit {
    private static final Logger log = LoggerFactory.getLogger(KuduAssit.class);
    private final KuduClient client;
    private final Map<String, String> configmap;

    public KuduAssit(String ds) {
        KuduClient client;
        Map preAddDefault = Conf.getPreAddDefault((String)("common.kudu." + StringUtil.hasNull((String[])new String[]{ds, "default"})), (boolean)true);
        KuduClient.KuduClientBuilder clientBuilder = new KuduClient.KuduClientBuilder((String)preAddDefault.get("master.addresses"));
        this.client = client = clientBuilder.build();
        this.configmap = preAddDefault;
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (KuduException kuduException) {
            // empty catch block
        }
    }

    public void createTable(String tb, List<MySqlColBean> mysqlCols, MySqlColBean ... addCols) throws Exception {
        boolean tableExists = this.client.tableExists(tb);
        if (tableExists) {
            log.warn("\u8868[{}]\u5df2\u5b58\u5728", (Object)tb);
            return;
        }
        if (ArrayUtils.isNotEmpty((Object[])addCols)) {
            mysqlCols.addAll(Arrays.asList(addCols));
        }
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>();
        ArrayList<String> partions = new ArrayList<String>();
        for (MySqlColBean mysqlCol : mysqlCols) {
            Type kuduType = KuduAssit.convertMysqlToKuduType(mysqlCol.getDataType());
            ColumnTypeAttributes columnTypeAttributes = null;
            switch (kuduType) {
                case DECIMAL: {
                    columnTypeAttributes = new ColumnTypeAttributes.ColumnTypeAttributesBuilder().scale(mysqlCol.getNumericScale()).precision(Integer.parseInt(String.valueOf(mysqlCol.getMaxlength()))).build();
                    break;
                }
            }
            columns.add(new ColumnSchema.ColumnSchemaBuilder(mysqlCol.getColumnNameStandard(FieldFormart.dbstandard), kuduType).key(mysqlCol.isPri()).typeAttributes(columnTypeAttributes).nullable(!mysqlCol.isPri()).build());
            if (!mysqlCol.isPri()) continue;
            partions.add(mysqlCol.getColumnNameStandard(FieldFormart.dbstandard));
        }
        Schema schema = new Schema(columns);
        CreateTableOptions options = new CreateTableOptions().addHashPartitions(partions, Integer.parseInt(this.configmap.get("partions"))).setNumReplicas(Integer.parseInt(this.configmap.get("replicas")));
        this.client.createTable(tb, schema, options);
    }

    public void addTableColumn(String tableName, ListenerConf.ColHis colHis, String[] addColNames) throws Exception {
        Boolean isExiste = this.client.tableExists("kudu::" + tableName);
        if (!isExiste.booleanValue()) {
            log.info("upsert kudu\u8868\u4e0d\u5b58\u5728,table={}", (Object)tableName);
            return;
        }
        AlterTableOptions alterTableOptions = new AlterTableOptions();
        for (String columnName : addColNames) {
            Type type = KuduAssit.convertMysqlToKuduType(colHis.getColTypes(colHis.getColsList().indexOf((Object)columnName)));
            alterTableOptions.addNullableColumn(columnName, type);
        }
        AlterTableResponse alterTableResponse = this.client.alterTable("kudu::" + tableName, alterTableOptions);
        String impalaUrl = DbType.impala.geturl(this.configmap.get("impala.addresses"), Integer.parseInt(this.configmap.get("impala.port")));
        Connection impalaConn = JdbcConnection.getConnection("com.cloudera.impala.jdbc41.Driver", impalaUrl, this.configmap.get("impala.user"), this.configmap.get("impala.password"));
        String impalaTbName = tableName;
        String dropSql = "DROP TABLE IF EXISTS " + impalaTbName;
        MySqlAssitExt.execSql((Connection)impalaConn, (String)dropSql);
        String sql = "CREATE EXTERNAL TABLE IF NOT EXISTS " + impalaTbName + " STORED AS KUDU TBLPROPERTIES('kudu.table_name' = 'kudu::" + tableName + "','kudu.master_addresses' = 'bigdata-01:7051,bigdata-02:7051,bigdata-03:7051')";
        MySqlAssitExt.execSql((Connection)impalaConn, (String)sql);
    }

    public void dropTable(String tb) throws Exception {
        boolean tableExists = this.client.tableExists(tb);
        if (!tableExists) {
            log.warn("\u8868[{}]\u4e0d\u5b58\u5728", (Object)tb);
            return;
        }
        this.client.deleteTable(tb);
    }

    public void upsertRow(String tb, List<Map<String, String>> datas) throws Exception {
        Boolean isExiste = this.client.tableExists("kudu::" + tb);
        if (!isExiste.booleanValue()) {
            log.info("upsert kudu\u8868\u4e0d\u5b58\u5728,table={}", (Object)tb);
            return;
        }
        KuduTable table = this.client.openTable("kudu::" + tb);
        if (table != null) {
            KuduSession session = this.client.newSession();
            for (Map<String, String> data : datas) {
                Upsert upsert = table.newUpsert();
                PartialRow row = upsert.getRow();
                for (String key : data.keySet()) {
                    ColumnSchema column = table.getSchema().getColumn(key);
                    Type colType = column.getType();
                    String value = data.get(key);
                    KuduAssit.putValueByType(row, key, value, colType);
                }
                OperationResponse operationResponse = session.apply((Operation)upsert);
                if (!operationResponse.hasRowError()) continue;
                log.error("upsert kudu \u5f02\u5e38,rowErrors={}", (Object)operationResponse.getRowError());
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "upsert kudu \u5f02\u5e38\uff01");
            }
            session.close();
        }
    }

    public Result dataDelete(String tb, List<Map<String, String>> keysValues) throws Exception {
        KuduTable table = this.client.openTable(tb);
        List keyColumns = table.getSchema().getPrimaryKeyColumns();
        KuduSession session = this.client.newSession();
        for (Map<String, String> keysValue : keysValues) {
            Delete delete = table.newDelete();
            PartialRow row = delete.getRow();
            for (ColumnSchema keyColumn : keyColumns) {
                String value = keysValue.get(keyColumn.getName());
                KuduAssit.putValueByType(row, keyColumn.getName(), value, keyColumn.getType());
            }
            session.apply((Operation)delete);
        }
        session.flush();
        session.close();
        return Result.getSuc();
    }

    public static void putValueByType(PartialRow row, String key, String value, Type colType) {
        switch (colType) {
            case STRING: {
                row.addString(key, value);
                break;
            }
            case INT8: {
                row.addByte(key, Byte.parseByte(value));
                break;
            }
            case INT16: {
                row.addShort(key, Short.parseShort(value));
                break;
            }
            case INT32: {
                row.addInt(key, Integer.parseInt(value));
                break;
            }
            case INT64: {
                row.addLong(key, Long.parseLong(value));
                break;
            }
            case FLOAT: {
                row.addFloat(key, Float.parseFloat(value));
                break;
            }
            case DOUBLE: {
                row.addDouble(key, Double.parseDouble(value));
                break;
            }
            case BOOL: {
                row.addBoolean(key, Boolean.parseBoolean(value));
                break;
            }
            case DECIMAL: {
                row.addDecimal(key, new BigDecimal(value));
                break;
            }
            case UNIXTIME_MICROS: {
                Timestamp time = new Timestamp(DateUtil.changeTimeZone((Date)DateUtil.objToDate((Object)value), (TimeZone)DateUtil.getTZZone(), (TimeZone)DateUtil.getBeijingTimeZone()).getTime());
                row.addTimestamp(key, time);
                break;
            }
            case BINARY: {
                row.addBinary(key, value.getBytes());
                break;
            }
        }
    }

    public static Type convertMysqlToKuduType(String mySqlDataType) {
        Type retColType = Type.STRING;
        switch (mySqlDataType) {
            case "varchar": {
                retColType = Type.STRING;
                break;
            }
            case "binary": {
                retColType = Type.STRING;
                break;
            }
            case "bool": {
                retColType = Type.BOOL;
                break;
            }
            case "boolean": {
                retColType = Type.BOOL;
                break;
            }
            case "longblob": {
                retColType = Type.STRING;
                break;
            }
            case "int": {
                retColType = Type.INT32;
                break;
            }
            case "integer": {
                retColType = Type.INT32;
                break;
            }
            case "mediumint": {
                retColType = Type.INT32;
                break;
            }
            case "smallint": {
                retColType = Type.INT16;
                break;
            }
            case "char": {
                retColType = Type.STRING;
                break;
            }
            case "json": {
                retColType = Type.STRING;
                break;
            }
            case "datetime": {
                retColType = Type.UNIXTIME_MICROS;
                break;
            }
            case "bit": {
                retColType = Type.INT8;
                break;
            }
            case "decimal": {
                retColType = Type.DECIMAL;
                break;
            }
            case "longtext": {
                retColType = Type.STRING;
                break;
            }
            case "tinyint": {
                retColType = Type.INT8;
                break;
            }
            case "mediumtext": {
                retColType = Type.STRING;
                break;
            }
            case "bigint": {
                retColType = Type.INT64;
                break;
            }
            case "time": {
                retColType = Type.UNIXTIME_MICROS;
                break;
            }
            case "float": {
                retColType = Type.FLOAT;
                break;
            }
            case "timestamp": {
                retColType = Type.UNIXTIME_MICROS;
                break;
            }
            case "text": {
                retColType = Type.STRING;
                break;
            }
            case "double": {
                retColType = Type.DOUBLE;
                break;
            }
            case "date": {
                retColType = Type.UNIXTIME_MICROS;
                break;
            }
            case "blob": {
                retColType = Type.STRING;
                break;
            }
        }
        return retColType;
    }
}

