package net.wicp.tams.common.kudu.plugin;

import java.io.Serializable;
import java.util.Map;

import org.apache.commons.collections.MapUtils;

import net.wicp.tams.common.binlog.alone.dump.bean.Dump;
import net.wicp.tams.common.binlog.alone.dump.bean.DumpEvent;
import net.wicp.tams.common.binlog.alone.dump.listener.IBusiSender;
import net.wicp.tams.common.constant.ods.AddColName;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.kudu.KuduAssit;

/***
 * 需要把界面的dump配置转成Dump对象
 * 
 * @author andy.zhou
 *
 */
public class DumperKudu implements IBusiSender<DumpEvent> {

	private final KuduAssit kuduAssit;

	public DumperKudu() {
		this.kuduAssit = new KuduAssit("default");
	}

	@Override
	public void init(Dump dump) {
	}

	

	@Override
	public void doSend(DumpEvent dataBuilders, Map<AddColName, Serializable> addValues, String newDb, String newTb) {
		try {
			String tbTrue = String.format("%s.%s", newDb, newTb);
			if (MapUtils.isNotEmpty(addValues)) {// 20211209 支持附加字段
				for (AddColName addValue : addValues.keySet()) {
					for (Map<String, String> data : dataBuilders.getDatas()) {
						data.put(addValue.getColNameTrue(), String.valueOf(addValues.get(addValue)));
					}
				}
			}
			kuduAssit.upsertRow(tbTrue, dataBuilders.getDatas());
		} catch (Exception e) {
			throw new ProjectExceptionRuntime(ExceptAll.Project_default, "更新失败", e);
		}
	}

}
