/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.helm;

import java.util.List;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.callback.IConvertObj;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.kubernetes.helm.po.ChartInst;
import net.wicp.tams.common.kubernetes.helm.po.HelmInst;
import net.wicp.tams.common.kubernetes.helm.po.RepoInst;
import org.apache.commons.lang3.ArrayUtils;

public enum HelmCmd implements IEnumCombobox
{
    install("\u5b89\u88c5", "helm install", new IConvertObj<Result>(){

        public Result getObj(String value, String formate) {
            if (value.contains("Error:")) {
                return Result.getError((String)value);
            }
            return Result.getSuc((String)value);
        }
    }),
    list("\u5217\u51fachart\u5305", "helm list", new IConvertObj<Result>(){

        public Result getObj(String value, String formate) {
            if (value.contains("Error:")) {
                return Result.getError((String)value);
            }
            List<HelmInst> retlist = HelmInst.splitList(value);
            Result ret = Result.getSuc();
            if (retlist.size() > 0) {
                ret.setRetObjs((Object[])retlist.toArray(new HelmInst[retlist.size()]));
            }
            return ret;
        }
    }),
    delete("\u5378\u8f7d\u5b89\u88c5\u5305", "helm delete", new IConvertObj<Result>(){

        public Result getObj(String value, String formate) {
            if (value.contains("Error:")) {
                return Result.getError((String)value);
            }
            return Result.getSuc((String)value);
        }
    }),
    repoadd("\u5b89\u88c5\u672c\u5730chart\u5e93", "helm repo add --username ${HELM_REPO_USERNAME} --password ${HELM_REPO_PASSWORD}", new IConvertObj<Result>(){

        public Result getObj(String value, String formate) {
            if (value.contains("Error:")) {
                return Result.getError((String)value);
            }
            return Result.getSuc((String)value);
        }
    }),
    repolist("\u5217\u51fa\u5df2\u5b89\u88c5\u7684\u5e93", "helm repo list", new IConvertObj<Result>(){

        public Result getObj(String value, String formate) {
            if (value.contains("Error:")) {
                if (value.contains("no repositories to show")) {
                    return Result.getSuc();
                }
                return Result.getError((String)value);
            }
            Object[] insts = RepoInst.splitList(value);
            Result ret = Result.getSuc();
            if (ArrayUtils.isNotEmpty((Object[])insts)) {
                ret.setRetObjs(insts);
            }
            return ret;
        }
    }),
    repoupdate("\u66f4\u65b0\u672c\u5730chart\u5e93", "helm repo update", new IConvertObj<Result>(){

        public Result getObj(String value, String formate) {
            if (value.contains("Error:")) {
                return Result.getError((String)value);
            }
            return Result.getSuc((String)value);
        }
    }),
    reposearch("\u67e5\u8be2\u627e\u4e2achart\u5305", "helm search repo", new IConvertObj<Result>(){

        public Result getObj(String value, String formate) {
            if (value.contains("Error:")) {
                return Result.getError((String)value);
            }
            Object[] retlist = ChartInst.splitList(value);
            Result ret = Result.getSuc();
            if (ArrayUtils.isNotEmpty((Object[])retlist)) {
                ret.setRetObjs(retlist);
            }
            return ret;
        }
    }),
    chartpush("\u63a8\u9001chart\u5305", "helm push", new IConvertObj<Result>(){

        public Result getObj(String value, String formate) {
            if (value.contains("Error:")) {
                return Result.getError((String)value);
            }
            return Result.getSuc((String)value);
        }
    }),
    chartfetch("\u62c9\u53d6chart\u5305", "helm fetch", new IConvertObj<Result>(){

        public Result getObj(String value, String formate) {
            if (value.contains("Error:")) {
                return Result.getError((String)value);
            }
            return Result.getSuc((String)value);
        }
    }),
    chartPackage("chart\u6253\u5305", "helm package", new IConvertObj<Result>(){

        public Result getObj(String value, String formate) {
            if (value.contains("Error:")) {
                return Result.getError((String)value);
            }
            return Result.getSuc((String)value);
        }
    });

    private final String desc;
    private final String cmd;
    private final IConvertObj<Result> convertResult;

    public String getCmd() {
        return this.cmd;
    }

    private HelmCmd(String desc, String cmd, IConvertObj<Result> convertResult) {
        this.desc = desc;
        this.cmd = cmd;
        this.convertResult = convertResult;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name();
    }

    public String getDesc_zh() {
        return this.desc;
    }

    public String getDesc_en() {
        return this.name();
    }

    public IConvertObj<Result> getConvertResult() {
        return this.convertResult;
    }
}

