/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.duckula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.ICallBack;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import org.apache.commons.lang3.StringUtils;

public enum ConfigItem implements IEnumCombobox
{
    k8s_namespace("\u90e8\u7f72\u7684\u540d\u79f0\u7a7a\u95f4", "k8s_namespace", "bigdata"),
    k8s_nas_storageClass("nas\u76d8\u7684\u521b\u5efa\u7c7b", "k8s_nas_storageClass", true),
    k8s_nas_size("nas\u76d8\u5927\u5c0f", "k8s_nas_size", "100Gi"),
    k8s_secret_ssl_key("sslSecret\u7684key", "k8s_secret_ssl_key", false),
    k8s_secret_ssl_crt("nas\u76d8\u5927\u5c0f", "k8s_secret_ssl_crt", false),
    k8s_ingress_slbssh("slb\u662f\u5426\u542f\u7528\u4e86ssh", "k8s_ingress_slbssh", "yes"),
    k8s_secret_docker_configjson("\u63a8\u955c\u50cf\u7684secret\u7684configjson", "k8s_secret_docker_configjson", false),
    duckula_deployId("\u5e73\u53f0\u7684common_deploy\u8868\u7684id", "duckula_deployId", "1344624860489924610"),
    docker_image_repository("dock\u955c\u50cf\u7684repository", "docker_image_repository", "rjzjh"),
    duckula_defaultdb("\u9ed8\u8ba4\u5e93\u540d", "duckula_defaultdb", "duckula"),
    ds_defaultdb("\u9ed8\u8ba4\u5e93\u540d", "ds_defaultdb", "dolphinscheduler"),
    db_port("\u7aef\u53e3", "db_port", "3306"),
    db_host("\u4e3b\u673a", "db_host", true),
    db_username("\u7528\u6237\u540d", "db_username", true),
    db_password("\u5bc6\u7801", "db_password", true),
    duckula_agent_imageGroup("agent\u6a21\u5757\u7684\u955c\u50cf\u7ec4", "duckula_agent_imageGroup", "/duckula-agent"),
    duckula_agent_imageVersion("agent\u6a21\u5757\u7684\u7248\u672c", "duckula_agent_imageVersion", true),
    duckula_agent_ingressHost("agent\u6a21\u5757\u7684\u57df\u540d", "duckula_agent_ingressHost", true),
    duckula_operator_imageGroup("operator\u6a21\u5757\u7684\u955c\u50cf\u7ec4", "duckula_operator_imageGroup", "/duckula-operator"),
    duckula_operator_imageVersion("operator\u6a21\u5757\u7684\u7248\u672c", "duckula_operator_imageVersion", true),
    duckula_ops_imageGroup("ops\u6a21\u5757\u7684\u955c\u50cf\u7ec4", "duckula_ops_imageGroup", "/duckula-ops"),
    duckula_ops_imageVersion("operator\u6a21\u5757\u7684\u7248\u672c", "duckula_ops_imageVersion", true),
    duckula_ops_cpu("opsCPU", "duckula_ops_cpu", "1000m"),
    duckula_ops_memory("operator\u6a21\u5757\u7684\u7248\u672c", "duckula_ops_memory", "1024Mi"),
    duckula_ops_ingressHost("ops\u6a21\u5757\u7684\u57df\u540d", "duckula_ops_ingressHost", true),
    duckula_flink_ingressHost("flink\u7684JM\u6ce8\u518c\u57df\u540d", "duckula_flink_ingressHost", true),
    ds_images_imageGroup("ds\u955c\u50cf\u4ed3\u5e93", "ds_images_imageGroup", "/dolphinscheduler"),
    ds_images_imageVersion("ds\u955c\u50cf\u7248\u672c", "ds_images_imageVersion", "2.0.4"),
    ds_ingressHost("ds\u57df\u540d", "ds_ingressHost", true),
    duckula_agent_useDefImageGroup("agent\u662f\u5426\u81ea\u5b9a\u4e49\u955c\u50cf\u7ec4", "duckula_agent_useDefImageGroup", new ICallBack<String>(){

        public String getObj() {
            return duckula_agent_imageGroup.getDefaultVal().equals(duckula_agent_imageGroup.getValue()) ? "no" : "yes";
        }
    }),
    duckula_operator_useDefImageGroup("operator\u662f\u5426\u81ea\u5b9a\u4e49\u955c\u50cf\u7ec4", "duckula_agent_useDefImageGroup", new ICallBack<String>(){

        public String getObj() {
            return duckula_operator_imageGroup.getDefaultVal().equals(duckula_operator_imageGroup.getValue()) ? "no" : "yes";
        }
    }),
    duckula_ops_useDefImageGroup("ops\u662f\u5426\u81ea\u5b9a\u4e49\u955c\u50cf\u7ec4", "duckula_agent_useDefImageGroup", new ICallBack<String>(){

        public String getObj() {
            return duckula_ops_imageGroup.getDefaultVal().equals(duckula_ops_imageGroup.getValue()) ? "no" : "yes";
        }
    }),
    k8s_secret_docker_enable("\u662f\u5426\u542f\u7528\u955c\u50cf\u7684secret", "k8s_secret_docker_enable", new ICallBack<String>(){

        public String getObj() {
            String configjson = k8s_secret_docker_configjson.getValue();
            return StringUtil.isNull((Object)configjson) ? "false" : "true";
        }
    }),
    duckula_agent_ingress_enable("agent\u6a21\u5757\u662f\u5426\u9700\u8981\u5916\u90e8\u57df\u540d\uff08\u6709\u65f6\u53ef\u80fd\u6ca1\u6709\u63d0\u4f9b\uff09", "duckula_agent_ingress_enable", new ICallBack<String>(){

        public String getObj() {
            return StringUtil.isNull((Object)duckula_agent_ingressHost.getValue()) ? "false" : "true";
        }
    }),
    k8s_ingress_ssl_enable("ingress\u91cc\u662f\u5426\u8981\u4f7f\u7528https", "k8s_ingress_ssl_enable", new ICallBack<String>(){

        public String getObj() {
            String secretssl = k8s_secret_ssl_enable.getValue();
            String ingressSsl = k8s_ingress_slbssh.getValue();
            return "true".equals(secretssl) || "yes".equals(ingressSsl) ? "true" : "false";
        }
    }),
    k8s_secret_ssl_enable("\u662f\u5426\u542f\u7528SSL\u8ba4\u8bc1secret", "k8s_secret_ssl_enable", new ICallBack<String>(){

        public String getObj() {
            String key = k8s_secret_ssl_key.getValue();
            String crt = k8s_secret_ssl_crt.getValue();
            return StringUtil.isNotNull((Object)key) && StringUtil.isNotNull((Object)crt) ? "true" : "false";
        }
    });

    private final String desc;
    private final String itemName;
    private final String defaultVal;
    private final boolean notNull;
    private final ICallBack<String> convert;

    private ConfigItem(String desc, String itemName, boolean notNull) {
        this.desc = desc;
        this.itemName = itemName;
        this.defaultVal = "";
        this.convert = null;
        this.notNull = notNull;
    }

    private ConfigItem(String desc, String itemName, ICallBack<String> convert) {
        this.desc = desc;
        this.itemName = itemName;
        this.defaultVal = "";
        this.convert = convert;
        this.notNull = false;
    }

    private ConfigItem(String desc, String itemName, String defaultVal) {
        this.desc = desc;
        this.itemName = itemName;
        this.defaultVal = defaultVal;
        this.convert = null;
        this.notNull = false;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name();
    }

    public String getValue() {
        String retval = null;
        retval = this.convert == null ? Conf.get((String)this.getItemName(), (String)this.defaultVal) : (String)this.convert.getObj();
        return retval;
    }

    public String getDesc_zh() {
        return this.desc;
    }

    public String getDesc_en() {
        return this.name();
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public static ConfigItem find(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        for (ConfigItem ele : ConfigItem.values()) {
            if (!name.equalsIgnoreCase(ele.name())) continue;
            return ele;
        }
        return null;
    }

    public static ConfigItem[] findConfigItem(String pre) {
        ArrayList<ConfigItem> checkItems = new ArrayList<ConfigItem>();
        for (ConfigItem configItem : ConfigItem.values()) {
            if (!configItem.name().startsWith(pre)) continue;
            checkItems.add(configItem);
        }
        return checkItems.toArray(new ConfigItem[checkItems.size()]);
    }

    public static Map<String, String> proParams() {
        HashMap<String, String> retmap = new HashMap<String, String>();
        for (ConfigItem ele : ConfigItem.values()) {
            retmap.put(ele.name(), ele.getValue());
        }
        return retmap;
    }

    protected String getItemName() {
        return this.itemName;
    }

    protected String getDefaultVal() {
        return this.defaultVal;
    }
}

