/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.driver;

import io.fabric8.kubernetes.api.model.Namespace;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.beans.SqlWherePo;
import net.wicp.tams.common.beans.TbSimple;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.kubernetes.apiserver.KubeClientTams;
import net.wicp.tams.common.kubernetes.apiserver.crd.ICrdDef;
import net.wicp.tams.common.kubernetes.beans.KubernetesResultCol;
import net.wicp.tams.common.kubernetes.constant.ResourcesType;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.Lex;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.ddl.SqlCreateSchema;
import org.apache.calcite.sql.ddl.SqlDropSchema;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.ddl.SqlDdlParserImpl;
import org.apache.commons.lang3.tuple.Triple;

public class SqlParserAssit {
    private final String sql;
    private final SqlNode sqlNode;
    private String defaultCatalog;
    private final String defaultDb;
    private final List<TbSimple> usedTbs = new ArrayList<TbSimple>();

    public SqlParserAssit(String defaultCatalog, String defaultDb, String sql) {
        this.sql = StringUtil.trimSpace((String)sql);
        this.defaultCatalog = StringUtil.hasNull((String[])new String[]{defaultCatalog, Conf.get((String)"common.kubernetes.jdbc.catalogDefault")});
        this.defaultDb = defaultDb;
        SqlParser.Config mysqlConfig = SqlParser.config().withCaseSensitive(false).withQuotedCasing(Casing.TO_UPPER).withUnquotedCasing(Casing.TO_LOWER).withQuoting(Quoting.BACK_TICK).withLex(Lex.MYSQL).withParserFactory(SqlDdlParserImpl.FACTORY);
        SqlParser parser = SqlParser.create((String)this.sql, (SqlParser.Config)mysqlConfig);
        try {
            this.sqlNode = parser.parseQuery();
        }
        catch (SqlParseException e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error, "sql\u4e0d\u80fd\u89e3\u6790", (Throwable)e);
        }
    }

    private SqlParserAssit(String defaultCatalog, String defaultDb, SqlNode sqlNode) {
        this.sql = sqlNode.toString();
        this.defaultCatalog = defaultCatalog;
        this.defaultDb = defaultDb;
        this.sqlNode = sqlNode;
    }

    public boolean isQuery() {
        return this.sqlNode instanceof SqlSelect;
    }

    public List<SqlWherePo> queryWhere() {
        ArrayList<SqlWherePo> retlist = new ArrayList<SqlWherePo>();
        if (this.sqlNode instanceof SqlSelect) {
            SqlSelect sqlSelect = (SqlSelect)this.sqlNode;
            SqlNode where = sqlSelect.getWhere();
            this.queryInner(where, retlist);
        }
        return retlist;
    }

    private void queryInner(SqlNode oriNode, List<SqlWherePo> retlist) {
        if (oriNode instanceof SqlBasicCall) {
            SqlBasicCall parseNode = (SqlBasicCall)oriNode;
            SqlOperator operator = parseNode.getOperator();
            List operandList = parseNode.getOperandList();
            if (operandList.get(0) instanceof SqlBasicCall && operandList.get(1) instanceof SqlBasicCall) {
                this.queryInner((SqlNode)operandList.get(0), retlist);
                this.queryInner((SqlNode)operandList.get(1), retlist);
            } else {
                Object valueObj;
                SqlCharStringLiteral sqlCharStringLiteral;
                SqlWherePo temp = new SqlWherePo();
                if (operandList.get(0) instanceof SqlIdentifier) {
                    SqlIdentifier sqlIdentifier = (SqlIdentifier)operandList.get(0);
                    temp.setColName(sqlIdentifier.getSimple());
                } else if (operandList.get(0) instanceof SqlCharStringLiteral) {
                    sqlCharStringLiteral = (SqlCharStringLiteral)operandList.get(0);
                    valueObj = sqlCharStringLiteral.getValue();
                    temp.setColName(String.valueOf(valueObj).replace("'", ""));
                }
                temp.setOperator(operator.getName());
                if (operandList.get(1) instanceof SqlCharStringLiteral) {
                    sqlCharStringLiteral = (SqlCharStringLiteral)operandList.get(1);
                    valueObj = sqlCharStringLiteral.getValue();
                    temp.setValue(String.valueOf(valueObj).replace("'", ""));
                } else if (operandList.get(1) instanceof SqlNumericLiteral) {
                    sqlCharStringLiteral = (SqlNumericLiteral)operandList.get(1);
                    valueObj = sqlCharStringLiteral.getValue();
                    temp.setValue(String.valueOf(valueObj));
                }
                retlist.add(temp);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doDdl(KubeClientTams clientTams) throws SQLException {
        if (this.sqlNode instanceof SqlCreateSchema) {
            Namespace namespace;
            SqlCreateSchema rootNode = (SqlCreateSchema)this.sqlNode;
            TbSimple catalogDb = this.getCatalogDb(rootNode.getOperandList());
            if (rootNode.ifNotExists && (namespace = clientTams.getNamespace(catalogDb.getDb(), null)) != null) {
                return;
            }
            namespace = clientTams.createNamespace(catalogDb.getDb(), catalogDb.getCatalog());
            if (!namespace.isSuc()) {
                throw new SQLException(namespace.getMessage());
            }
        } else if (this.sqlNode instanceof SqlDropSchema) {
            Namespace namespace;
            SqlDropSchema rootNode = (SqlDropSchema)this.sqlNode;
            TbSimple catalogDb = this.getCatalogDb(rootNode.getOperandList());
            if (rootNode.ifExists && (namespace = clientTams.getNamespace(catalogDb.getDb(), null)) == null) {
                return;
            }
            clientTams.delNamespace(catalogDb.getDb(), catalogDb.getCatalog());
        } else if (this.sqlNode instanceof SqlInsert) {
            SqlInsert sqlInsert = (SqlInsert)this.sqlNode;
            TbSimple dbTb = this.getDbTb((SqlIdentifier)sqlInsert.getTargetTable(), null);
            ResourcesType resourcesType = ResourcesType.find(dbTb.getTb());
            List<KubernetesResultCol> crdColDef = resourcesType == ResourcesType.CRD ? clientTams.getCrdColDef(dbTb.getTb()) : resourcesType.getJdbcColDef();
            SqlNodeList targetColumnList = sqlInsert.getTargetColumnList();
            SqlBasicCall source = (SqlBasicCall)sqlInsert.getSource();
            ArrayList crds = new ArrayList();
            for (Object sqlNode : source.getOperandList()) {
                SqlBasicCall sqlBasicCall = (SqlBasicCall)sqlNode;
                HashMap<String, Object> spec = new HashMap<String, Object>();
                int i = 0;
                for (SqlNode sqlNode2 : sqlBasicCall.getOperandList()) {
                    Object targetVal = null;
                    if (sqlNode2 instanceof SqlCharStringLiteral) {
                        targetVal = String.valueOf(((SqlCharStringLiteral)sqlNode2).getValue()).replace("'", "");
                    } else if (sqlNode2 instanceof SqlNumericLiteral) {
                        targetVal = ((SqlNumericLiteral)sqlNode2).getValue();
                    }
                    String nameSql = ((SqlIdentifier)targetColumnList.get(i++)).getSimple();
                    int indexOf = crdColDef.indexOf(new KubernetesResultCol(nameSql));
                    if (indexOf < 0) {
                        throw new SQLException("\u8868:" + dbTb.getTb() + "\u6ca1\u6709\u76f8\u5173\u5b57\u6bb5" + nameSql);
                    }
                    String name = crdColDef.get(indexOf).getName();
                    spec.put(name, targetVal);
                }
                crds.add(spec);
            }
            ICrdDef iCrdDef = KubeClientTams.cusCache.get(dbTb.getTb());
            try {
                for (Map map : crds) {
                    if (resourcesType == ResourcesType.CRD) {
                        if (!map.containsKey("name")) {
                            throw new SQLException("\u65b0\u589e\u8bb0\u5f55\u9700\u8981\u4f20\u5165name");
                        }
                        map.remove("namespac");
                        String name = String.valueOf(map.get("name"));
                        map.remove("name");
                        clientTams.createCusObject(iCrdDef, dbTb.getDb(), name, null, null, map);
                        continue;
                    }
                    clientTams.installResource(resourcesType, dbTb.getDb(), map);
                }
            }
            catch (Exception e) {
                throw new SQLException("\u65b0\u589e\u8bb0\u5f55\u5931\u8d25" + e.getMessage());
            }
        } else if (this.sqlNode instanceof SqlUpdate) {
            void var11_37;
            SqlUpdate sqlUpdate = (SqlUpdate)this.sqlNode;
            SqlNode condition = sqlUpdate.getCondition();
            TbSimple dbTb = this.getDbTb((SqlIdentifier)sqlUpdate.getTargetTable(), null);
            ResourcesType resourcesType = ResourcesType.find(dbTb.getTb());
            List<KubernetesResultCol> crdColDef = resourcesType == ResourcesType.CRD ? clientTams.getCrdColDef(dbTb.getTb()) : resourcesType.getJdbcColDef();
            ArrayList<SqlWherePo> retlist = new ArrayList<SqlWherePo>();
            this.queryInner(condition, retlist);
            if (retlist.size() != 1 || !"name".equalsIgnoreCase(((SqlWherePo)retlist.get(0)).getColName())) {
                throw new SQLException("update\u6682\u53ea\u652f\u6301name\u7684\u66f4\u65b0\u6761\u4ef6" + this.sql);
            }
            SqlNodeList targetColumnList = sqlUpdate.getTargetColumnList();
            SqlNodeList sourceExpressionList = sqlUpdate.getSourceExpressionList();
            HashMap<String, Object> updatedSpec = new HashMap<String, Object>();
            boolean bl = false;
            while (var11_37 < targetColumnList.size()) {
                SqlIdentifier sqlNode2 = (SqlIdentifier)targetColumnList.get((int)var11_37);
                int indexOf = crdColDef.indexOf(new KubernetesResultCol(sqlNode2.getSimple()));
                if (indexOf < 0) {
                    throw new SQLException("\u8868:" + dbTb.getTb() + "\u6ca1\u6709\u76f8\u5173\u5b57\u6bb5" + sqlNode2.getSimple());
                }
                String name = crdColDef.get(indexOf).getName();
                SqlNode sqlNode3 = sourceExpressionList.get((int)var11_37);
                Object targetVal = null;
                if (sqlNode3 instanceof SqlCharStringLiteral) {
                    targetVal = String.valueOf(((SqlCharStringLiteral)sqlNode3).getValue()).replace("'", "");
                } else if (sqlNode3 instanceof SqlNumericLiteral) {
                    targetVal = ((SqlNumericLiteral)sqlNode3).getValue();
                }
                updatedSpec.put(name, targetVal);
                ++var11_37;
            }
            try {
                if (resourcesType == ResourcesType.CRD) {
                    updatedSpec.remove("name");
                    updatedSpec.remove("namespac");
                    ICrdDef iCrdDef = KubeClientTams.cusCache.get(dbTb.getTb());
                    clientTams.updateCrd(iCrdDef, dbTb.getDb(), ((SqlWherePo)retlist.get(0)).getValue(), updatedSpec);
                }
                clientTams.updateResource(resourcesType, dbTb.getDb(), ((SqlWherePo)retlist.get(0)).getValue(), updatedSpec);
            }
            catch (Exception exception) {
                throw new SQLException("\u4fee\u6539\u8bb0\u5f55\u5931\u8d25" + exception.getMessage());
            }
        } else if (this.sqlNode instanceof SqlDelete) {
            SqlDelete sqlDel = (SqlDelete)this.sqlNode;
            SqlNode condition = sqlDel.getCondition();
            TbSimple dbTb = this.getDbTb((SqlIdentifier)sqlDel.getTargetTable(), null);
            ResourcesType resourcesType = ResourcesType.find(dbTb.getTb());
            ArrayList<SqlWherePo> retlist = new ArrayList<SqlWherePo>();
            this.queryInner(condition, retlist);
            if (retlist.size() != 1 || !"name".equalsIgnoreCase(((SqlWherePo)retlist.get(0)).getColName())) {
                throw new SQLException("update\u6682\u53ea\u652f\u6301name\u7684\u66f4\u65b0\u6761\u4ef6" + this.sql);
            }
            if (resourcesType == ResourcesType.CRD) {
                ICrdDef iCrdDef = KubeClientTams.cusCache.get(dbTb.getTb());
                clientTams.deleteCusObject(iCrdDef, dbTb.getDb(), ((SqlWherePo)retlist.get(0)).getValue());
            } else {
                clientTams.deleteResource(resourcesType, dbTb.getDb(), ((SqlWherePo)retlist.get(0)).getValue());
            }
        } else {
            throw new SQLException("\u6682\u4e0d\u652f\u6301\u6b64\u547d\u4ee4" + this.sql);
        }
    }

    public List<Triple<String, String, String>> findColNamesDetail() {
        ArrayList<Triple<String, String, String>> retlist = new ArrayList<Triple<String, String, String>>();
        SqlNode parseNode = this.sqlNode;
        if (this.sqlNode instanceof SqlBasicCall) {
            parseNode = (SqlNode)((SqlBasicCall)this.sqlNode).getOperandList().get(0);
        }
        if (parseNode instanceof SqlSelect) {
            SqlNodeList collist = ((SqlSelect)parseNode).getSelectList();
            for (SqlNode col : collist) {
                String dbtbstr = null;
                String newColName = null;
                if (col instanceof SqlBasicCall) {
                    List operandList = ((SqlBasicCall)col).getOperandList();
                    SqlNode sqlNode2 = (SqlNode)operandList.get(0);
                    if (sqlNode2 instanceof SqlBasicCall) {
                        List operandList2 = ((SqlBasicCall)sqlNode2).getOperandList();
                        dbtbstr = ((SqlNode)operandList2.get(0)).toString();
                    } else {
                        dbtbstr = sqlNode2.toString();
                    }
                    if (operandList.size() > 1) {
                        SqlNode sqlNode3 = (SqlNode)operandList.get(1);
                        newColName = sqlNode3.toString();
                    }
                } else {
                    dbtbstr = col.toString();
                }
                String[] colname = dbtbstr.split("\\.");
                retlist.add((Triple<String, String, String>)Triple.of((Object)(colname.length == 1 ? null : colname[0]), (Object)(colname.length == 1 ? colname[0] : colname[1]), newColName));
            }
        }
        return retlist;
    }

    public List<String> findColNames() {
        List<Triple<String, String, String>> colNamesDetail = this.findColNamesDetail();
        List<String> retlist = colNamesDetail.stream().map(e -> StringUtil.isNull((Object)e.getRight()) ? (String)e.getMiddle() : (String)e.getRight()).collect(Collectors.toList());
        return retlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<TbSimple> findTbInfos() {
        if (!this.usedTbs.isEmpty()) return this.usedTbs;
        Class<SqlParserAssit> clazz = SqlParserAssit.class;
        synchronized (SqlParserAssit.class) {
            if (!this.usedTbs.isEmpty()) return this.usedTbs;
            this.callSqlBasicCall(this.sqlNode, this.usedTbs);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.usedTbs;
        }
    }

    public SqlNode getSqlNode() {
        return this.sqlNode;
    }

    private void callSqlBasicCall(SqlNode parseNode, List<TbSimple> retobj) {
        if (parseNode instanceof SqlBasicCall) {
            List sqlnodes = ((SqlBasicCall)parseNode).getOperandList();
            for (SqlNode sqlnode : sqlnodes) {
                this.callSqlBasicCall(sqlnode, retobj);
            }
        } else if (parseNode instanceof SqlSelect) {
            SqlSelect sqlSelect = (SqlSelect)parseNode;
            SqlNode from = sqlSelect.getFrom();
            if (from instanceof SqlBasicCall) {
                this.packageBasicCall(retobj, from);
            } else if (from instanceof SqlJoin) {
                this.findDbTbBySqlJoin(retobj, (SqlJoin)from, true);
                this.findDbTbBySqlJoin(retobj, (SqlJoin)from, false);
            } else {
                SqlIdentifier sqlIdentifier = (SqlIdentifier)from;
                TbSimple dbTb = this.getDbTb(sqlIdentifier, null);
                retobj.add(dbTb);
            }
        } else if (parseNode instanceof SqlOrderBy) {
            SqlOrderBy orderby = (SqlOrderBy)parseNode;
            SqlNode sqlNode2 = (SqlNode)orderby.getOperandList().get(0);
            this.callSqlBasicCall(sqlNode2, retobj);
        } else if (parseNode instanceof SqlDrop) {
            SqlDrop drop = (SqlDrop)parseNode;
            List operandList = drop.getOperandList();
            TbSimple dbTb = this.getDbTb(operandList);
            retobj.add(dbTb);
        } else if (parseNode instanceof SqlInsert) {
            SqlInsert sqlInsert = (SqlInsert)this.sqlNode;
            TbSimple dbTb = this.getDbTb((SqlIdentifier)sqlInsert.getTargetTable(), null);
            retobj.add(dbTb);
        } else if (parseNode instanceof SqlUpdate) {
            SqlUpdate sqlUpdate = (SqlUpdate)this.sqlNode;
            TbSimple dbTb = this.getDbTb((SqlIdentifier)sqlUpdate.getTargetTable(), null);
            retobj.add(dbTb);
        } else if (parseNode instanceof SqlDelete) {
            SqlDelete sqlDelete = (SqlDelete)this.sqlNode;
            TbSimple dbTb = this.getDbTb((SqlIdentifier)sqlDelete.getTargetTable(), null);
            retobj.add(dbTb);
        }
    }

    private void findDbTbBySqlJoin(List<TbSimple> retobj, SqlJoin fromjoin, boolean isLeft) {
        SqlNode sqlNode;
        SqlNode sqlNode2 = sqlNode = isLeft ? fromjoin.getLeft() : fromjoin.getRight();
        if (sqlNode instanceof SqlJoin) {
            SqlJoin temp = (SqlJoin)sqlNode;
            this.findDbTbBySqlJoin(retobj, temp, true);
            this.findDbTbBySqlJoin(retobj, temp, false);
        } else if (sqlNode instanceof SqlBasicCall) {
            this.packageBasicCall(retobj, sqlNode);
        }
    }

    private void packageBasicCall(List<TbSimple> retobj, SqlNode sqlNode) {
        List nodelist = ((SqlBasicCall)sqlNode).getOperandList();
        if (nodelist.get(0) instanceof SqlSelect) {
            SqlParserAssit temp = new SqlParserAssit(this.defaultCatalog, this.defaultDb, (SqlNode)nodelist.get(0));
            List<TbSimple> tbs = temp.findTbInfos();
            retobj.addAll(tbs);
        } else if (nodelist.get(0) instanceof SqlIdentifier) {
            SqlIdentifier sqlIdentifier = (SqlIdentifier)nodelist.get(0);
            TbSimple dbTbLeft = this.getDbTb(sqlIdentifier, nodelist.size() > 1 ? ((SqlNode)nodelist.get(1)).toString() : null);
            retobj.add(dbTbLeft);
        }
    }

    private TbSimple getDbTb(SqlIdentifier sqlIdentifier, String alias) {
        TbSimple retobj = null;
        if (sqlIdentifier.names.size() == 1) {
            retobj = TbSimple.builder().catalog(this.defaultCatalog).db(this.defaultDb).tb((String)sqlIdentifier.names.get(0)).alias(alias).build();
        } else if (sqlIdentifier.names.size() == 2) {
            retobj = TbSimple.builder().catalog(this.defaultCatalog).db((String)sqlIdentifier.names.get(0)).tb((String)sqlIdentifier.names.get(1)).alias(alias).build();
        } else if (sqlIdentifier.names.size() == 3) {
            retobj = TbSimple.builder().catalog((String)sqlIdentifier.names.get(0)).db((String)sqlIdentifier.names.get(1)).tb((String)sqlIdentifier.names.get(2)).alias(alias).build();
        }
        return retobj;
    }

    private TbSimple getDbTb(List<SqlNode> operandList) {
        SqlIdentifier sqlIdentifier = (SqlIdentifier)operandList.get(0);
        TbSimple dbTbLeft = this.getDbTb(sqlIdentifier, operandList.size() > 1 ? operandList.get(1).toString() : null);
        return dbTbLeft;
    }

    private TbSimple getCatalogDb(List<SqlNode> operandList) {
        SqlIdentifier sqlIdentifier = null;
        if (operandList.get(0) instanceof SqlIdentifier) {
            sqlIdentifier = (SqlIdentifier)operandList.get(0);
        } else if (operandList.get(1) instanceof SqlIdentifier) {
            sqlIdentifier = (SqlIdentifier)operandList.get(1);
        } else {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u89e3\u6790catalog/db\u51fa\u9519");
        }
        TbSimple retobj = null;
        if (sqlIdentifier.names.size() == 1) {
            retobj = TbSimple.builder().catalog(this.defaultCatalog).db((String)sqlIdentifier.names.get(0)).build();
        } else if (sqlIdentifier.names.size() == 2) {
            retobj = TbSimple.builder().catalog((String)sqlIdentifier.names.get(0)).db((String)sqlIdentifier.names.get(1)).build();
        }
        return retobj;
    }
}

