/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.driver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.beans.TbSimple;
import net.wicp.tams.common.kubernetes.apiserver.KubeClientTams;
import net.wicp.tams.common.kubernetes.beans.KubernetesResultCol;
import net.wicp.tams.common.kubernetes.beans.KubernetesResultPo;
import net.wicp.tams.common.kubernetes.constant.ResourcesType;
import net.wicp.tams.common.kubernetes.driver.KubernetesConnection;
import net.wicp.tams.common.kubernetes.driver.KubernetesResultSet;
import net.wicp.tams.common.kubernetes.driver.SqlParserAssit;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.ddl.SqlCreateSchema;
import org.apache.calcite.sql.ddl.SqlDropSchema;
import org.slf4j.MDC;

public class KubernetesStatement
implements Statement {
    private final KubeClientTams clientTams;
    private final KubernetesConnection kubernetesConnection;
    private int fetchSize;
    private long maxRows;
    private KubernetesResultSet kubernetesResultSet;
    private SqlParserAssit sqlParserTams;

    public KubernetesStatement(KubernetesConnection kubernetesConnection) {
        this.clientTams = kubernetesConnection.getClientTams();
        this.kubernetesConnection = kubernetesConnection;
        this.fetchSize = 0;
        this.maxRows = 0L;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkClosed();
        this.chekSqlAndInit(sql);
        MDC.put((String)"execMethod", (String)"executeQuery");
        if (!this.sqlParserTams.isQuery()) {
            throw new SQLException("\u6b64\u65b9\u6cd5\u53ea\u63a5\u53d7\u67e5\u8be2\u7684SQL");
        }
        this.kubernetesResultSet = null;
        this.execute(sql);
        MDC.remove((String)"execMethod");
        return this.kubernetesResultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkClosed();
        this.chekSqlAndInit(sql);
        MDC.put((String)"execMethod", (String)"executeUpdate");
        if (this.sqlParserTams.isQuery()) {
            throw new SQLException("\u6b64\u65b9\u6cd5\u53ea\u63a5\u53d7\u975e\u67e5\u8be2\u7684SQL");
        }
        this.kubernetesResultSet = null;
        this.execute(sql);
        MDC.remove((String)"execMethod");
        String[] simpleData = this.kubernetesResultSet.getKubernetesResultPo().getSimpleData();
        if ("OK".equals(simpleData[0])) {
            return 0;
        }
        return 0;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        TbSimple tbSimple = this.chekSqlAndInit(sql);
        KubernetesResultPo po = null;
        if (!this.sqlParserTams.isQuery()) {
            this.sqlParserTams.doDdl(this.clientTams);
            ArrayList<Map<String, String>> curData = new ArrayList<Map<String, String>>();
            curData.add(CollectionUtil.newMapStr((String[])new String[]{"result", "ok"}));
            po = new KubernetesResultPo(new String[]{"result"}, curData);
        } else {
            po = new KubernetesResultPo(this.clientTams, ResourcesType.find(tbSimple.getTb()), this.sqlParserTams);
        }
        this.kubernetesResultSet = new KubernetesResultSet(po, this.fetchSize);
        return this.sqlParserTams.isQuery();
    }

    @Override
    public void close() throws SQLException {
        if (this.clientTams.isClosed()) {
            return;
        }
        this.cancel();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#getMaxFieldSize is not supported");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#setMaxFieldSize is not supported");
    }

    @Override
    public int getMaxRows() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#getMaxRows is not supported");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.setLargeMaxRows(max);
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.checkClosed();
        if (max < 0L) {
            throw new SQLException("Max rows must not be negative.");
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#setEscapeProcessing is not supported");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#getQueryTimeout is not supported");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#setQueryTimeout is not supported");
    }

    @Override
    public void cancel() throws SQLException {
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#setCursorName is not supported");
    }

    private TbSimple chekSqlAndInit(String sql) throws SQLException {
        String execMethod = MDC.get((String)"execMethod");
        if (StringUtil.isNotNull((Object)execMethod)) {
            return this.sqlParserTams.findTbInfos().get(0);
        }
        try {
            this.sqlParserTams = new SqlParserAssit(this.kubernetesConnection.getCatalog(), this.kubernetesConnection.getSchema(), sql);
        }
        catch (Exception e) {
            throw new SQLException("\u8bed\u6cd5\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7b26\u5408mysql\u8bed\u6cd5\u3002", e);
        }
        if (this.sqlParserTams.getSqlNode() instanceof SqlCreateSchema || this.sqlParserTams.getSqlNode() instanceof SqlDropSchema) {
            return null;
        }
        List<TbSimple> tbInfos = this.sqlParserTams.findTbInfos();
        if (tbInfos.size() > 1) {
            StringBuffer buff = new StringBuffer();
            for (TbSimple tbSimple : tbInfos) {
                buff.append(String.format("%s.%s,", tbSimple.getDb(), tbSimple.getTb()));
            }
            throw new SQLException(String.format("\u6682\u4e0d\u652f\u6301\u591a\u8868\u64cd\u4f5c:%s\u8bf7\u786e\u8ba4", buff.toString()));
        }
        TbSimple tbSimple = tbInfos.get(0);
        ResourcesType resourcesType = ResourcesType.find(tbSimple.getTb());
        if (resourcesType == ResourcesType.UNKNOWN) {
            throw new SQLException("\u6682\u4e0d\u652f\u6301\u6b64CRD\u7684\u64cd\u4f5c:" + tbSimple.getTb());
        }
        if (this.sqlParserTams.isQuery()) {
            List<String> colNames = this.sqlParserTams.findColNames();
            if (!colNames.contains("*")) {
                List<KubernetesResultCol> jdbcCols = resourcesType == ResourcesType.CRD ? this.clientTams.getCrdColDef(tbSimple.getTb()) : resourcesType.getJdbcColDef();
                StringBuffer buff = new StringBuffer();
                for (String colName : colNames) {
                    if (jdbcCols.contains(new KubernetesResultCol(colName))) continue;
                    buff.append(String.format("%s,", colName));
                }
                if (buff.length() > 0) {
                    throw new SQLException(String.format("\u5217\u6ca1\u6709\u5b9a\u4e49:%s\u8bf7\u786e\u8ba4", buff.toString()));
                }
            }
            return tbSimple;
        }
        if (resourcesType == ResourcesType.POD && (this.sqlParserTams.getSqlNode() instanceof SqlInsert || this.sqlParserTams.getSqlNode() instanceof SqlUpdate)) {
            throw new SQLException("pod\u4e0d\u5141\u8bb8\u65b0\u589e\u548c\u4fee\u6539");
        }
        return null;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.kubernetesResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        try {
            String resultColData = this.kubernetesResultSet.getKubernetesResultPo().getResultColData();
            return Integer.parseInt(resultColData);
        }
        catch (Throwable e) {
            throw new SQLException("Current result is not an update count.");
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.sqlParserTams.isQuery();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#setFetchDirection is not supported");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#getFetchDirection is not supported");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        if (rows < 0) {
            throw new SQLException("Fetch size must not be negative.");
        }
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#getResultSetConcurrency is not supported");
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#addBatch is not supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#clearBatch is not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#executeBatch is not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.kubernetesConnection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#getMoreResults is not supported");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#getGeneratedKeys is not supported");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return (int)this.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return (int)this.executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return (int)this.executeLargeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#execute is not supported");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#execute is not supported");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#execute is not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#getResultSetHoldability is not supported");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.clientTams.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#setPoolable is not supported");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#isPoolable is not supported");
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#closeOnCompletion is not supported");
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#isCloseOnCompletion is not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#isCloseOnCompletion is not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesStatement#isCloseOnCompletion is not supported");
    }

    protected void checkClosed() throws SQLException {
        if (this.clientTams.isClosed()) {
            throw new SQLException("This result set is already closed");
        }
    }
}

