/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.driver;

import io.fabric8.kubernetes.client.VersionInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.kubernetes.apiserver.KubeClientTams;
import net.wicp.tams.common.kubernetes.beans.KubernetesResultPo;
import net.wicp.tams.common.kubernetes.constant.ResourcesType;
import net.wicp.tams.common.kubernetes.driver.KubernetesConnection;
import net.wicp.tams.common.kubernetes.driver.KubernetesResultSet;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesDatabaseMetaData
implements DatabaseMetaData {
    private static final Logger log = LoggerFactory.getLogger(KubernetesDatabaseMetaData.class);
    private static final String[] SUPPORTED_TABLE_TYPES = new String[]{"TABLE"};
    public static final String DRIVER_VERSION = "0.1";
    public static final String JDBC_VERSION = "4.2";
    public final String DATABASE_PRODUCT_NAME = "kubernetes";
    private final KubeClientTams kubeClientTams;
    private final KubernetesConnection kubernetesConnection;
    private VersionInfo info;

    public KubernetesDatabaseMetaData(KubeClientTams kubeClientTams, KubernetesConnection kubernetesConnection) {
        this.kubeClientTams = kubeClientTams;
        this.kubernetesConnection = kubernetesConnection;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public String getURL() throws SQLException {
        return this.kubernetesConnection.getJdbcUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        return null;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.DATABASE_PRODUCT_NAME;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.kubeClientTams.getClient().getKubernetesVersion().getMajor();
    }

    @Override
    public String getDriverName() throws SQLException {
        return "Kubernetes Driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return DRIVER_VERSION;
    }

    @Override
    public int getDriverMajorVersion() {
        return Integer.valueOf(DRIVER_VERSION.split("\\.")[0]);
    }

    @Override
    public int getDriverMinorVersion() {
        return Integer.valueOf(DRIVER_VERSION.split("\\.")[1]);
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#usesLocalFiles is not supported");
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#usesLocalFilePerTable is not supported");
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsMixedCaseIdentifiers is not supported");
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#storesUpperCaseIdentifiers is not supported");
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#storesLowerCaseIdentifiers is not supported");
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#storesMixedCaseIdentifiers is not supported");
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsMixedCaseQuotedIdentifiers is not supported");
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#storesUpperCaseQuotedIdentifiers is not supported");
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#storesLowerCaseQuotedIdentifiers is not supported");
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#storesMixedCaseQuotedIdentifiers is not supported");
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "`";
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        log.info("====catalog===" + catalog);
        if (tableNamePattern == null) {
            tableNamePattern = "%";
        }
        if (types == null) {
            types = SUPPORTED_TABLE_TYPES;
        } else {
            ArrayList<String> last = new ArrayList<String>();
            for (String type : types) {
                if (!ArrayUtils.contains((Object[])SUPPORTED_TABLE_TYPES, (Object)type)) continue;
                last.add(type);
            }
            types = last.toArray(new String[last.size()]);
        }
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>();
        if ("".equals(catalog) || "".equals(schemaPattern)) {
            return new KubernetesResultSet(new KubernetesResultPo(new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"}, datas));
        }
        Pattern javaPattern = Pattern.compile(tableNamePattern.replace("%", ".*").replace("_", ".?"));
        List<ResourcesType> values = ResourcesType.getByGroup("jdbc");
        ResultSet databaseResult = this.getSchemas(catalog, schemaPattern);
        while (databaseResult.next()) {
            String catalogTemp = databaseResult.getString("TABLE_CATALOG");
            String dbTemp = databaseResult.getString("TABLE_SCHEM");
            for (ResourcesType resourcesType : values) {
                if (resourcesType == ResourcesType.CRD) {
                    for (String crdName : KubeClientTams.cusCache.keySet()) {
                        if (!javaPattern.matcher(crdName).matches()) continue;
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("TABLE_CAT", catalogTemp);
                        data.put("TABLE_SCHEM", dbTemp);
                        data.put("TABLE_NAME", crdName);
                        data.put("TABLE_TYPE", SUPPORTED_TABLE_TYPES[0]);
                        datas.add(data);
                    }
                    continue;
                }
                String tb = resourcesType.name().toLowerCase();
                if (!javaPattern.matcher(resourcesType.name().toLowerCase()).matches()) continue;
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("TABLE_CAT", catalogTemp);
                data.put("TABLE_SCHEM", dbTemp);
                data.put("TABLE_NAME", tb);
                data.put("TABLE_TYPE", SUPPORTED_TABLE_TYPES[0]);
                datas.add(data);
            }
        }
        return new KubernetesResultSet(new KubernetesResultPo(new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "SELF_REFERENCING_COL_NAME", "REF_GENERATION"}, datas));
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>();
        Set<String> groups = this.kubeClientTams.getGroups();
        for (String group : groups) {
            datas.add(CollectionUtil.newMapStr((String[])new String[]{"TABLE_CAT", group}));
        }
        KubernetesResultPo po = new KubernetesResultPo(new String[]{"TABLE_CAT"}, datas);
        if (!po.isSuc()) {
            throw new SQLException(po.getErrors());
        }
        KubernetesResultSet resultSet = new KubernetesResultSet(po);
        return resultSet;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>();
        for (String type : SUPPORTED_TABLE_TYPES) {
            datas.add(CollectionUtil.newMapStr((String[])new String[]{"TABLE_TYPE", type}));
        }
        return new KubernetesResultSet(new KubernetesResultPo(new String[]{"TABLE_TYPE"}, datas));
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>();
        ResultSet tableResult = this.getTables(catalog, schemaPattern, tableNamePattern, SUPPORTED_TABLE_TYPES);
        Pattern javaPattern = Pattern.compile(columnNamePattern.replace("%", ".*").replace("_", ".?"));
        while (tableResult.next()) {
            ResourcesType resourcesType = ResourcesType.find(tableResult.getString("TABLE_NAME"));
            List colList = null;
            colList = resourcesType == ResourcesType.CRD ? CollectionUtil.getColValStrFromObj(this.kubeClientTams.getCrdColDef(tableResult.getString("TABLE_NAME")), (String)"name") : resourcesType.getJdbcCols();
            int index = 0;
            for (String jdbcCol : colList) {
                if (!javaPattern.matcher(jdbcCol).matches()) continue;
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("TABLE_CAT", tableResult.getString("TABLE_CAT"));
                data.put("TABLE_SCHEM", tableResult.getString("TABLE_SCHEM"));
                data.put("TABLE_NAME", tableResult.getString("TABLE_NAME"));
                data.put("COLUMN_NAME", jdbcCol);
                data.put("DATA_TYPE", "varchar");
                data.put("TYPE_NAME", "varchar(255)");
                data.put("COLUMN_SIZE", "255");
                data.put("IS_NULLABLE", "NO");
                data.put("NULLABLE", String.valueOf(0));
                data.put("ORDINAL_POSITION", String.valueOf(index++));
                data.put("IS_AUTOINCREMENT", "NO");
                data.put("IS_GENERATEDCOLUMN", "NO");
                data.put("NUM_PREC_RADIX", "10");
                datas.add(data);
            }
        }
        return new KubernetesResultSet(new KubernetesResultPo(new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN"}, datas));
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>();
        datas.add(CollectionUtil.newMapStr((String[])new String[]{"TABLE_CAT", catalog, "TABLE_SCHEM", schema, "TABLE_NAME", table, "COLUMN_NAME", "name", "KEY_SEQ", String.valueOf(0), "PK_NAME", String.format("%s_key", "name")}));
        return new KubernetesResultSet(new KubernetesResultPo(new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"}, datas));
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        if (this.info == null) {
            this.info = this.kubeClientTams.getKubernetesVersion();
        }
        return Integer.valueOf(this.info.getMajor());
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        if (this.info == null) {
            this.info = this.kubeClientTams.getKubernetesVersion();
        }
        return Integer.valueOf(this.info.getMinor());
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return Integer.valueOf(JDBC_VERSION.split("\\.")[0]);
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return Integer.valueOf(JDBC_VERSION.split("\\.")[1]);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (schemaPattern == null) {
            schemaPattern = "%";
        }
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>();
        Pattern javaPattern = Pattern.compile(schemaPattern.replace("%", ".*").replace("_", ".?"));
        List<String> allNamespace = this.kubeClientTams.getAllNamespace(catalog);
        for (String namespace : allNamespace) {
            if (!javaPattern.matcher(namespace).matches()) continue;
            datas.add(CollectionUtil.newMapStr((String[])new String[]{"TABLE_SCHEM", namespace, "TABLE_CATALOG", catalog}));
        }
        return new KubernetesResultSet(new KubernetesResultPo(new String[]{"TABLE_SCHEM", "TABLE_CATALOG"}, datas));
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#isReadOnly is not supported");
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#nullsAreSortedHigh is not supported");
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#nullsAreSortedLow is not supported");
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#nullsAreSortedAtStart is not supported");
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#nullsAreSortedAtEnd is not supported");
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#allProceduresAreCallable is not supported");
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getSQLKeywords is not supported");
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getNumericFunctions is not supported");
    }

    @Override
    public String getStringFunctions() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getStringFunctions is not supported");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getSystemFunctions is not supported");
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getTimeDateFunctions is not supported");
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getSearchStringEscape is not supported");
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#nullPlusNonNullIsNull is not supported");
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsConvert is not supported");
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsConvert is not supported");
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsMultipleResultSets is not supported");
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsMultipleTransactions is not supported");
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsMinimumSQLGrammar is not supported");
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsCoreSQLGrammar is not supported");
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsExtendedSQLGrammar is not supported");
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsANSI92EntryLevelSQL is not supported");
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsANSI92IntermediateSQL is not supported");
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsANSI92FullSQL is not supported");
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsIntegrityEnhancementFacility is not supported");
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "database";
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getProcedureTerm is not supported");
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "catalog";
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#isCatalogAtStart is not supported");
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getCatalogSeparator is not supported");
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsSchemasInProcedureCalls is not supported");
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsSchemasInIndexDefinitions is not supported");
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsSchemasInPrivilegeDefinitions is not supported");
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsCatalogsInProcedureCalls is not supported");
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsCatalogsInIndexDefinitions is not supported");
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsCatalogsInPrivilegeDefinitions is not supported");
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsPositionedDelete is not supported");
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsPositionedUpdate is not supported");
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsSelectForUpdate is not supported");
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsStoredProcedures is not supported");
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsOpenCursorsAcrossCommit is not supported");
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsOpenCursorsAcrossRollback is not supported");
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsOpenStatementsAcrossCommit is not supported");
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsOpenStatementsAcrossRollback is not supported");
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxBinaryLiteralLength is not supported");
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxCharLiteralLength is not supported");
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxColumnNameLength is not supported");
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxColumnsInGroupBy is not supported");
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxColumnsInIndex is not supported");
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxColumnsInOrderBy is not supported");
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxColumnsInSelect is not supported");
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxColumnsInTable is not supported");
    }

    @Override
    public int getMaxConnections() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxConnections is not supported");
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxCursorNameLength is not supported");
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxIndexLength is not supported");
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxSchemaNameLength is not supported");
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxProcedureNameLength is not supported");
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxCatalogNameLength is not supported");
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxRowSize is not supported");
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#doesMaxRowSizeIncludeBlobs is not supported");
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxStatementLength is not supported");
    }

    @Override
    public int getMaxStatements() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxStatements is not supported");
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxTableNameLength is not supported");
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxTablesInSelect is not supported");
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getMaxUserNameLength is not supported");
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getDefaultTransactionIsolation is not supported");
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsTransactions is not supported");
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsTransactionIsolationLevel is not supported");
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsDataDefinitionAndDataManipulationTransactions is not supported");
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsDataManipulationTransactionsOnly is not supported");
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#dataDefinitionCausesTransactionCommit is not supported");
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#dataDefinitionIgnoredInTransactions is not supported");
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getProcedures is not supported");
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getProcedureColumns is not supported");
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getColumnPrivileges is not supported");
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getTablePrivileges is not supported");
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getBestRowIdentifier is not supported");
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getVersionColumns is not supported");
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getImportedKeys is not supported");
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getExportedKeys is not supported");
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getCrossReference is not supported");
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getTypeInfo is not supported");
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getIndexInfo is not supported");
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsResultSetConcurrency is not supported");
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#ownUpdatesAreVisible is not supported");
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#ownDeletesAreVisible is not supported");
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#ownInsertsAreVisible is not supported");
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#othersUpdatesAreVisible is not supported");
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#othersDeletesAreVisible is not supported");
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#othersInsertsAreVisible is not supported");
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#updatesAreDetected is not supported");
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#deletesAreDetected is not supported");
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#insertsAreDetected is not supported");
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsBatchUpdates is not supported");
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getUDTs is not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.kubernetesConnection;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsSavepoints is not supported");
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsNamedParameters is not supported");
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsMultipleOpenResults is not supported");
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsGetGeneratedKeys is not supported");
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getSuperTypes is not supported");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getSuperTypes is not supported");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getAttributes is not supported");
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsResultSetHoldability is not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getResultSetHoldability is not supported");
    }

    @Override
    public int getSQLStateType() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getSQLStateType is not supported");
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#locatorsUpdateCopy is not supported");
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsStatementPooling is not supported");
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getRowIdLifetime is not supported");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#supportsStoredFunctionsUsingCallSyntax is not supported");
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#autoCommitFailureClosesAllResultSets is not supported");
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getClientInfoProperties is not supported");
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return this.getProcedures(catalog, schemaPattern, functionNamePattern);
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return this.getProcedureColumns(catalog, schemaPattern, functionNamePattern, columnNamePattern);
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#getPseudoColumns is not supported");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#generatedKeyAlwaysReturned is not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#unwrap is not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesDatabaseMetaData#isWrapperFor is not supported");
    }
}

