/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.driver;

import io.fabric8.kubernetes.api.model.Namespace;
import java.io.File;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.StrPattern;
import net.wicp.tams.common.kubernetes.apiserver.KubeClientTams;
import net.wicp.tams.common.kubernetes.driver.KubernetesDatabaseMetaData;
import net.wicp.tams.common.kubernetes.driver.KubernetesStatement;
import org.apache.commons.lang3.ArrayUtils;

public class KubernetesConnection
implements Connection {
    private final KubeClientTams clientTams;
    private final String jdbcUrl;
    private String catalogDefault = Conf.get((String)"common.kubernetes.jdbc.catalogDefault");
    private final String[] params;

    public KubeClientTams getClientTams() {
        return this.clientTams;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    protected String[] getParams() {
        return this.params;
    }

    public KubernetesConnection(String jdbcUrl) throws Exception {
        if (StringUtil.isNull((Object)jdbcUrl)) {
            throw new IllegalArgumentException("url\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.jdbcUrl = jdbcUrl;
        String[] urlMetas = StrPattern.jdbcurl.group(jdbcUrl, new String[]{"type", "host", "port", "database", "params"});
        if (!"k8s".equals(urlMetas[0]) || StringUtil.isNull((Object)urlMetas[1])) {
            throw new IllegalArgumentException("\u975e\u6cd5\u7684url\uff0c\u683c\u5f0f\u53c2\u8003\uff1ajdbc:k8s://localhost:8083/db?context=gientech&conf=~/.kube/config");
        }
        String host = urlMetas[1];
        this.params = StringUtil.isNotNull((Object)urlMetas[4]) ? urlMetas[4].split("&") : new String[]{};
        int port = 6443;
        if (StringUtil.isNotNull((Object)urlMetas[2])) {
            try {
                port = Integer.valueOf(urlMetas[2]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("\u7aef\u53e3\u683c\u5f0f\u4e0d\u5bf9\uff1a" + urlMetas[2]);
            }
        }
        String context = null;
        String conf = null;
        if (ArrayUtils.isNotEmpty((Object[])this.params)) {
            for (String param : this.params) {
                String[] paramValAry = param.split("=");
                if ("context".equalsIgnoreCase(paramValAry[0])) {
                    context = StringUtil.trimSpace((String)paramValAry[1]);
                    continue;
                }
                if ("conf".equalsIgnoreCase(paramValAry[0])) {
                    conf = StringUtil.trimSpace((String)paramValAry[1]);
                    continue;
                }
                if (!"crd".equalsIgnoreCase(paramValAry[0])) continue;
                Properties crdProperties = IOUtil.fileToProperties((File)new File(StringUtil.trimSpace((String)paramValAry[1])));
                Conf.overProp((Properties)crdProperties);
            }
        }
        this.clientTams = StringUtil.isNotNull(conf) ? new KubeClientTams(IOUtil.slurp(conf), context) : ("localhost".equalsIgnoreCase(host) ? new KubeClientTams() : new KubeClientTams(host, port, context));
        if (StringUtil.isNotNull((Object)urlMetas[3])) {
            String[] catalogAndDb = urlMetas[3].split("\\.");
            this.setCatalog(catalogAndDb.length > 1 ? catalogAndDb[0] : this.catalogDefault);
            this.setSchema(catalogAndDb.length > 1 ? catalogAndDb[1] : catalogAndDb[0]);
        } else {
            this.setCatalog(this.catalogDefault);
            this.setSchema(this.clientTams.getDefaultNamespace());
        }
    }

    public KubernetesConnection() throws Exception {
        this(Conf.get((String)"common.kubernetes.jdbc.url", (String)String.format("jdbc:k8s://%s:%s/%s", Conf.get((String)"common.kubernetes.jdbc.host"), Conf.get((String)"common.kubernetes.jdbc.port"), Conf.get((String)"common.kubernetes.jdbc.context", (String)""))));
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new KubernetesStatement(this);
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed()) {
            this.clientTams.close();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.clientTams.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new KubernetesDatabaseMetaData(this.clientTams, this);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.catalogDefault = catalog;
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.catalogDefault;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        Namespace namespace = this.clientTams.getNamespace(schema, this.getCatalog());
        if (namespace == null) {
            throw new SQLException("\u6ca1\u6709\u6b64\u540d\u79f0\u7a7a\u95f4,\u8bf7\u786e\u5b9a\u5728\u6b64\u7ec4\u4e0b\uff1a" + this.getCatalog());
        }
        this.clientTams.setDefaultNamespace(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.clientTams.getDefaultNamespace();
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#prepareStatement is not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#prepareCall is not supported");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#nativeSQL is not supported");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#commit is not supported");
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#rollback is not supported");
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#setReadOnly is not supported");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#isReadOnly is not supported");
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#setTransactionIsolation is not supported");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#createStatement is not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#prepareStatement is not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#prepareCall is not supported");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#getTypeMap is not supported");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#setTypeMap is not supported");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#setHoldability is not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#getHoldability is not supported");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#setSavepoint is not supported");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#setSavepoint is not supported");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#rollback is not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#releaseSavepoint is not supported");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#createStatement is not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#prepareStatement is not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#prepareCall is not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#prepareStatement is not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#prepareStatement is not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#prepareStatement is not supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#createClob is not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#createBlob is not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#createNClob is not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#createSQLXML is not supported");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            this.clientTams.getKubernetesVersion();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new SQLClientInfoException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#getClientInfo is not supported");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#getClientInfo is not supported");
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#createArrayOf is not supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#createStruct is not supported");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#abort is not supported");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#setNetworkTimeout is not supported");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#getNetworkTimeout is not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#unwrap is not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("KubernetesConnection#isWrapperFor is not supported");
    }
}

