/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.convertvalue;

import java.util.Map;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.kubernetes.helm.HelmClient;
import net.wicp.tams.common.kubernetes.helm.HelmCmd;
import net.wicp.tams.common.kubernetes.helm.HelmFlags;
import net.wicp.tams.common.kubernetes.helm.IConvertParams;
import net.wicp.tams.common.kubernetes.helm.po.HelmInst;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertValueHelmStatus<T>
implements IConvertValue<T> {
    private static final Logger log = LoggerFactory.getLogger(ConvertValueHelmStatus.class);
    private final IConvertParams<T> packer;
    private final String[] fitHelmNames;
    private IConvertValue<Object> userConvert;

    public ConvertValueHelmStatus(IConvertParams<T> packer, String nameForNameCol) {
        this.packer = packer;
        this.fitHelmNames = null;
    }

    public ConvertValueHelmStatus(IConvertParams<T> packer, String[] fitHelmNames) {
        this.packer = packer;
        this.fitHelmNames = fitHelmNames;
    }

    public String getStr(T keyObj) {
        Map<HelmFlags, String> values = this.packer.pack(keyObj);
        Result call = HelmClient.call(HelmCmd.list, values);
        String retstr = "\u672a\u90e8\u7f72";
        if (!call.isSuc()) {
            retstr = "\u5f02\u5e38";
        } else if (ArrayUtils.isEmpty((Object[])call.retObjs())) {
            retstr = "\u672a\u90e8\u7f72";
        } else {
            for (Object obj : call.retObjs()) {
                HelmInst helmInst = (HelmInst)obj;
                try {
                    if (ArrayUtils.isNotEmpty((Object[])this.fitHelmNames) && ArrayUtils.contains((Object[])this.fitHelmNames, (Object)helmInst.getName())) {
                        retstr = helmInst.getStatus();
                        break;
                    }
                    if (!helmInst.getName().equals(values.get((Object)HelmFlags.name))) continue;
                    retstr = helmInst.getStatus();
                    break;
                }
                catch (Exception e) {
                    log.error("\u8f6c\u6362\u5931\u8d25", (Throwable)e);
                }
            }
        }
        if (this.userConvert != null) {
            return this.userConvert.getStr((Object)Pair.of(keyObj, (Object)retstr));
        }
        return retstr;
    }

    public void setUserConvert(IConvertValue<Object> userConvert) {
        this.userConvert = userConvert;
    }
}

