/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.constant;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.wicp.tams.common.apiext.DateUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.json.JSONUtil;
import net.wicp.tams.common.constant.DateFormatCase;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.kubernetes.apiserver.KubeClientTams;
import net.wicp.tams.common.kubernetes.beans.KubernetesResultCol;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public enum ResourcesType implements IEnumCombobox
{
    SERVICE("\u7f51\u7edc", "Service", new String[]{"NAME", "TYPE", "CLUSTER-IP", "EXTERNAL-IP", "PORT(S)", "AGE"}, new String[]{"/spec/clusterIP:clusterIP", "/spec/type:type", "/spec/ports:ports", "/spec/selector:selector", "/spec/sessionAffinity:sessionAffinity"}, new String[]{"jdbc"}),
    DEPLOYMENT("\u90e8\u7f72", "Deployment", new String[]{"NAME", "DESIRED", "CURRENT", "UP-TO-DATE", "AVAILABLE", "AGE"}, new String[]{"/spec/replicas:replicas", "template/spec/containers/0/image:image", "/spec/template/spec/containers/0/ports:ports", "/spec/template/spec/containers/0/resources:resources", "/spec/template/spec/imagePullSecrets:imagePullSecrets"}, new String[]{"jdbc"}),
    POD("\u5bb9\u5668", "Pod", new String[]{"NAME", "READY", "STATUS", "RESTARTS", "AGE"}, new String[]{"/spec/containers/0/image:image", "/spec/containers/0/ports:ports", "/spec/containers/0/resources:resources", "/status/phase:status", "/status/startTime:age"}, new String[]{"jdbc"}),
    CRD("\u81ea\u5b9a\u4e49\u8d44\u6e90", "crd", null, null, new String[]{"jdbc"}),
    UNKNOWN("\u4e0d\u652f\u6301\u7684\u7c7b\u578b", "Unknown", new String[0], new String[0], new String[0]);

    private final String desc;
    private final String desc_en;
    private final String[] kubectlColNames;
    private final String[] jdbcMetaCols = new String[]{"name", "namespace"};
    private final String[] jdbcSpecCols;
    private final String[] groupSel;

    public String[] getColValue(HasMetadata queryResByPage, String ... colNames) {
        if (ArrayUtils.isEmpty((Object[])colNames)) {
            return new String[0];
        }
        List<KubernetesResultCol> colSort = this.getSortCol(colNames);
        String[] ret = this.getColValue(queryResByPage, colSort);
        return ret;
    }

    public String[] getColValue(HasMetadata queryResByPage, List<KubernetesResultCol> colSort) {
        String[] ret = new String[colSort.size()];
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.valueToTree((Object)queryResByPage);
        for (int i = 0; i < colSort.size(); ++i) {
            JsonPointer jsonPointer = JsonPointer.compile((String)colSort.get(i).getJsonPath());
            JsonNode titleNode = rootNode.at(jsonPointer);
            if (titleNode.isMissingNode()) continue;
            if (this == POD && "age".equalsIgnoreCase(colSort.get(i).getName())) {
                try {
                    Date date = DateFormatCase.TZyyyyMMddHHmmss.getInstanc().parse(titleNode.toString().replace("\"", ""));
                    ret[i] = DateUtil.convertAgeFromTimeDif((long)((System.currentTimeMillis() - date.getTime()) / 1000L));
                }
                catch (Exception e) {
                    ret[i] = titleNode.toString();
                }
                continue;
            }
            ret[i] = titleNode.toString();
        }
        return ret;
    }

    public <T extends HasMetadata> T setColValue(HasMetadata oriObj, Map<String, Object> crd, Class<T> classz, boolean needMust) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode rootNode = (ObjectNode)mapper.valueToTree((Object)oriObj);
        List<KubernetesResultCol> jdbcColDefs = this.getJdbcColDef();
        for (KubernetesResultCol jdbcColDef : jdbcColDefs) {
            if (!crd.containsKey(jdbcColDef.getName())) continue;
            JSONUtil.setValueByPath((ObjectNode)rootNode, (String)jdbcColDef.getJsonPath(), (Object)crd.get(jdbcColDef.getName()));
        }
        if (needMust && this == DEPLOYMENT) {
            String labelValue = String.format("uuid-%s", crd.get("name"));
            ObjectNode lable = JsonNodeFactory.instance.objectNode();
            lable.put("app", labelValue);
            lable.put("from", "tams-jdbc");
            JSONUtil.setValueByPath((ObjectNode)rootNode, (String)"/spec/template/spec/containers/0/name", (Object)crd.get("name"));
            JSONUtil.setValueByPath((ObjectNode)rootNode, (String)"/spec/template/metadata/labels", (Object)lable);
            JSONUtil.setValueByPath((ObjectNode)rootNode, (String)"/spec/selector/matchLabels", (Object)lable);
        }
        try {
            return (T)((HasMetadata)mapper.treeToValue((TreeNode)rootNode, classz));
        }
        catch (Exception e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error);
        }
    }

    public List<KubernetesResultCol> getSortCol(String ... colNames) {
        return this.getSortCol(this.getJdbcColDef(), colNames);
    }

    public List<KubernetesResultCol> getSortCol(List<KubernetesResultCol> oriCol, String ... colNames) {
        if (ArrayUtils.contains((Object[])colNames, (Object)"*")) {
            return oriCol;
        }
        ArrayList<KubernetesResultCol> colSort = new ArrayList<KubernetesResultCol>();
        for (String colName : colNames) {
            int indexOf = oriCol.indexOf(new KubernetesResultCol(colName.toLowerCase()));
            if (indexOf < 0) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u5217\u4e0d\u5b58\u5728:" + colName);
            }
            colSort.add(oriCol.get(indexOf));
        }
        return colSort;
    }

    public String[] getColValueAll(HasMetadata queryResByPage) {
        return this.getColValue(queryResByPage, this.getColNames());
    }

    private ResourcesType(String desc, String desc_en, String[] kubectlColNames, String[] jdbcSpecCols, String[] groupSel) {
        this.desc = desc;
        this.desc_en = desc_en;
        this.kubectlColNames = kubectlColNames;
        this.jdbcSpecCols = jdbcSpecCols;
        this.groupSel = groupSel;
    }

    public static List<ResourcesType> getByGroup(String groupName) {
        ArrayList<ResourcesType> retlist = new ArrayList<ResourcesType>();
        for (ResourcesType resourcesType : ResourcesType.values()) {
            if (!ArrayUtils.contains((Object[])resourcesType.getGroupSel(), (Object)groupName)) continue;
            retlist.add(resourcesType);
        }
        return retlist;
    }

    public List<String> getJdbcCols() {
        List<KubernetesResultCol> jdbcColDef = this.getJdbcColDef();
        return jdbcColDef.stream().map(e -> e.getName()).collect(Collectors.toList());
    }

    public List<KubernetesResultCol> getJdbcColDef() {
        ArrayList<KubernetesResultCol> ret = new ArrayList<KubernetesResultCol>();
        for (String metacol : this.jdbcMetaCols) {
            KubernetesResultCol temp = new KubernetesResultCol(metacol);
            temp.setJsonPath(String.format("/metadata/%s", metacol));
            ret.add(temp);
        }
        for (String col : this.jdbcSpecCols) {
            String[] cosEles = col.split(":");
            KubernetesResultCol temp = new KubernetesResultCol(cosEles.length > 1 ? cosEles[1] : cosEles[0]);
            temp.setJsonPath(cosEles[0]);
            ret.add(temp);
        }
        return ret;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getName() {
        return this.name();
    }

    public String[] getColNames() {
        return this.kubectlColNames;
    }

    public String getDesc_zh() {
        return this.desc;
    }

    public String getDesc_en() {
        return this.desc_en;
    }

    public String getKubectlColValue(String valueStr, String colName) {
        int indexOf = ArrayUtils.indexOf((Object[])this.kubectlColNames, (Object)colName);
        if (StringUtil.isNull((Object)valueStr) || indexOf < 0) {
            return "";
        }
        String[] mens = valueStr.replaceAll("\\s+", "|").split("\\|");
        if ("FAILED".equals(valueStr)) {
            return valueStr;
        }
        return mens[indexOf];
    }

    public static ResourcesType find(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return UNKNOWN;
        }
        for (ResourcesType ele : ResourcesType.values()) {
            if (!name.equalsIgnoreCase(ele.name())) continue;
            return ele;
        }
        boolean isCrd = KubeClientTams.cusCache.containsKey(name);
        return isCrd ? CRD : UNKNOWN;
    }

    public String[] getGroupSel() {
        return this.groupSel;
    }
}

