/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.beans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.kubernetes.apiserver.KubeClientTams;
import net.wicp.tams.common.kubernetes.beans.KubernetesResultCol;
import net.wicp.tams.common.kubernetes.constant.ResourcesType;
import net.wicp.tams.common.kubernetes.driver.SqlParserAssit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;

public class KubernetesResultPo {
    private List<KubernetesResultCol> cols;
    private String[] colNames;
    private List<String[]> curData = new ArrayList<String[]>();
    private int curPage;
    private int cursor = -1;
    private String errors;
    private final ResourcesType resourcesType;
    private final KubeClientTams kubeClientTams;
    private final SqlParserAssit sqlParserTams;
    private final boolean isQuery;
    private long maxCursor = 0L;

    public KubernetesResultPo(KubeClientTams kubeClientTams, ResourcesType resourcesType, SqlParserAssit sqlParserTams) {
        this.resourcesType = resourcesType;
        this.cols = resourcesType == ResourcesType.CRD ? resourcesType.getSortCol(kubeClientTams.getCrdColDef(sqlParserTams.findTbInfos().get(0).getTb()), sqlParserTams.findColNames().toArray(new String[sqlParserTams.findColNames().size()])) : resourcesType.getSortCol(sqlParserTams.findColNames().toArray(new String[sqlParserTams.findColNames().size()]));
        this.kubeClientTams = kubeClientTams;
        this.sqlParserTams = sqlParserTams;
        this.isQuery = sqlParserTams.isQuery();
        this.curData = kubeClientTams.statementsByPage(resourcesType, this.sqlParserTams, 0, 100L);
    }

    public KubernetesResultPo(String[] colNames, List<Map<String, String>> curData) {
        this.resourcesType = null;
        this.kubeClientTams = null;
        this.sqlParserTams = null;
        this.isQuery = false;
        this.initData(colNames, curData);
    }

    public void initData(String[] colNames, List<Map<String, String>> curData) {
        this.colNames = colNames;
        if (curData != null) {
            for (Map<String, String> map : curData) {
                String[] curDate = new String[colNames.length];
                for (int i = 0; i < colNames.length; ++i) {
                    curDate[i] = map.containsKey(colNames[i]) ? map.get(colNames[i]) : null;
                }
                this.curData.add(curDate);
            }
        }
        this.cols = new ArrayList<KubernetesResultCol>();
        for (int i = 0; i < colNames.length; ++i) {
            this.cols.add(new KubernetesResultCol(this.colNames[i], "varchar"));
        }
    }

    public void beforeFirst() {
        this.cursor = -1;
    }

    public void afterLast() {
        this.cursor = this.curData.size() - 1;
    }

    public boolean isSuc() {
        return StringUtil.isNull((Object)this.errors);
    }

    public String[] getColNames() {
        if (!this.isSuc()) {
            return null;
        }
        if (this.colNames != null && this.colNames.length == this.cols.size()) {
            return this.colNames;
        }
        List colFromObj = CollectionUtil.getColFromObj(this.cols, (String)"name");
        this.colNames = colFromObj.toArray(new String[colFromObj.size()]);
        return this.colNames;
    }

    public String[] getDataCurRow() {
        if (!this.isSuc()) {
            return null;
        }
        if (this.cursor == -1) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_sql_notOpenRs);
        }
        return this.curData.get(this.cursor);
    }

    public String[] getSimpleData() {
        if (!this.isSuc()) {
            return null;
        }
        String[] ret = new String[this.curData.size()];
        for (int i = 0; i < this.curData.size(); ++i) {
            ret[i] = this.curData.get(i)[0];
        }
        return ret;
    }

    public String getResultColData() {
        this.cursor = 0;
        String dataColByCurRow = this.getDataColByCurRow("result");
        return dataColByCurRow;
    }

    public String getDataColByCurRow(String col) {
        if (!this.isSuc()) {
            return null;
        }
        int indexOf = ArrayUtils.indexOf((Object[])this.getColNames(), (Object)col);
        if (indexOf == -1) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u6ca1\u6709\u6b64\u5217");
        }
        return this.getDataCurRow()[indexOf];
    }

    public boolean next(long maxRows) {
        if (!this.isSuc()) {
            return false;
        }
        if (++this.maxCursor > maxRows) {
            return false;
        }
        if (this.cursor < this.curData.size() - 1) {
            ++this.cursor;
            return true;
        }
        if (!this.isQuery) {
            return false;
        }
        if (CollectionUtils.isEmpty(this.curData) || (long)this.curData.size() < maxRows) {
            return false;
        }
        int nextPage = this.getCurPage() + 1;
        List<String[]> result = this.kubeClientTams.statementsByPage(this.resourcesType, this.sqlParserTams, nextPage, maxRows);
        this.setCurPage(nextPage);
        this.setErrors("");
        this.setMaxCursor(0L);
        this.setCurData(result);
        return CollectionUtils.isNotEmpty(result);
    }

    public List<KubernetesResultCol> getCols() {
        return this.cols;
    }

    public List<String[]> getCurData() {
        return this.curData;
    }

    public int getCurPage() {
        return this.curPage;
    }

    public int getCursor() {
        return this.cursor;
    }

    public String getErrors() {
        return this.errors;
    }

    public ResourcesType getResourcesType() {
        return this.resourcesType;
    }

    public KubeClientTams getKubeClientTams() {
        return this.kubeClientTams;
    }

    public SqlParserAssit getSqlParserTams() {
        return this.sqlParserTams;
    }

    public boolean isQuery() {
        return this.isQuery;
    }

    public long getMaxCursor() {
        return this.maxCursor;
    }

    public void setCols(List<KubernetesResultCol> cols) {
        this.cols = cols;
    }

    public void setErrors(String errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesResultPo)) {
            return false;
        }
        KubernetesResultPo other = (KubernetesResultPo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurPage() != other.getCurPage()) {
            return false;
        }
        if (this.getCursor() != other.getCursor()) {
            return false;
        }
        if (this.isQuery() != other.isQuery()) {
            return false;
        }
        if (this.getMaxCursor() != other.getMaxCursor()) {
            return false;
        }
        List<KubernetesResultCol> this$cols = this.getCols();
        List<KubernetesResultCol> other$cols = other.getCols();
        if (this$cols == null ? other$cols != null : !((Object)this$cols).equals(other$cols)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getColNames(), other.getColNames())) {
            return false;
        }
        List<String[]> this$curData = this.getCurData();
        List<String[]> other$curData = other.getCurData();
        if (this$curData == null ? other$curData != null : !((Object)this$curData).equals(other$curData)) {
            return false;
        }
        String this$errors = this.getErrors();
        String other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !this$errors.equals(other$errors)) {
            return false;
        }
        ResourcesType this$resourcesType = this.getResourcesType();
        ResourcesType other$resourcesType = other.getResourcesType();
        if (this$resourcesType == null ? other$resourcesType != null : !((Object)((Object)this$resourcesType)).equals((Object)other$resourcesType)) {
            return false;
        }
        KubeClientTams this$kubeClientTams = this.getKubeClientTams();
        KubeClientTams other$kubeClientTams = other.getKubeClientTams();
        if (this$kubeClientTams == null ? other$kubeClientTams != null : !this$kubeClientTams.equals(other$kubeClientTams)) {
            return false;
        }
        SqlParserAssit this$sqlParserTams = this.getSqlParserTams();
        SqlParserAssit other$sqlParserTams = other.getSqlParserTams();
        return !(this$sqlParserTams == null ? other$sqlParserTams != null : !this$sqlParserTams.equals(other$sqlParserTams));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KubernetesResultPo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurPage();
        result = result * 59 + this.getCursor();
        result = result * 59 + (this.isQuery() ? 79 : 97);
        long $maxCursor = this.getMaxCursor();
        result = result * 59 + (int)($maxCursor >>> 32 ^ $maxCursor);
        List<KubernetesResultCol> $cols = this.getCols();
        result = result * 59 + ($cols == null ? 43 : ((Object)$cols).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getColNames());
        List<String[]> $curData = this.getCurData();
        result = result * 59 + ($curData == null ? 43 : ((Object)$curData).hashCode());
        String $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : $errors.hashCode());
        ResourcesType $resourcesType = this.getResourcesType();
        result = result * 59 + ($resourcesType == null ? 43 : ((Object)((Object)$resourcesType)).hashCode());
        KubeClientTams $kubeClientTams = this.getKubeClientTams();
        result = result * 59 + ($kubeClientTams == null ? 43 : $kubeClientTams.hashCode());
        SqlParserAssit $sqlParserTams = this.getSqlParserTams();
        result = result * 59 + ($sqlParserTams == null ? 43 : $sqlParserTams.hashCode());
        return result;
    }

    public String toString() {
        return "KubernetesResultPo(cols=" + this.getCols() + ", colNames=" + Arrays.deepToString(this.getColNames()) + ", curData=" + this.getCurData() + ", curPage=" + this.getCurPage() + ", cursor=" + this.getCursor() + ", errors=" + this.getErrors() + ", resourcesType=" + (Object)((Object)this.getResourcesType()) + ", kubeClientTams=" + this.getKubeClientTams() + ", sqlParserTams=" + this.getSqlParserTams() + ", isQuery=" + this.isQuery() + ", maxCursor=" + this.getMaxCursor() + ")";
    }

    private void setColNames(String[] colNames) {
        this.colNames = colNames;
    }

    private void setCurData(List<String[]> curData) {
        this.curData = curData;
    }

    private void setCurPage(int curPage) {
        this.curPage = curPage;
    }

    private void setCursor(int cursor) {
        this.cursor = cursor;
    }

    private void setMaxCursor(long maxCursor) {
        this.maxCursor = maxCursor;
    }
}

