/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.apiserver.crd;

import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.kubernetes.apiserver.crd.ICrdDef;

public class CrdDefConfig
implements ICrdDef {
    private final Map<String, String> confmap;

    public CrdDefConfig(String crdName) {
        String confPre = String.format("common.kubernetes.crd.conf.%s.", crdName);
        this.confmap = Conf.getPre((String)confPre, (boolean)true);
    }

    @Override
    public String getDesc() {
        return this.confmap.get("desc");
    }

    @Override
    public String getGroup() {
        return this.confmap.get("group");
    }

    @Override
    public String getPlural() {
        return this.confmap.get("plural");
    }

    @Override
    public String getScope() {
        return StringUtil.hasNull((String[])new String[]{this.confmap.get("scope"), "Namespaced"});
    }

    @Override
    public String getKind() {
        return this.confmap.get("plural");
    }

    @Override
    public String[] getShortNames() {
        return this.confmap.get("shortNames").split(",");
    }

    @Override
    public String[] getVersions() {
        return this.confmap.get("versions").split(",");
    }
}

