/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.apiserver;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSource;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.GracePeriodConfigurable;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.V1ApiextensionAPIGroupDSL;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.FilterNested;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceAccountResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.kubernetes.client.Exec;
import io.kubernetes.client.PodLogs;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.NetworkingV1Api;
import io.kubernetes.client.openapi.apis.RbacAuthorizationV1Api;
import io.kubernetes.client.openapi.models.V1ClusterRoleBinding;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentSpec;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1HTTPIngressRuleValue;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1IngressServiceBackend;
import io.kubernetes.client.openapi.models.V1IngressSpec;
import io.kubernetes.client.openapi.models.V1IngressTLS;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1OwnerReference;
import io.kubernetes.client.openapi.models.V1RoleBinding;
import io.kubernetes.client.openapi.models.V1RoleRef;
import io.kubernetes.client.openapi.models.V1ServiceBackendPort;
import io.kubernetes.client.openapi.models.V1Subject;
import io.kubernetes.client.util.Yaml;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.FreemarkUtil;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.NumberUtil;
import net.wicp.tams.common.apiext.PwdUtil;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.yaml.YamlAssist;
import net.wicp.tams.common.beans.SqlWherePo;
import net.wicp.tams.common.beans.StreamCopyBean;
import net.wicp.tams.common.beans.TbSimple;
import net.wicp.tams.common.callback.IProcess;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.kubernetes.apiserver.ApiClientCreator;
import net.wicp.tams.common.kubernetes.apiserver.ApiClientManager;
import net.wicp.tams.common.kubernetes.apiserver.crd.CrdDefConfig;
import net.wicp.tams.common.kubernetes.apiserver.crd.ICrdDef;
import net.wicp.tams.common.kubernetes.beans.KubernetesResultCol;
import net.wicp.tams.common.kubernetes.beans.PodPhase;
import net.wicp.tams.common.kubernetes.beans.QuotaBean;
import net.wicp.tams.common.kubernetes.constant.ResourcesType;
import net.wicp.tams.common.kubernetes.driver.SqlParserAssit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeClientTams {
    private static final Logger log = LoggerFactory.getLogger(KubeClientTams.class);
    private final KubernetesClient client;
    private final ApiClient apiClient;
    private String defaultNamespace = Conf.get((String)"common.kubernetes.apiserver.namespace.default");
    private final String GROUP_LABE = "tams/catalog";
    private final Set<String> groups = new HashSet<String>();
    public static final Map<String, ICrdDef> cusCache = new HashMap<String, ICrdDef>();
    private static final Map<String, List<KubernetesResultCol>> crdFieldCache = new HashMap<String, List<KubernetesResultCol>>();
    private static String confTemp;
    private volatile boolean state;

    public List<KubernetesResultCol> getCrdColDef(String crdName) {
        if (!cusCache.containsKey(crdName)) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u4e0d\u652f\u6301\u6b64CRD" + crdName);
        }
        if (!crdFieldCache.containsKey(crdName)) {
            List<KubernetesResultCol> crdColDef = this.getCrdColDef(cusCache.get(crdName));
            crdFieldCache.put(crdName, crdColDef);
        }
        return crdFieldCache.get(crdName);
    }

    private void apiClientInit(ApiClient apiClient) {
        Configuration.setDefaultApiClient((ApiClient)apiClient);
        this.apiClient.setReadTimeout(300000);
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public KubeClientTams() {
        String k8sConfig;
        this.groups.add(Conf.get((String)"common.kubernetes.jdbc.catalogDefault"));
        this.state = false;
        String incluster = Conf.get((String)"common.kubernetes.incluster");
        if (!YesOrNo.yes.name().equals(incluster) && !new File(k8sConfig = IOUtil.mergeFolderAndFilePath((String)System.getProperty("user.home"), (String[])new String[]{"/.kube/config"})).exists()) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u6ca1\u6709\u5728k8s\u5bb9\u5668\u4e2d\u8fd0\u884c\uff0c\u9700\u8981\u6709k8s\u7684\u8ba4\u8bc1\u6587\u4ef6\uff1a~/.kube/config");
        }
        this.client = this.initClient();
        this.apiClient = ApiClientManager.getApiClient();
        this.apiClientInit(this.apiClient);
    }

    public KubeClientTams(String kubeconfigstr, String confContext) {
        this.groups.add(Conf.get((String)"common.kubernetes.jdbc.catalogDefault"));
        this.state = false;
        Validate.notEmpty((CharSequence)kubeconfigstr, (String)"k8s\u7684\u8ba4\u8bc1\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.client = this.getClientForKube(kubeconfigstr, confContext);
        this.apiClient = new ApiClientCreator(kubeconfigstr, confContext).createObject();
        this.apiClientInit(this.apiClient);
    }

    public KubeClientTams(String pathTypePath) {
        this(IOUtil.slurpPathTypePath((String)pathTypePath), null);
    }

    public KubeClientTams(URI mastUrl) {
        this(String.format(confTemp, mastUrl.toString()), null);
    }

    public KubeClientTams(String host, int port, String webContext) {
        this(String.format(confTemp, StringUtil.isNotNull((Object)webContext) ? String.format("http://%s:%s/%s", host, port, webContext) : String.format("http://%s:%s", host, port)), null);
    }

    public KubeClientTams(KubernetesClient client, ApiClient apiClient) {
        this.groups.add(Conf.get((String)"common.kubernetes.jdbc.catalogDefault"));
        this.state = false;
        this.client = client;
        this.apiClient = apiClient;
        this.apiClientInit(apiClient);
    }

    private KubernetesClient initClient() {
        KubernetesClient client = null;
        if (StringUtil.isNotNull((Object)Conf.get((String)"common.kubernetes.kubeconfig.path"))) {
            String kubeconfigstr = IOUtil.slurp((String)Conf.get((String)"common.kubernetes.kubeconfig.path"));
            String context = IOUtil.slurp((String)Conf.get((String)"common.kubernetes.kubeconfig.context"));
            client = this.getClientForKube(kubeconfigstr, context);
        } else if (StringUtil.isNotNull((Object)Conf.get((String)"common.kubernetes.apiserver.master.url"))) {
            ConfigBuilder config = (ConfigBuilder)new ConfigBuilder().withMasterUrl(Conf.get((String)"common.kubernetes.apiserver.master.url"));
            if (StringUtil.isNotNull((Object)Conf.get((String)"common.kubernetes.apiserver.master.username"))) {
                config.withUsername(Conf.get((String)"common.kubernetes.apiserver.master.username"));
                config.withPassword(Conf.get((String)"common.kubernetes.apiserver.master.password"));
            }
            config.withTrustCerts(true);
            client = new KubernetesClientBuilder().withConfig(config.build()).build();
        } else {
            client = new KubernetesClientBuilder().build();
        }
        return client;
    }

    private KubernetesClient getClientForKube(String kubeconfigstr, String context) {
        try {
            Config config = StringUtil.isNull((Object)context) ? Config.fromKubeconfig((String)kubeconfigstr) : Config.fromKubeconfig((String)context, (String)kubeconfigstr, null);
            this.defaultNamespace = config.getNamespace();
            KubernetesClient client = new KubernetesClientBuilder().withConfig(config).build();
            return client;
        }
        catch (Exception e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_conn_error, "", (Throwable)e);
        }
    }

    private String getUseNamespaceName(String namespace) {
        String namespaceTrue = StringUtil.isNull((Object)namespace) ? this.defaultNamespace : namespace;
        return namespaceTrue;
    }

    public Namespace getNamespace(String namespace, String group) {
        Namespace myns = (Namespace)((Resource)this.client.namespaces().withName(namespace)).get();
        if (StringUtil.isNotNull((Object)group) && !Conf.get((String)"common.kubernetes.jdbc.catalogDefault").equalsIgnoreCase(group)) {
            if (myns.getMetadata().getLabels().containsKey("tams/catalog") && group.equalsIgnoreCase((String)myns.getMetadata().getLabels().get("tams/catalog"))) {
                return myns;
            }
            return null;
        }
        return myns;
    }

    public List<String> getAllNamespace(String group) {
        ArrayList<String> namespaceName = new ArrayList<String>();
        String _continue = null;
        ListOptions listOptions = ((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(10L))).withContinue(_continue)).build();
        NonNamespaceOperation namespaces = this.client.namespaces();
        do {
            NamespaceList namespacelist = null;
            namespacelist = StringUtil.isNotNull((Object)group) ? (NamespaceList)((FilterWatchListDeletable)namespaces.withLabel("tams/catalog", group)).list(listOptions) : (NamespaceList)namespaces.list(listOptions);
            namespacelist.getItems().stream().filter(new java.util.function.Predicate<Namespace>(){

                @Override
                public boolean test(Namespace t) {
                    return "Active".equals(t.getStatus().getPhase());
                }
            }).forEach(obj -> {
                namespaceName.add(obj.getMetadata().getName());
                Map labels = obj.getMetadata().getLabels();
                if (labels.containsKey("tams/catalog")) {
                    this.groups.add((String)labels.get("tams/catalog"));
                }
            });
            _continue = namespacelist.getMetadata().getContinue();
            listOptions.setContinue(_continue);
        } while (_continue != null);
        return namespaceName;
    }

    public List<String> getAllNamespace() {
        return this.getAllNamespace(null);
    }

    public ServiceList getServices(String namespace) {
        ServiceList myNsServices = (ServiceList)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).list();
        return myNsServices;
    }

    public ServiceList getServices() {
        return this.getServices(null);
    }

    public Service getService(String namespace, String serviceName) {
        Service myservice = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).withName(serviceName)).get();
        return myservice;
    }

    private Secret createAccountSecret(String namespace, String accountName) {
        ObjectMeta metadata = new ObjectMeta();
        metadata.setName(String.format("%s-token", accountName));
        metadata.setNamespace(namespace);
        metadata.setAnnotations(CollectionUtil.newMapStr((String[])new String[]{"kubernetes.io/service-account.name", accountName}));
        Secret service = ((SecretBuilder)((SecretBuilder)new SecretBuilder().withType("kubernetes.io/service-account-token")).withMetadata(metadata)).build();
        Secret create = (Secret)((Resource)((NonNamespaceOperation)this.client.secrets().inNamespace(namespace)).resource((Object)service)).create();
        return create;
    }

    public GenericKubernetesResource createCusObject(ICrdDef crdVesion, String version, String namespace, InputStream fileInputStream) {
        try {
            CustomResourceDefinitionContext context = crdVesion.getCrd();
            NonNamespaceOperation inNamespace = (NonNamespaceOperation)this.client.genericKubernetesResources((ResourceDefinitionContext)context).inNamespace(namespace);
            Resource dummyObject = (Resource)inNamespace.load(fileInputStream);
            GenericKubernetesResource create = (GenericKubernetesResource)dummyObject.create();
            return create;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("404 page not found")) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_pagenotfound, "\u6ca1\u6709\u5e03\u7f72api:" + e.getMessage());
            }
            if (e.getMessage().contains("already exists")) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_exists, "\u5df2\u5b58\u5728\u6b64\u7c7b\u578b\u7684\u540c\u540d\u8d44\u6e90:" + e.getMessage());
            }
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u5e03\u7f72\u81ea\u5b9a\u4e49\u7684\u7c7b\u578b\u5931\u8d25", e);
        }
    }

    public void updateCrd(ICrdDef crdVesion, String namespace, String name, Map<String, Object> updatedSpec) {
        try {
            CustomResourceDefinitionContext context = crdVesion.getCrd();
            GenericKubernetesResource cr = (GenericKubernetesResource)((Resource)((NonNamespaceOperation)this.client.genericKubernetesResources((ResourceDefinitionContext)context).inNamespace(namespace)).withName(name)).get();
            Map object = (Map)cr.getAdditionalProperties().get("spec");
            object.putAll(updatedSpec);
            ((Resource)this.client.genericKubernetesResources((ResourceDefinitionContext)context).resource((Object)cr)).update();
        }
        catch (Throwable e) {
            if (e.getMessage().contains("404 page not found")) {
                throw new RuntimeException("\u6ca1\u6709\u5e03\u7f72api:" + e.getMessage());
            }
            throw new RuntimeException("\u5e03\u7f72\u81ea\u5b9a\u4e49\u7684\u7c7b\u578b\u5931\u8d25", e);
        }
    }

    public GenericKubernetesResource createCusObject(ICrdDef crdVesion, String namespace, InputStream fileInputStream) {
        return this.createCusObject(crdVesion, null, namespace, fileInputStream);
    }

    private GenericKubernetesResource createCusObject(ICrdDef crdVesion, String namespace, GenericKubernetesResource sorceCR) {
        try {
            CustomResourceDefinitionContext context = crdVesion.getCrd();
            NonNamespaceOperation inNamespace = (NonNamespaceOperation)this.client.genericKubernetesResources((ResourceDefinitionContext)context).inNamespace(namespace);
            GenericKubernetesResource create = (GenericKubernetesResource)((Resource)inNamespace.resource((Object)sorceCR)).create();
            return create;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("404 page not found")) {
                throw new RuntimeException("\u6ca1\u6709\u5e03\u7f72api:" + e.getMessage());
            }
            if (e.getMessage().contains("already exists")) {
                throw new RuntimeException("\u5df2\u5b58\u5728\u6b64\u7c7b\u578b\u7684\u540c\u540d\u8d44\u6e90:" + e.getMessage());
            }
            throw new RuntimeException("\u5e03\u7f72\u81ea\u5b9a\u4e49\u7684\u7c7b\u578b\u5931\u8d25", e);
        }
    }

    public GenericKubernetesResource createCusObject(ICrdDef crdVesion, String namespace, String name, Map<String, String> annotations, Map<String, String> labels, Map<String, Object> spec) {
        GenericKubernetesResource rs = new GenericKubernetesResource();
        rs.setKind(crdVesion.getKind());
        rs.setApiVersion(crdVesion.getApiVersion(0));
        ObjectMeta objectMeta = new ObjectMeta();
        objectMeta.setName(name);
        objectMeta.setNamespace(namespace);
        if (MapUtils.isNotEmpty(annotations)) {
            objectMeta.setAnnotations(annotations);
        }
        if (MapUtils.isNotEmpty(labels)) {
            objectMeta.setLabels(labels);
        }
        rs.setMetadata(objectMeta);
        HashMap<String, Map<String, Object>> additionalProperties = new HashMap<String, Map<String, Object>>();
        additionalProperties.put("spec", spec);
        rs.setAdditionalProperties(additionalProperties);
        return this.createCusObject(crdVesion, namespace, rs);
    }

    public List<KubernetesResultCol> getCrdColDef(ICrdDef crdVesion) {
        CustomResourceDefinition crdDef = (CustomResourceDefinition)((Resource)this.client.apiextensions().v1().customResourceDefinitions().withName(crdVesion.getCrdName())).get();
        ArrayList<KubernetesResultCol> retlist = new ArrayList<KubernetesResultCol>();
        if (crdDef == null) {
            return retlist;
        }
        LinkedHashMap properties = (LinkedHashMap)((JSONSchemaProps)((CustomResourceDefinitionVersion)crdDef.getSpec().getVersions().get(0)).getSchema().getOpenAPIV3Schema().getProperties().get("spec")).getProperties();
        KubernetesResultCol nameColDef = new KubernetesResultCol("name");
        nameColDef.setJsonPath("/metadata/name");
        KubernetesResultCol namespaceColDef = new KubernetesResultCol("namespace");
        namespaceColDef.setJsonPath("/metadata/namespace");
        retlist.add(nameColDef);
        retlist.add(namespaceColDef);
        for (Map.Entry entry : properties.entrySet()) {
            KubernetesResultCol temp = new KubernetesResultCol((String)entry.getKey(), ((JSONSchemaProps)entry.getValue()).getType());
            temp.setJsonPath(String.format("/spec/%s", entry.getKey()));
            retlist.add(temp);
        }
        return retlist;
    }

    public boolean existCrd(ICrdDef crdVesion) {
        List<KubernetesResultCol> crdColDef = this.getCrdColDef(crdVesion);
        return CollectionUtils.isNotEmpty(crdColDef);
    }

    public void installCrd(InputStream is) {
        V1ApiextensionAPIGroupDSL v1 = this.client.apiextensions().v1();
        ((Resource)v1.customResourceDefinitions().load(is)).create();
    }

    public void installCrd(String relaPath, Class<?> classz) {
        this.installCrd(IOUtil.fileToInputStream((String)relaPath, classz));
    }

    public InputStream viewLog(Pod pod) {
        PodLogs logs = new PodLogs(this.apiClient);
        this.apiClient.setReadTimeout(300000);
        try {
            InputStream is = logs.streamNamespacedPodLog(pod.getMetadata().getNamespace(), pod.getMetadata().getName(), ((Container)pod.getSpec().getContainers().get(0)).getName(), null, Integer.valueOf(500), false);
            return is;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public InputStream viewLog(String namespace, String deploymentName) {
        Pod pod = this.getPodByDeployment(namespace, deploymentName, new String[0]);
        return this.viewLog(pod);
    }

    public Boolean copyFileToPod(String namespace, String deploymentName, String osFilepath, String podFilePath) {
        Pod pod = this.getPodByDeployment(namespace, deploymentName, new String[0]);
        Boolean upload = ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(pod.getMetadata().getNamespace())).withName(pod.getMetadata().getName())).file(podFilePath).upload(new File(osFilepath).toPath());
        return upload;
    }

    public Boolean copyFileToPod(String namespace, String deploymentName, InputStream inputStream, String podFilePath) {
        Pod pod = this.getPodByDeployment(namespace, deploymentName, new String[0]);
        Boolean upload = ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(pod.getMetadata().getNamespace())).withName(pod.getMetadata().getName())).file(podFilePath).upload(inputStream);
        return upload;
    }

    public InputStream copyFileFromPod(String namespace, String deploymentName, String podFilePath) {
        Pod pod = this.getPodByDeployment(namespace, deploymentName, new String[0]);
        InputStream inputStream = ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(pod.getMetadata().getNamespace())).withName(pod.getMetadata().getName())).file(podFilePath).read();
        return inputStream;
    }

    public Process execshell(String namespace, String podname, String ... cmdargs) {
        Validate.notBlank((CharSequence)podname, (String)"\u8282\u70b9\u540d\u5fc5\u586b", (Object[])new Object[0]);
        Validate.notEmpty((Object[])cmdargs, (String)"\u547d\u4ee4\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String[] args = null;
        args = cmdargs[0] != "sh" ? (String[])CollectionUtil.arrayMerge(String[].class, (Object[])new String[]{"sh", "-c"}, (Object[])cmdargs, (boolean)false) : cmdargs;
        Process proc = this.execPod(namespace, podname, args);
        return proc;
    }

    private Process execPod(String namespace, String podname, String[] args) {
        Process proc;
        Exec exec = new Exec(this.apiClient);
        boolean tty = System.console() != null;
        try {
            proc = exec.exec(StringUtil.hasNull((String[])new String[]{namespace, "default"}), podname, args, true, tty);
        }
        catch (ApiException e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u6267\u884cshell\u5931\u8d25\uff1a" + CollectionUtil.arrayJoin((Object[])args, (String)" "));
        }
        catch (IOException e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u6267\u884cshell\u5931\u8d25,\u7f51\u7edc\u6216io\u65b9\u9762\u95ee\u9898");
        }
        return proc;
    }

    public Process execFlinkSqlClient(String namespace, String podname, String shellcmd) {
        String[] paramsTrue = StringUtil.isNull((Object)shellcmd) ? new String[]{"sh", "-c", "/opt/flink/bin/sql-client.sh embedded"} : new String[]{"sh", "-c", shellcmd};
        return this.execshell(namespace, podname, paramsTrue);
    }

    public Process execFlinkSqlClientTams(String namespace, String podname, String params, String initFilePath) {
        String cmd = String.format("/opt/flink/bin/sql-client.sh embedded  -i   " + initFilePath + " -p %s", params);
        return this.execFlinkSqlClient(namespace, podname, cmd);
    }

    public Process execPod(String namespace, String podname) {
        String[] paramsTrue = new String[]{"sh", "-s", "/bin/bash"};
        return this.execPod(namespace, podname, paramsTrue);
    }

    public void execShellToSystemIo(String namespace, String podname, String ... cmdargs) {
        Process proc = this.execshell(namespace, podname, cmdargs);
        this.execShellToCallback(proc, (IProcess)StreamCopyBean.procToSystem((Process)proc), cmdargs);
    }

    public String execShellToResult(String namespace, String podname, boolean needError, String cmd) {
        Process proc = this.execshell(namespace, podname, cmd);
        try {
            String retstr = IOUtil.slurp((InputStream)proc.getInputStream());
            return retstr;
        }
        catch (IOException e) {
            log.error("\u6267\u884c\u547d\u4ee4\u5931\u8d25:" + cmd, (Throwable)e);
            return null;
        }
    }

    public String execShellToResult(String namespace, String podname, String cmd) {
        return this.execShellToResult(namespace, podname, false, cmd);
    }

    private String callRestServiceToResultForExec(Pod pod, Integer port, String namespace, String serviceName, String relaUrl, String modth, String ... params) {
        Pod podTrue = pod == null ? this.getPodByService(namespace, serviceName) : pod;
        String relaUrlTrue = StringUtil.packageUrlParams((String)relaUrl, (String[])params);
        String serviceUrl = pod == null ? "localhost" : String.format("%s.%s", serviceName, namespace);
        int portTrue = port == null ? 80 : port;
        String modthPathStr = "";
        if ("PATCH".equalsIgnoreCase(modth)) {
            modthPathStr = "--request PATCH";
        }
        String retstr = this.execShellToResult(podTrue.getMetadata().getNamespace(), podTrue.getMetadata().getName(), "curl  \"" + modthPathStr + IOUtil.mergeFolderAndFilePath((String)("http://" + serviceUrl + ":" + portTrue), (String[])new String[]{relaUrlTrue}) + "\"");
        return retstr;
    }

    public String callRestServiceToResultForExecGet(Pod pod, Integer port, String namespace, String serviceName, String relaUrl, String ... params) {
        return this.callRestServiceToResultForExec(pod, port, namespace, serviceName, relaUrl, "GET", params);
    }

    public String callRestServiceToResultForExecPatch(Pod pod, Integer port, String namespace, String serviceName, String relaUrl, String ... params) {
        return this.callRestServiceToResultForExec(pod, port, namespace, serviceName, relaUrl, "PATCH", params);
    }

    public void execShellToCallback(final Process proc, final IProcess callback, String ... cmdargs) {
        Thread in = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.doOutputStream(proc.getOutputStream());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        in.start();
        Thread out = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.doInputStream(proc.getInputStream());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        out.start();
        Thread error = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.doErrorStream(proc.getErrorStream());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        error.start();
        try {
            proc.waitFor();
            out.join();
            error.join();
        }
        catch (InterruptedException e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u542f\u52a8\u7ebf\u7a0b\u6709\u95ee\u9898");
        }
        proc.destroy();
    }

    public boolean deleteCusObject(ICrdDef crdVesion, String version, String namespace, String name) {
        try {
            CustomResourceDefinitionContext context = crdVesion.getCrd();
            boolean empty = ((Resource)((NonNamespaceOperation)this.client.genericKubernetesResources((ResourceDefinitionContext)context).inNamespace(namespace)).withName(name)).delete().isEmpty();
            return !empty;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() == 404) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_pagenotfound, "\u6ca1\u6709\u5e03\u7f72\u5e94\u7528:" + name + ": " + e.getMessage());
            }
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u5e03\u7f72\u81ea\u5b9a\u4e49\u7684\u7c7b\u578b\u5931\u8d25");
        }
        catch (Throwable e) {
            if (e.getMessage().contains("already exists")) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_exists, "\u5df2\u5b58\u5728\u6b64\u7c7b\u578b\u7684\u540c\u540d\u8d44\u6e90:" + e.getMessage());
            }
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u5e03\u7f72\u81ea\u5b9a\u4e49\u7684\u7c7b\u578b\u5931\u8d25");
        }
    }

    public boolean deleteCusObject(ICrdDef crdVesion, String namespace, String name) {
        return this.deleteCusObject(crdVesion, null, namespace, name);
    }

    public boolean deleteCusObjectByLabel(ICrdDef crdVesion, String namespace, String ... labels) {
        CustomResourceDefinitionContext context = crdVesion.getCrd();
        boolean empty = ((FilterWatchListDeletable)((NonNamespaceOperation)this.client.genericKubernetesResources((ResourceDefinitionContext)context).inNamespace(namespace)).withLabels(CollectionUtil.newMapStr((String[])labels))).delete().isEmpty();
        return !empty;
    }

    private <T extends HasMetadata, L extends KubernetesResourceList<HasMetadata>, R extends Resource<T>> List<GenericKubernetesResource> selCusObject(ICrdDef crdVesion, String version, String namespace, String name) {
        CustomResourceDefinitionContext context = crdVesion.getCrd();
        List<Object> retlist = new ArrayList<GenericKubernetesResource>();
        if (StringUtil.isNotNull((Object)namespace) && StringUtil.isNotNull((Object)name)) {
            GenericKubernetesResource resource = (GenericKubernetesResource)((Resource)((NonNamespaceOperation)this.client.genericKubernetesResources((ResourceDefinitionContext)context).inNamespace(namespace)).withName(name)).get();
            if (resource != null) {
                retlist.add(resource);
            }
        } else if (StringUtil.isNotNull((Object)namespace) && StringUtil.isNull((Object)name)) {
            NonNamespaceOperation inNamespace = (NonNamespaceOperation)this.client.genericKubernetesResources((ResourceDefinitionContext)context).inNamespace(namespace);
            retlist = this.queryAll((FilterWatchListDeletable<T, L, R>)inNamespace);
        } else if (StringUtil.isNull((Object)namespace) && StringUtil.isNotNull((Object)name)) {
            GenericKubernetesResource resource = (GenericKubernetesResource)((Resource)this.client.genericKubernetesResources((ResourceDefinitionContext)context).withName(name)).get();
            if (resource != null) {
                retlist.add(resource);
            }
        } else if (StringUtil.isNull((Object)namespace) && StringUtil.isNull((Object)name)) {
            retlist = ((GenericKubernetesResourceList)this.client.genericKubernetesResources((ResourceDefinitionContext)context).list()).getItems();
        }
        return retlist;
    }

    public List<GenericKubernetesResource> selCusObject(ICrdDef crdVesion, String namespace, String name) {
        return this.selCusObject(crdVesion, crdVesion.getVersions()[0], namespace, name);
    }

    public List<GenericKubernetesResource> selCusObjectByLabel(ICrdDef crdVesion, String namespace, String ... labels) {
        FilterWatchListDeletable withLabels = (FilterWatchListDeletable)((NonNamespaceOperation)this.client.genericKubernetesResources((ResourceDefinitionContext)crdVesion.getCrd()).inNamespace(namespace)).withLabels(CollectionUtil.newMapStr((String[])labels));
        List<GenericKubernetesResource> queryAll = this.queryAll(withLabels);
        return queryAll;
    }

    public Service getService(String serviceName) {
        return this.getService(null, serviceName);
    }

    public ReplicationController getRc(String namespace, String rcName) {
        ReplicationController gotRc = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.getUseNamespaceName(namespace))).withName(rcName)).get();
        return gotRc;
    }

    public ReplicationController getRc(String rcName) {
        return this.getRc(null, rcName);
    }

    public Service getSvc(String namespace, String rcName) {
        Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).withName(rcName)).get();
        return service;
    }

    public boolean delService(String namespace, String serviceName) {
        boolean optResult = !((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).withName(serviceName)).delete().isEmpty();
        return optResult;
    }

    public boolean delService(String serviceName) {
        return this.delService(null, serviceName);
    }

    public Result createNamespace(String namespace, String group) {
        try {
            HashMap<String, String> labels = new HashMap<String, String>();
            if (StringUtil.isNotNull((Object)group)) {
                labels.put("tams/catalog", group);
            }
            Namespace namespaceRet = (Namespace)((Resource)this.client.namespaces().resource((Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(namespace)).withLabels(labels)).endMetadata()).build())).create();
            if (StringUtil.isNotNull((Object)group)) {
                this.groups.add(group);
            }
            return Result.getSuc().setRetObjs((Object[])new Namespace[]{namespaceRet});
        }
        catch (Exception e) {
            return Result.getError((String)e.getMessage());
        }
    }

    public boolean exitNamespace(String namespace, String group) {
        NonNamespaceOperation namespaces = this.client.namespaces();
        if (StringUtil.isNotNull((Object)group)) {
            List<String> allNamespace = this.getAllNamespace(group);
            return allNamespace.contains(namespace);
        }
        Namespace namespaceRes = (Namespace)((Resource)namespaces.withName(namespace)).get();
        return namespaceRes != null;
    }

    public void delNamespace(String namespace, String group) {
        if (!this.exitNamespace(namespace, group)) {
            return;
        }
        ((Resource)this.client.namespaces().withName(namespace)).delete().isEmpty();
    }

    public boolean delPodByName(String namespace, String podName) {
        return !((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.getUseNamespaceName(namespace))).withName(podName)).delete().isEmpty();
    }

    public boolean delPodByName(String podName) {
        return this.delPodByName(null, podName);
    }

    public boolean delPodByLabel(String namespace, String key, String value) {
        return !((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(this.getUseNamespaceName(namespace))).withLabel(key, value)).delete().isEmpty();
    }

    public boolean delPodByLabel(String key, String value) {
        return this.delPodByLabel(null, key, value);
    }

    public Pod getPodByDeployment(String namespace, String deploymentName, String ... status) {
        List<Pod> items = this.getPodListByDeployment(namespace, deploymentName, status);
        return CollectionUtils.isEmpty(items) ? null : items.get(NumberUtil.random((int)items.size()));
    }

    public Pod getPodByName(String namespace, String podName) {
        FilterNested withLabels = ((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withNewFilter();
        withLabels.withField("metadata.name", podName);
        FilterWatchListDeletable endFilter = (FilterWatchListDeletable)withLabels.endFilter();
        PodList list = (PodList)endFilter.list();
        return CollectionUtils.isEmpty((Collection)list.getItems()) ? null : (Pod)list.getItems().get(0);
    }

    public void movePod(String namespace, String podName) {
        Pod podByName = this.getPodByName(namespace, podName);
        if (podByName == null) {
            return;
        }
        ((Deletable)((GracePeriodConfigurable)this.client.resource((HasMetadata)podByName).withPropagationPolicy(DeletionPropagation.FOREGROUND)).withGracePeriod(0L)).delete();
        List volumes = podByName.getSpec().getVolumes();
        for (Volume volume : volumes) {
            PersistentVolumeClaimVolumeSource persistentVolumeClaim = volume.getPersistentVolumeClaim();
            if (persistentVolumeClaim == null) continue;
            String claimName = persistentVolumeClaim.getClaimName();
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{claimName})) continue;
            ((Deletable)((GracePeriodConfigurable)((Resource)this.client.persistentVolumeClaims().withName(claimName)).withPropagationPolicy(DeletionPropagation.FOREGROUND)).withGracePeriod(0L)).delete();
        }
    }

    public QuotaBean queryResourcequota(String namespace, String quotasName) {
        ResourceQuota resourceQuota = (ResourceQuota)((Resource)((NonNamespaceOperation)this.client.resourceQuotas().inNamespace(namespace)).withName(quotasName)).get();
        if (resourceQuota == null) {
            return null;
        }
        QuotaBean ret = new QuotaBean();
        Map hard = resourceQuota.getStatus().getHard();
        Map used = resourceQuota.getStatus().getUsed();
        ret.setCpu(KubeClientTams.cpuInfo((Quantity)hard.get("cpu")));
        ret.setCpuUsed(KubeClientTams.cpuInfo((Quantity)used.get("cpu")));
        ret.setCpuFree(ret.getCpu() - ret.getCpuUsed());
        ret.setMemory(KubeClientTams.memInfo((Quantity)hard.get("memory")));
        ret.setMemoryUsed(KubeClientTams.memInfo((Quantity)used.get("memory")));
        ret.setMemoryFree(ret.getMemory() - ret.getMemoryUsed());
        ret.setPods(KubeClientTams.numInfo((Quantity)hard.get("pods")));
        ret.setPodsUsed(KubeClientTams.numInfo((Quantity)used.get("pods")));
        ret.setPodsFree(ret.getPods() - ret.getPodsUsed());
        ret.setPvcs(KubeClientTams.numInfo((Quantity)hard.get("persistentvolumeclaims")));
        ret.setPvcsUsed(KubeClientTams.numInfo((Quantity)used.get("persistentvolumeclaims")));
        ret.setPvcsFree(ret.getPvcs() - ret.getPvcsUsed());
        ret.setStorage(KubeClientTams.memInfo((Quantity)hard.get("requests.storage")) / 1024);
        ret.setStorageUsed(KubeClientTams.memInfo((Quantity)used.get("requests.storage")) / 1024);
        ret.setStorageFree(ret.getStorage() - ret.getStorageUsed());
        return ret;
    }

    public List<Pod> getPodListByDeployment(String namespace, String deploymentName, String ... status) {
        String[] stringArray;
        Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).get();
        if (deployment == null) {
            return null;
        }
        Map matchLabels = deployment.getSpec().getTemplate().getMetadata().getLabels();
        if (ArrayUtils.isEmpty((Object[])status)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "Running";
        } else {
            stringArray = status;
        }
        final String[] podAry = stringArray;
        List items = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabels(matchLabels)).list()).getItems();
        CollectionUtils.filter((Collection)items, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Pod pod = (Pod)object;
                return ArrayUtils.contains((Object[])podAry, (Object)pod.getStatus().getPhase());
            }
        });
        return items;
    }

    public Pod getPodByJob(String namespace, String jobName, String ... status) {
        List<Pod> items = this.getPodListByJob(namespace, jobName, status);
        return CollectionUtils.isEmpty(items) ? null : items.get(NumberUtil.random((int)items.size()));
    }

    public List<Pod> getPodListByJob(String namespace, String jobName, String ... status) {
        String[] stringArray;
        Job job = (Job)((ScalableResource)((NonNamespaceOperation)this.client.batch().v1().jobs().inNamespace(namespace)).withName(jobName)).get();
        if (job == null) {
            return null;
        }
        Map matchLabels = job.getSpec().getTemplate().getMetadata().getLabels();
        if (ArrayUtils.isEmpty((Object[])status)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "Running";
        } else {
            stringArray = status;
        }
        final String[] podAry = stringArray;
        List items = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabels(matchLabels)).list()).getItems();
        CollectionUtils.filter((Collection)items, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Pod pod = (Pod)object;
                return ArrayUtils.contains((Object[])podAry, (Object)pod.getStatus().getPhase());
            }
        });
        return items;
    }

    public Pod getPodByService(String namespace, String serviceName) {
        List<Pod> items = this.getPodListByService(namespace, serviceName);
        return CollectionUtils.isEmpty(items) ? null : items.get(NumberUtil.random((int)items.size()));
    }

    public List<Pod> getPodListByService(String namespace, String serviceName) {
        Map matchLabels = ((Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceName)).get()).getSpec().getSelector();
        List items = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabels(matchLabels)).list()).getItems();
        CollectionUtils.filter((Collection)items, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Pod pod = (Pod)object;
                return "Running".equals(pod.getStatus().getPhase());
            }
        });
        return items;
    }

    public List<Pod> getPodListByIds(String namespace, Map<String, String> filtermap, String lable, String ... ids) {
        FilterNested withLabels = ((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withNewFilter();
        if (MapUtils.isNotEmpty(filtermap)) {
            withLabels = (FilterNested)withLabels.withLabels(filtermap);
            if (ArrayUtils.isNotEmpty((Object[])ids)) {
                withLabels = (FilterNested)withLabels.withLabelIn(lable, ids);
            }
        } else if (ArrayUtils.isNotEmpty((Object[])ids)) {
            withLabels = (FilterNested)withLabels.withLabelIn(lable, ids);
        }
        FilterWatchListDeletable endFilter = (FilterWatchListDeletable)withLabels.endFilter();
        PodList list = (PodList)endFilter.list();
        return list.getItems();
    }

    public List<Job> getJobListByIds(String namespace, Map<String, String> filtermap, String lable, String ... ids) {
        NonNamespaceOperation withLabels = (NonNamespaceOperation)this.client.batch().v1().jobs().inNamespace(namespace);
        FilterWatchListDeletable queryListWatch = null;
        if (MapUtils.isNotEmpty(filtermap)) {
            queryListWatch = (FilterWatchListDeletable)withLabels.withLabels(filtermap);
            if (ArrayUtils.isNotEmpty((Object[])ids)) {
                queryListWatch = (FilterWatchListDeletable)queryListWatch.withLabelIn(lable, ids);
            }
        } else if (ArrayUtils.isNotEmpty((Object[])ids)) {
            queryListWatch = (FilterWatchListDeletable)withLabels.withLabelIn(lable, ids);
        }
        return queryListWatch == null ? new ArrayList() : ((JobList)queryListWatch.list()).getItems();
    }

    public List<Pair<String, PodPhase>> queryPodStatus(String namespace, Map<String, String> filtermap, String lable, String[] lableNames) {
        List<Pod> pods = this.getPodListByIds(namespace, filtermap, lable, lableNames);
        ArrayList<Pair<String, PodPhase>> retlist = new ArrayList<Pair<String, PodPhase>>();
        for (String lableName : lableNames) {
            PodPhase elePhase = PodPhase.noExit;
            for (Pod pod : pods) {
                Object[] groups;
                Object[] subgroups;
                String podname = pod.getMetadata().getName();
                if (!podname.startsWith(lableName + "-") || !CollectionUtil.arrayJoin((Object[])(subgroups = (String[])ArrayUtils.subarray((Object[])(groups = podname.split("-")), (int)0, (int)(groups.length - 2))), (String)"-").equals(lableName)) continue;
                elePhase = PodPhase.valueOf(pod.getStatus().getPhase());
                break;
            }
            retlist.add((Pair<String, PodPhase>)Pair.of((Object)lableName, (Object)((Object)elePhase)));
        }
        return retlist;
    }

    public List<Pair<String, PodPhase>> queryJobStatus(String namespace, Map<String, String> filtermap, String lable, String[] lableNames) {
        List<Job> jobList = this.getJobListByIds(namespace, filtermap, lable, lableNames);
        ArrayList<Pair<String, PodPhase>> retlist = new ArrayList<Pair<String, PodPhase>>();
        for (String lableName : lableNames) {
            PodPhase elePhase = PodPhase.noExit;
            for (Job job : jobList) {
                if (!job.getMetadata().getName().equals(lableName)) continue;
                if (job.getStatus().getActive() != null && job.getStatus().getActive() == 1) {
                    elePhase = PodPhase.Running;
                    break;
                }
                if (job.getStatus().getSucceeded() != null && job.getStatus().getSucceeded() == 1) {
                    elePhase = PodPhase.Succeeded;
                    break;
                }
                elePhase = PodPhase.Unknown;
                break;
            }
            retlist.add((Pair<String, PodPhase>)Pair.of((Object)lableName, (Object)((Object)elePhase)));
        }
        return retlist;
    }

    public List<String> selPodNameByLabel(String namespace, Map<String, String> labelmap) {
        List<Pod> podList = this.getPodListByIds(namespace, labelmap, null, new String[0]);
        ArrayList<String> retlist = new ArrayList<String>();
        for (Pod pod : podList) {
            retlist.add(pod.getMetadata().getName());
        }
        return retlist;
    }

    public List<String> selServiceByLabel(String namespace, Map<String, String> labelmap) {
        NonNamespaceOperation serviceSel = (NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace));
        FilterWatchListDeletable withLabel = null;
        for (String key : labelmap.keySet()) {
            if (withLabel == null) {
                withLabel = (FilterWatchListDeletable)serviceSel.withLabel(key, labelmap.get(key));
                continue;
            }
            withLabel = (FilterWatchListDeletable)withLabel.withLabel(key, labelmap.get(key));
        }
        ServiceList list = (ServiceList)withLabel.list();
        ArrayList<String> retlist = new ArrayList<String>();
        for (Service service : list.getItems()) {
            retlist.add(service.getMetadata().getName());
        }
        return retlist;
    }

    public void createRc(String namespace, String filePath) throws ProjectException {
        FileInputStream inputstream;
        try {
            inputstream = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new ProjectException((IExcept)ExceptAll.Project_default, "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        this.createRc(namespace, inputstream);
    }

    public void createRc(String namespace, FileInputStream fileInputStream) throws ProjectException {
        ObjectMapper objmap = new ObjectMapper();
        ObjectNode jsonObject = YamlAssist.readYaml((FileInputStream)fileInputStream);
        ReplicationController rc = new ReplicationController();
        if (jsonObject.has("metadata")) {
            ObjectNode metadataJson = (ObjectNode)jsonObject.get("metadata");
            if (!metadataJson.has("name")) {
                throw new ProjectException((IExcept)ExceptAll.param_error, "metadata\u9700\u8981\u6709name\u5143\u7d20");
            }
            ObjectMeta metadata = new ObjectMeta();
            metadata.setName(metadataJson.get("name").asText());
            if (metadataJson.has("labels")) {
                ObjectNode labels = (ObjectNode)metadataJson.get("labels");
                HashMap<String, String> lables = new HashMap<String, String>();
                Iterator iterator = labels.fieldNames();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    lables.put(key, labels.get(key).asText());
                }
                metadata.setLabels(lables);
            }
            rc.setMetadata(metadata);
        }
        ObjectNode specJson = (ObjectNode)jsonObject.get("spec");
        ReplicationControllerSpec spec = rc.getSpec();
        if (specJson.has("replicas")) {
            spec.setReplicas(Integer.valueOf(specJson.get("replicas").asInt()));
        }
        if (specJson.has("selector")) {
            Map selector;
            try {
                selector = (Map)objmap.readValue(objmap.writeValueAsString((Object)specJson.get("selector")), Map.class);
            }
            catch (Exception e) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error, (Throwable)e);
            }
            spec.setSelector(selector);
        }
        PodTemplateSpec newTemplate = spec.getTemplate();
        ObjectNode templateJson = (ObjectNode)specJson.get("template");
        if (templateJson.has("metadata")) {
            Map labels;
            ObjectMeta withNewMetadata = newTemplate.getMetadata();
            ObjectNode jsonObject2 = (ObjectNode)templateJson.get("metadata").get("labels");
            try {
                labels = (Map)objmap.readValue(objmap.writeValueAsString((Object)jsonObject2), Map.class);
            }
            catch (Exception e) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error, (Throwable)e);
            }
            withNewMetadata.setLabels(labels);
        }
        ObjectNode innerSpecJson = (ObjectNode)templateJson.get("spec");
        ArrayNode containersJson = (ArrayNode)innerSpecJson.get("containers");
        for (int i = 0; i < containersJson.size(); ++i) {
            ObjectNode containerJson = (ObjectNode)containersJson.get(i);
            Container addNewContainer = new Container();
            addNewContainer.setName(containerJson.get("name").asText());
            addNewContainer.setImage(containerJson.get("image").asText());
            ArrayNode portAry = (ArrayNode)containerJson.get("ports");
            ArrayList<ContainerPort> ports = new ArrayList<ContainerPort>();
            for (int j = 0; j < portAry.size(); ++j) {
                ContainerPort temport = new ContainerPort();
                temport.setContainerPort(Integer.valueOf(portAry.get(i).get("containerPort").asInt()));
                ports.add(temport);
            }
            addNewContainer.setPorts(ports);
        }
        rc = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.getUseNamespaceName(namespace))).resource((Object)rc)).create();
    }

    public void createSvc(String namespace, FileInputStream fileInputStream) throws ProjectException {
        ObjectNode jsonObject = YamlAssist.readYaml((FileInputStream)fileInputStream);
        Service createNew = new ServiceBuilder().build();
        ObjectNode metadata = (ObjectNode)jsonObject.get("metadata");
        ObjectMeta meta = new ObjectMeta();
        meta.setName(metadata.get("name").asText());
        createNew.setMetadata(meta);
        ObjectNode specjson = (ObjectNode)jsonObject.get("spec");
        ServiceSpec withNewSpec = createNew.getSpec();
        if (specjson.has("type")) {
            withNewSpec.setType(specjson.get("type").asText());
        }
        ObjectMapper objmap = new ObjectMapper();
        if (specjson.has("selector")) {
            Map seleMap;
            try {
                seleMap = (Map)objmap.readValue(objmap.writeValueAsString((Object)specjson.get("selector")), Map.class);
            }
            catch (Exception e) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_error, (Throwable)e);
            }
            withNewSpec.setSelector(seleMap);
        }
        if (specjson.has("ports")) {
            ArrayNode array = (ArrayNode)specjson.get("ports");
            ArrayList<ServicePort> ports = new ArrayList<ServicePort>();
            for (int i = 0; i < array.size(); ++i) {
                ObjectNode tempobj = (ObjectNode)array.get(i);
                ServicePort temp = new ServicePort();
                if (tempobj.has("name")) {
                    temp.setName(tempobj.get("name").asText());
                }
                if (tempobj.has("nodePort")) {
                    temp.setNodePort(Integer.valueOf(tempobj.get("nodePort").asInt()));
                }
                if (tempobj.has("port")) {
                    temp.setPort(Integer.valueOf(tempobj.get("port").asInt()));
                }
                if (tempobj.has("protocol")) {
                    temp.setProtocol(tempobj.get("protocol").asText());
                }
                if (tempobj.has("targetPort")) {
                    IntOrString input = new IntOrString((Object)tempobj.get("targetPort").asInt());
                    temp.setTargetPort(input);
                }
                ports.add(temp);
            }
            withNewSpec.setPorts(ports);
        }
        Service service = ((ServiceBuilder)new ServiceBuilder().withSpec(withNewSpec)).build();
        service = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).resource((Object)service)).create();
    }

    public void createSvc(String namespace, String filePath) throws ProjectException {
        FileInputStream inputstream;
        try {
            inputstream = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new ProjectException((IExcept)ExceptAll.Project_default, "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        this.createSvc(namespace, inputstream);
    }

    public void createResourcequota(String namespace, int minCpu, int minMemory, int maxCpu, int maxMemory, int pods) {
        HashMap<String, Quantity> parma = new HashMap<String, Quantity>();
        parma.put("pods", new Quantity(String.valueOf(pods)));
        parma.put("requests.cpu", new Quantity(String.valueOf(minCpu)));
        parma.put("requests.memory", new Quantity(String.valueOf(minMemory)));
        parma.put("limits.cpu", new Quantity(String.valueOf(maxCpu)));
        parma.put("limits.memory", new Quantity(String.valueOf(maxMemory)));
        ResourceQuota quota = ((ResourceQuotaBuilder)((ResourceQuotaFluent.SpecNested)((ResourceQuotaBuilder)((ResourceQuotaFluent.MetadataNested)new ResourceQuotaBuilder().withNewMetadata().withName(this.getUseNamespaceName(namespace))).endMetadata()).withNewSpec().addToHard(parma)).endSpec()).build();
        ((Resource)((NonNamespaceOperation)this.client.resourceQuotas().inNamespace(this.getUseNamespaceName(namespace))).resource((Object)quota)).create();
    }

    public void delResourcequota(String namespace) {
        ((NonNamespaceOperation)this.client.resourceQuotas().inNamespace(this.getUseNamespaceName(namespace))).delete();
    }

    public boolean delRc(String namespace, String rcName) {
        return !((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.getUseNamespaceName(namespace))).withName(rcName)).delete().isEmpty();
    }

    public boolean delSvc(String namespace, String svcName) {
        return !((FilterWatchListDeletable)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).withField("metadata.name", svcName)).delete().isEmpty();
    }

    public void updateRcImage(String namespace, String rcName, int containerIndex, String imageValue) {
        ReplicationControllerSpec spec = ((ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.getUseNamespaceName(namespace))).withName(rcName)).edit(new Visitor[0])).getSpec();
        Container container = (Container)spec.getTemplate().getSpec().getContainers().get(containerIndex);
        container.setImage(imageValue);
        RollableScalableResource withName = (RollableScalableResource)((NonNamespaceOperation)this.getClient().replicationControllers().inNamespace(this.getUseNamespaceName(namespace))).withName(rcName);
        withName.updateImage(imageValue);
        withName.rolling();
    }

    public void scaleDeployment(String namespace, String deploymentName, int numberOfReplicas) throws ApiException {
        AppsV1Api appsV1Api = new AppsV1Api(this.apiClient);
        AppsV1Api.APIlistNamespacedDeploymentRequest listNamespacedDeployment = appsV1Api.listNamespacedDeployment(this.getUseNamespaceName(namespace));
        List appsV1DeploymentItems = listNamespacedDeployment.execute().getItems();
        Optional<V1Deployment> findedDeployment = appsV1DeploymentItems.stream().filter(deployment -> deployment.getMetadata().getName().equals(deploymentName)).findFirst();
        findedDeployment.ifPresent(deploy -> {
            try {
                V1DeploymentSpec newSpec = deploy.getSpec().replicas(Integer.valueOf(numberOfReplicas));
                V1Deployment newDeploy = deploy.spec(newSpec);
                AppsV1Api.APIreplaceNamespacedDeploymentRequest replaceNamespacedDeployment = appsV1Api.replaceNamespacedDeployment(deploymentName, this.getUseNamespaceName(namespace), newDeploy);
                replaceNamespacedDeployment.execute();
            }
            catch (ApiException ex) {
                log.warn("Scale the pod failed for Deployment:" + deploymentName, (Throwable)ex);
            }
        });
    }

    public Result updateImageRolling(String namespace, String rcName, String imageValue) {
        try {
            RollableScalableResource withName = (RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(namespace)).withName(rcName);
            withName.updateImage(imageValue);
            withName.rolling();
            return Result.getSuc();
        }
        catch (Exception e) {
            return Result.getError((String)e.getMessage());
        }
    }

    public Result createOrUpdateImageRolling(String namespace, String imageValue, String rcPath) {
        ObjectNode json = YamlAssist.readYaml((String)rcPath);
        String rcName = json.get("metadata").get("name").asText();
        ReplicationController queryRc = this.getRc(namespace, rcName);
        if (queryRc == null) {
            try {
                this.createRc(namespace, rcPath);
                return Result.getSuc();
            }
            catch (ProjectException e) {
                return Result.getError((String)e.getMessage());
            }
        }
        return this.updateImageRolling(namespace, rcName, imageValue);
    }

    public Deployment getDeploymentByName(String namespace, String name) {
        Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(StringUtil.hasNull((String[])new String[]{namespace, "default"}))).withName(name)).get();
        return deployment;
    }

    public Deployment getDeploymentByLabelOne(String namespace, String label, String value) {
        DeploymentList list = this.getDeploymentByLabel(namespace, label, value);
        if (list == null || list.getItems().size() != 1) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_notfit, "Deployment\u9884\u671f\u53ea\u6709\u4e00\u4e2a\uff0c\u73b0\u5df2\u67e5\u51fa:" + list.getItems().size());
        }
        return (Deployment)list.getItems().get(0);
    }

    public DeploymentList getDeploymentByLabel(String namespace, String label, String value) {
        DeploymentList deployments = (DeploymentList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(StringUtil.hasNull((String[])new String[]{namespace, "default"}))).withLabel(label, value)).list();
        return deployments;
    }

    public DeploymentList getDeploymentByLabel(String namespace, String label) {
        DeploymentList deployments = (DeploymentList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(StringUtil.hasNull((String[])new String[]{namespace, "default"}))).withLabel(label)).list();
        return deployments;
    }

    public V1Deployment installDeploymentByTemp(String namespace, String context, Map<String, Object> params) {
        try {
            String result = FreemarkUtil.getInst().doProcessByTemp(context, params);
            V1Deployment yamlSvc = (V1Deployment)Yaml.load((String)result);
            AppsV1Api appsV1Api = new AppsV1Api(this.apiClient);
            V1Deployment v1Deployment = appsV1Api.createNamespacedDeployment(namespace, yamlSvc).execute();
            return v1Deployment;
        }
        catch (ApiException e) {
            if ("Conflict".equals(e.getMessage())) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_deploy_conflict);
            }
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, e.getMessage());
        }
        catch (Exception e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_deploy_excetion, "\u90e8\u7f72task\u5931\u8d25", (Throwable)e);
        }
    }

    public void installResource(ResourcesType resouceType, String namespace, Map<String, Object> crd) {
        if (resouceType == ResourcesType.UNKNOWN || resouceType == ResourcesType.CRD) {
            return;
        }
        Object po = null;
        switch (resouceType) {
            case DEPLOYMENT: {
                po = new Deployment();
                po = resouceType.setColValue((HasMetadata)po, crd, po.getClass(), true);
                ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).resource(po)).create();
                break;
            }
            case SERVICE: {
                po = new Service();
                po = resouceType.setColValue((HasMetadata)po, crd, po.getClass(), true);
                ((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).resource((Object)((Service)po))).create();
                break;
            }
        }
    }

    public void updateResource(ResourcesType resouceType, String namespace, String name, Map<String, Object> crd) {
        if (resouceType == ResourcesType.UNKNOWN || resouceType == ResourcesType.CRD) {
            return;
        }
        switch (resouceType) {
            case DEPLOYMENT: {
                Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(name)).get();
                deployment = (Deployment)resouceType.setColValue((HasMetadata)deployment, crd, deployment.getClass(), false);
                ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).resource((Object)deployment)).update();
                break;
            }
            case SERVICE: {
                Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(name)).get();
                service = (Service)resouceType.setColValue((HasMetadata)service, crd, service.getClass(), false);
                ((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).resource((Object)service)).update();
                break;
            }
        }
    }

    public void deleteResource(ResourcesType resouceType, String namespace, String name) {
        if (resouceType == ResourcesType.UNKNOWN || resouceType == ResourcesType.CRD) {
            return;
        }
        switch (resouceType) {
            case DEPLOYMENT: {
                ((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(name)).delete();
                break;
            }
            case SERVICE: {
                ((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(name)).delete();
                break;
            }
            case POD: {
                ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withName(name)).delete();
                break;
            }
        }
    }

    public OwnerReference getControllerOf(HasMetadata md) {
        List ownerReferences = md.getMetadata().getOwnerReferences();
        for (OwnerReference ownerReference : ownerReferences) {
            if (!ownerReference.getController().equals(Boolean.TRUE)) continue;
            return ownerReference;
        }
        return null;
    }

    public ServiceAccount findCreateSa(String namespace, String saName) {
        ServiceAccount serviceAccount = (ServiceAccount)((ServiceAccountResource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(namespace)).withName(saName)).get();
        if (serviceAccount == null) {
            ServiceAccount sa = new ServiceAccount();
            ObjectMeta objectMeta = new ObjectMeta();
            objectMeta.setName(saName);
            sa.setMetadata(objectMeta);
            serviceAccount = (ServiceAccount)((ServiceAccountResource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(namespace)).resource((Object)sa)).create();
        }
        return serviceAccount;
    }

    public Result bindAdminRoleForSa(String namespace, String bindname, String ... sas) {
        RbacAuthorizationV1Api rolebind = new RbacAuthorizationV1Api(this.apiClient);
        V1RoleBinding body = new V1RoleBinding();
        body.setKind("RoleBinding");
        body.setApiVersion("rbac.authorization.k8s.io/v1");
        V1ObjectMeta metadata = new V1ObjectMeta();
        metadata.setName(bindname);
        metadata.setNamespace(namespace);
        body.setMetadata(metadata);
        V1RoleRef roleRef = new V1RoleRef();
        roleRef.setApiGroup("rbac.authorization.k8s.io");
        roleRef.setKind("ClusterRole");
        roleRef.setName("admin");
        body.setRoleRef(roleRef);
        ArrayList<V1Subject> subjects = new ArrayList<V1Subject>();
        for (String sa : sas) {
            V1Subject temp = new V1Subject();
            temp.setKind("ServiceAccount");
            temp.setName(sa);
            temp.setNamespace(namespace);
            subjects.add(temp);
        }
        body.setSubjects(subjects);
        try {
            rolebind.createNamespacedRoleBinding(namespace, body).execute();
            return Result.getSuc();
        }
        catch (ApiException e) {
            if (e.getCode() == 409) {
                return Result.getSuc();
            }
            log.error("\u521b\u5efa\u89d2\u8272\u7ed1\u5b9a\u5173\u7cfb\u5931\u8d25:" + e.getResponseBody(), (Throwable)e);
            return Result.getError((String)("\u521b\u5efa\u89d2\u8272\u7ed1\u5b9a\u5173\u7cfb\u5931\u8d25" + e.getMessage()));
        }
    }

    public Result bindClusterAdminRoleForSa(String namespace, String bindname, String ... sas) {
        RbacAuthorizationV1Api rolebind = new RbacAuthorizationV1Api(this.apiClient);
        V1ClusterRoleBinding body = new V1ClusterRoleBinding();
        body.setKind("ClusterRoleBinding");
        body.setApiVersion("rbac.authorization.k8s.io/v1");
        V1ObjectMeta metadata = new V1ObjectMeta();
        metadata.setName(bindname);
        metadata.setNamespace(namespace);
        body.setMetadata(metadata);
        V1RoleRef roleRef = new V1RoleRef();
        roleRef.setApiGroup("rbac.authorization.k8s.io");
        roleRef.setKind("ClusterRole");
        roleRef.setName("cluster-admin");
        body.setRoleRef(roleRef);
        ArrayList<V1Subject> subjects = new ArrayList<V1Subject>();
        for (String sa : sas) {
            V1Subject temp = new V1Subject();
            temp.setKind("ServiceAccount");
            temp.setName(sa);
            temp.setNamespace(namespace);
            subjects.add(temp);
        }
        body.setSubjects(subjects);
        try {
            rolebind.createClusterRoleBinding(body).execute();
            return Result.getSuc();
        }
        catch (ApiException e) {
            if (e.getCode() == 409) {
                return Result.getSuc();
            }
            log.error("\u521b\u5efa\u89d2\u8272\u7ed1\u5b9a\u5173\u7cfb\u5931\u8d25:" + e.getResponseBody(), (Throwable)e);
            return Result.getError((String)("\u521b\u5efa\u89d2\u8272\u7ed1\u5b9a\u5173\u7cfb\u5931\u8d25" + e.getMessage()));
        }
    }

    public Secret getSecretAccount(String namespace, final String accountName) {
        SecretList list = (SecretList)((NonNamespaceOperation)this.client.secrets().inNamespace(namespace)).list();
        List items = list.getItems();
        CollectionUtils.filter((Collection)items, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Secret temp = (Secret)object;
                return MapUtils.isNotEmpty((Map)temp.getMetadata().getAnnotations()) && accountName.equals(temp.getMetadata().getAnnotations().get("kubernetes.io/service-account.name"));
            }
        });
        Secret retObj = null;
        retObj = CollectionUtils.isEmpty((Collection)items) ? this.createAccountSecret(namespace, accountName) : (Secret)items.get(0);
        return retObj;
    }

    public Result proKubeConfig(String clusterName, String namespace, String accountName, boolean isCluster) {
        Result result;
        ServiceAccount account = this.findCreateSa(namespace, accountName);
        String bindName = isCluster ? String.format("%s-%s-clusteradmin-binder", account.getMetadata().getName(), namespace) : String.format("%s-%s-admin-binder", account.getMetadata().getName(), namespace);
        Result result2 = result = isCluster ? this.bindClusterAdminRoleForSa(namespace, bindName, account.getMetadata().getName()) : this.bindAdminRoleForSa(namespace, bindName, account.getMetadata().getName());
        if (!result.isSuc()) {
            return result;
        }
        Secret accountSecret = this.getSecretAccount(namespace, account.getMetadata().getName());
        String proKubeConfig = this.proKubeConfig(clusterName, accountSecret);
        Result suc = Result.getSuc();
        suc.setRetObjs((Object[])new String[]{proKubeConfig});
        return suc;
    }

    public String proKubeConfig(String clusterName, Secret secret) {
        try {
            HashMap params = new HashMap();
            params.put("cluster_certificate_authority_data", secret.getData().get("ca.crt"));
            params.put("cluster_server", this.client.getMasterUrl());
            params.put("cluster_name", clusterName);
            params.put("user_name", secret.getMetadata().getAnnotations().get("kubernetes.io/service-account.name"));
            params.put("namespace", secret.getMetadata().getNamespace());
            params.put("context_name", clusterName);
            params.put("user_token", new String(PwdUtil.fromBase64((String)((String)secret.getData().get("token")))));
            String slurp = IOUtil.slurp((InputStream)IOUtil.fileToInputStream((String)"/template/configSingle.yaml", KubeClientTams.class));
            String doProcessByTemp = FreemarkUtil.getInst().doProcessByTemp(slurp, params);
            return doProcessByTemp;
        }
        catch (IOException e) {
            log.error("\u751f\u6210config\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public VersionInfo getKubernetesVersion() {
        VersionInfo version = this.client.getKubernetesVersion();
        return version;
    }

    public V1Ingress createV1Ingress(String namespace, String ingressName, Map<String, String> annotations, String path, String servicename, Integer servicePort, String host, V1OwnerReference ref, V1IngressTLS tls) {
        V1Ingress ingress = new V1Ingress();
        V1ObjectMeta v1ObjectMeta = new V1ObjectMeta();
        v1ObjectMeta.setName(ingressName);
        v1ObjectMeta.setAnnotations(annotations);
        if (ref != null) {
            v1ObjectMeta.addOwnerReferencesItem(ref);
        }
        ingress.metadata(v1ObjectMeta);
        V1IngressSpec spec = new V1IngressSpec();
        V1IngressRule rulesItem = new V1IngressRule();
        if (StringUtil.isNotNull((Object)host)) {
            rulesItem.setHost(host);
        }
        V1HTTPIngressRuleValue http = new V1HTTPIngressRuleValue();
        V1HTTPIngressPath ingressPath = new V1HTTPIngressPath();
        ingressPath.path(path);
        ingressPath.pathType("ImplementationSpecific");
        V1IngressBackend backend = new V1IngressBackend();
        V1IngressServiceBackend service = new V1IngressServiceBackend();
        service.setName(servicename);
        V1ServiceBackendPort v1ServiceBackendPort = new V1ServiceBackendPort();
        v1ServiceBackendPort.setNumber(servicePort);
        service.setPort(v1ServiceBackendPort);
        backend.setService(service);
        ingressPath.setBackend(backend);
        if (tls != null) {
            spec.addTlsItem(tls);
        }
        http.addPathsItem(ingressPath);
        rulesItem.setHttp(http);
        spec.addRulesItem(rulesItem);
        ingress.setSpec(spec);
        NetworkingV1Api api = new NetworkingV1Api(this.apiClient);
        V1Ingress v1Ingress = null;
        try {
            NetworkingV1Api.APIcreateNamespacedIngressRequest namespacedIngress = api.createNamespacedIngress(namespace, ingress);
            v1Ingress = namespacedIngress.execute();
        }
        catch (ApiException e) {
            log.error("\u521b\u5efaingress\u5f02\u5e38:" + e.getResponseBody(), (Throwable)e);
        }
        catch (Exception E) {
            log.error("\u521b\u5efaingress\u7cfb\u7edf\u5f02\u5e38:", (Throwable)E);
        }
        return v1Ingress;
    }

    private static int numInfo(Quantity quantity) {
        int amount = Integer.parseInt(quantity.getAmount());
        if ("k".equalsIgnoreCase(quantity.getFormat())) {
            amount *= 1000;
        }
        return amount;
    }

    public static int numInfo(String quantityStr) {
        int indexOf = quantityStr.indexOf("k");
        Quantity params = indexOf < 0 ? new Quantity(quantityStr) : new Quantity(quantityStr.substring(0, indexOf), "k");
        return KubeClientTams.memInfo(params);
    }

    private static int cpuInfo(Quantity quantity) {
        int amount = Integer.parseInt(quantity.getAmount());
        if (!"m".equalsIgnoreCase(quantity.getFormat())) {
            amount *= 1000;
        }
        return amount;
    }

    public static int cpuInfo(String quantityStr) {
        int indexOf = quantityStr.indexOf("m");
        Quantity params = indexOf < 0 ? new Quantity(quantityStr) : new Quantity(quantityStr.substring(0, indexOf), "m");
        return KubeClientTams.memInfo(params);
    }

    private static int memInfo(Quantity quantity) {
        int amount = Integer.parseInt(quantity.getAmount());
        if ("Gi".equalsIgnoreCase(quantity.getFormat())) {
            amount *= 1024;
        } else if ("Ti".equalsIgnoreCase(quantity.getFormat())) {
            amount = amount * 1024 * 1024;
        }
        return amount;
    }

    public static int memInfo(String quantityStr) {
        return KubeClientTams.memInfo(new Quantity(quantityStr.substring(0, quantityStr.length() - 2), quantityStr.substring(quantityStr.length() - 2)));
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<HasMetadata>, R extends Resource<T>> List<T> queryResByPage(ResourcesType resourcesType, SqlParserAssit sqlParserTams, int pageSize, int pageNo) {
        long fetchNum = 10L;
        Validate.isTrue(((long)pageSize >= fetchNum ? 1 : 0) != 0, (String)"\u9875\u9762\u5927\u5c0f\u5fc5\u987b\u5927\u4e8e10", (Object[])new Object[0]);
        MixedOperation operater = null;
        TbSimple tbSimple = sqlParserTams.findTbInfos().get(0);
        switch (resourcesType) {
            case POD: {
                operater = this.client.pods();
                break;
            }
            case SERVICE: {
                operater = this.client.services();
                break;
            }
            case DEPLOYMENT: {
                operater = this.client.apps().deployments();
                break;
            }
            case CRD: {
                ICrdDef crdVesion = cusCache.get(tbSimple.getTb());
                operater = this.client.genericKubernetesResources((ResourceDefinitionContext)crdVesion.getCrd());
                break;
            }
        }
        if (operater == null) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u4e0d\u652f\u6301\u7684\u7c7b\u578b" + resourcesType.name());
        }
        NonNamespaceOperation inNamespace = (NonNamespaceOperation)operater.inNamespace(StringUtil.isNull((Object)tbSimple.getDb()) ? this.getDefaultNamespace() : tbSimple.getDb());
        ArrayList<HasMetadata> retlist = new ArrayList<HasMetadata>();
        List<SqlWherePo> queryWhere = sqlParserTams.queryWhere();
        if (CollectionUtils.isNotEmpty(queryWhere)) {
            List<SqlWherePo> queryWheres = sqlParserTams.queryWhere();
            SqlWherePo nameEqual = null;
            SqlWherePo label = null;
            for (SqlWherePo sqlWherePo : queryWheres) {
                if ("name".equalsIgnoreCase(sqlWherePo.getColName()) && "=".equals(sqlWherePo.getOperator())) {
                    nameEqual = sqlWherePo;
                    break;
                }
                if (!"label".equalsIgnoreCase(sqlWherePo.getColName()) || !"=".equals(sqlWherePo.getOperator())) continue;
                label = sqlWherePo;
                break;
            }
            if (nameEqual != null) {
                HasMetadata t = (HasMetadata)((Resource)inNamespace.withName(nameEqual.getValue())).get();
                retlist.add(t);
            } else if (label != null) {
                String[] lableArys;
                HashMap<String, String> filters = new HashMap<String, String>();
                for (String lableAry : lableArys = label.getValue().split(",")) {
                    String[] lableVals = lableAry.split(":");
                    filters.put(StringUtil.trimSpace((String)lableVals[0]), StringUtil.trimSpace((String)lableVals[1]));
                }
                FilterWatchListDeletable withLabels = (FilterWatchListDeletable)inNamespace.withLabels(filters);
                this.doQueryByPage(pageSize, pageNo, fetchNum, withLabels, retlist);
            } else {
                this.doQueryByPage(pageSize, pageNo, fetchNum, (FilterWatchListDeletable<T, L, R>)inNamespace, (List<T>)retlist);
            }
        } else {
            this.doQueryByPage(pageSize, pageNo, fetchNum, (FilterWatchListDeletable<T, L, R>)inNamespace, (List<T>)retlist);
        }
        return retlist;
    }

    private <T extends HasMetadata, L extends KubernetesResourceList<HasMetadata>, R extends Resource<T>> void doQueryByPage(int pageSize, int pageNo, long fetchNum, FilterWatchListDeletable<T, L, R> inNamespace, List<T> retlist) {
        String _continue = null;
        ListOptions listOptions = ((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(Long.valueOf(fetchNum))).withContinue(_continue)).build();
        long hasQueryNum = 0L;
        do {
            KubernetesResourceList list = (KubernetesResourceList)inNamespace.list(listOptions);
            _continue = list.getMetadata().getContinue();
            if (hasQueryNum >= (long)(pageNo * pageSize)) {
                retlist.addAll(list.getItems());
            }
            listOptions.setContinue(_continue);
        } while (StringUtil.isNotNull((Object)_continue) || (hasQueryNum += fetchNum) >= (long)((pageNo + 1) * pageSize));
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<HasMetadata>, R extends Resource<T>> List<T> queryAll(FilterWatchListDeletable<T, L, R> filter) {
        ArrayList retlist = new ArrayList();
        this.doQueryByPage(Integer.MAX_VALUE, 0, 0L, filter, retlist);
        return retlist;
    }

    public synchronized void close() {
        if (!this.state) {
            this.client.close();
            this.state = true;
        }
    }

    public List<String[]> statementsByPage(ResourcesType resourcesType, SqlParserAssit sqlParserTams, int curPage, long maxSize) {
        List queryResByPages = this.queryResByPage(resourcesType, sqlParserTams, (int)maxSize, curPage);
        ArrayList<String[]> retlist = new ArrayList<String[]>();
        final List<KubernetesResultCol> sortCols = resourcesType.getSortCol(resourcesType == ResourcesType.CRD ? this.getCrdColDef(sqlParserTams.findTbInfos().get(0).getTb()) : resourcesType.getJdbcColDef(), sqlParserTams.findColNames().toArray(new String[sqlParserTams.findColNames().size()]));
        for (HasMetadata queryResByPage : queryResByPages) {
            String[] ele = resourcesType.getColValue(queryResByPage, sortCols);
            retlist.add(ele);
        }
        final List<SqlWherePo> queryWhere = sqlParserTams.queryWhere();
        if (CollectionUtils.isNotEmpty(queryWhere)) {
            CollectionUtils.filter(queryWhere, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    SqlWherePo temp = (SqlWherePo)object;
                    return !("name".equalsIgnoreCase(temp.getColName()) && "=".equals(temp.getOperator()) || "label".equalsIgnoreCase(temp.getColName()) && "=".equals(temp.getOperator()));
                }
            });
            if (CollectionUtils.isNotEmpty(queryWhere)) {
                CollectionUtils.filter(retlist, (Predicate)new Predicate(){

                    public boolean evaluate(Object object) {
                        String[] ele = (String[])object;
                        boolean need = true;
                        for (SqlWherePo sqlWherePo : queryWhere) {
                            int indexOf = sortCols.indexOf(new KubernetesResultCol(sqlWherePo.getColName()));
                            if ("=".equals(sqlWherePo.getOperator())) {
                                need &= sqlWherePo.getValue().equalsIgnoreCase(ele[indexOf]);
                                continue;
                            }
                            if (!"like".equalsIgnoreCase(sqlWherePo.getOperator())) continue;
                            Pattern javaPattern = Pattern.compile(sqlWherePo.getValue().replace("%", ".*").replace("_", ".?"));
                            need &= javaPattern.matcher(ele[indexOf]).matches();
                        }
                        return need;
                    }
                });
            }
        }
        return retlist;
    }

    public boolean isClosed() {
        return this.state;
    }

    public void setDefaultNamespace(String namespace) {
        this.defaultNamespace = namespace;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    static {
        File tokenFile = new File("/var/run/secrets/kubernetes.io/serviceaccount/token");
        if (tokenFile.exists()) {
            Conf.overProp((String[])new String[]{"common.kubernetes.incluster", "yes"});
        } else {
            Conf.overProp((String[])new String[]{"common.kubernetes.incluster", "no"});
        }
        log.info("====================\u662f\u5426\u5728\u5bb9\u5668\u4e2d\u8fd0\u884c:{}", (Object)Conf.get((String)"common.kubernetes.incluster"));
        Map crdconf = Conf.getPre((String)"common.kubernetes.crd.", (boolean)true);
        HashSet<String> confKeys = new HashSet<String>();
        for (String key : crdconf.keySet()) {
            String[] keyAry = key.split("\\.");
            switch (keyAry[0]) {
                case "enum": {
                    try {
                        ?[] enumConstants;
                        for (Object enumConstant : enumConstants = Class.forName((String)crdconf.get(key)).getEnumConstants()) {
                            ICrdDef temp = (ICrdDef)enumConstant;
                            cusCache.put(temp.getShortNames()[0], temp);
                        }
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        log.error("\u4e0d\u80fd\u5904\u7406\u7c7b\uff1a" + (String)crdconf.get(key), (Throwable)e);
                        break;
                    }
                }
                case "class": {
                    ICrdDef value = (ICrdDef)ReflectAssist.newInst((String)((String)crdconf.get(key)));
                    cusCache.put(value.getShortNames()[0], value);
                    break;
                }
                case "conf": {
                    confKeys.add(keyAry[1]);
                    break;
                }
            }
            for (String confKey : confKeys) {
                CrdDefConfig value = new CrdDefConfig(confKey);
                cusCache.put(confKey, value);
            }
        }
        confTemp = "apiVersion: v1\r\nclusters:\r\n- cluster:\r\n    server: %s\r\n  name: kubernetes\r\ncontexts:\r\n- context:\r\n    cluster: kubernetes\r\n    user: kubernetes-admin\r\n    namespace: ummc-ummc\r\n  name: kubernetes-admin@kubernetes\r\ncurrent-context: kubernetes-admin@kubernetes\r\nkind: Config\r\npreferences: {}\r\nusers:\r\n- name: kubernetes-admin\r\n  user:\r\n    client-certificate-data: \r\n    client-key-data:";
    }
}

