/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.apiserver;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.KubeConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.thread.threadlocal.ObjectCreator;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class ApiClientCreator
implements ObjectCreator<ApiClient> {
    private final String config;
    private final String context;

    public ApiClientCreator(String config, String context) {
        this.config = config;
        this.context = context;
    }

    public ApiClientCreator(String config) {
        this(config, null);
    }

    public ApiClientCreator() {
        this(null, null);
    }

    public ApiClient createObject() {
        ApiClient apiClient;
        try {
            if (StringUtil.isNotNull((Object)this.config)) {
                KubeConfig config = ApiClientCreator.userKubeConfig(this.config, this.context);
                apiClient = Config.fromConfig((KubeConfig)config);
            } else {
                apiClient = YesOrNo.find((String)Conf.get((String)"common.kubernetes.incluster")) == YesOrNo.yes ? Config.fromCluster() : Config.defaultClient();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("create apiClient error", e);
        }
        return apiClient;
    }

    public static KubeConfig userKubeConfig(String yamlStr, String context) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        Object config = yaml.load(yamlStr);
        Map configMap = (Map)config;
        String currentContext = StringUtil.hasNull((String[])new String[]{context, String.valueOf(configMap.get("current-context"))});
        ArrayList contexts = (ArrayList)configMap.get("contexts");
        ArrayList clusters = (ArrayList)configMap.get("clusters");
        ArrayList users = (ArrayList)configMap.get("users");
        Object preferences = configMap.get("preferences");
        KubeConfig kubeConfig = new KubeConfig(contexts, clusters, users);
        kubeConfig.setContext(currentContext);
        kubeConfig.setPreferences(preferences);
        return kubeConfig;
    }
}

