package net.wicp.tams.common.kubernetes.helm.po;

import java.util.ArrayList;
import java.util.List;

import lombok.Builder;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.StringUtil;

@Data
@Builder
@Slf4j
public class ChartInst {
	private String name;
	private String version;
	private String appVersion;
	private String description;

	public static ChartInst[] splitList(String value) {
		String[] rows = value.split("\n");
		List<ChartInst> retlist = new ArrayList<ChartInst>();
		if (rows.length > 1) {// 第一行是：NAME CHART VERSION APP VERSION DESCRIPTION
			for (int i = 1; i < rows.length; i++) {
				if (rows[i].startsWith("WARNING: ")) {// WARNING: Kubernetes configuration file is world-readable. This
														// is insecure. Location: ***
					continue;// 警告信息不理
				}
				String[] row = rows[i].split("\t");
				if (row.length < 4) {
					log.error("此结果不能被解析：" + rows[i]);
					continue;
				} else {
					log.info("返回值:" + rows[i]);
				}
				ChartInst inst = ChartInst.builder().name(StringUtil.trimSpace(row[0]))
						.version(StringUtil.trimSpace(row[1])).appVersion(StringUtil.trimSpace(row[2]))
						.description(StringUtil.trimSpace(row[3])).build();
				retlist.add(inst);
			}
		}
		return retlist.toArray(new ChartInst[retlist.size()]);
	}
}
