/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.kubernetes.duckula;

import java.io.File;

import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;

import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.constant.PathType;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;

/***
 * 目录管理
 * 
 * @author andy.zhou
 * 
 */
public enum UploadSubDir implements IEnumCombobox {

	k8sconfig("k8sconfig文件", "/k8sconfig"),

	helmchart("helmchart包", "/helmchart"),

	helmvalue("helm的value值", "/helmvalue");

	private final String desc;

	private final String path;

	private final String[] subDirs;

	private static String uploadPath = "abs:/data/duckula-data/devops";

	public String getOsPathDir(String fileName) {
		return PathType.getPath(IOUtil.mergeFolderAndFilePath(uploadPath, this.getPath(), fileName));
	}

	private UploadSubDir(String desc, String path, String[] subDirs) {
		this.desc = desc;
		this.path = path;
		this.subDirs = subDirs;
	}

	private UploadSubDir(String desc, String path) {
		this(desc, path, null);
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public String getPath() {
		return path;
	}

	public String[] getSubDirs() {
		return subDirs;
	}

	/**
	 * 初始化目录
	 */
	public static void initDir() {
		for (UploadSubDir uploadSubDir : UploadSubDir.values()) {
			String osPath = PathType.getPath(IOUtil.mergeFolderAndFilePath(uploadPath, uploadSubDir.getPath()));
			File tempFile = new File(osPath);
			try {
				if (!tempFile.exists()) {// 初始化目录
					FileUtils.forceMkdir(tempFile);
				}
				if (ArrayUtils.isNotEmpty(uploadSubDir.getSubDirs())) {// 初始化子目录
					for (String subdir : uploadSubDir.getSubDirs()) {
						File subDirFile = new File(IOUtil.mergeFolderAndFilePath(osPath, subdir));
						if (!subDirFile.exists()) {
							FileUtils.forceMkdir(subDirFile);
						}
					}
				}
			} catch (Exception e) {
			}
		}
	}

	/***
	 * 清理目录，注意k8sconfig不能清理
	 */
	public static void clearDir() {
		for (UploadSubDir uploadSubDir : UploadSubDir.values()) {
			if (uploadSubDir != k8sconfig) {
				String osPath = PathType.getPath(IOUtil.mergeFolderAndFilePath(uploadPath, uploadSubDir.getPath()));
				File tempFile = new File(osPath);
				try {
					if (tempFile.exists()) {// 初始化目录
						FileUtils.forceDelete(tempFile);
					}
				} catch (Exception e) {
				}
			}
		}
	}
}
