package net.wicp.tams.common.kubernetes.driver;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.Lex;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlDelete;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlUpdate;
import org.apache.calcite.sql.ddl.SqlCreateSchema;
import org.apache.calcite.sql.ddl.SqlDropSchema;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.ddl.SqlDdlParserImpl;
import org.apache.commons.lang3.tuple.Triple;

import io.fabric8.kubernetes.api.model.Namespace;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.beans.SqlWherePo;
import net.wicp.tams.common.beans.TbSimple;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.kubernetes.apiserver.KubeClientTams;
import net.wicp.tams.common.kubernetes.apiserver.crd.ICrdDef;
import net.wicp.tams.common.kubernetes.beans.KubernetesResultCol;
import net.wicp.tams.common.kubernetes.constant.ResourcesType;

public class SqlParserAssit {
	private final String sql;
	private final SqlNode sqlNode;
	// 虚拟的catalog存储
	private String defaultCatalog;
	private final String defaultDb;
	private final List<TbSimple> usedTbs = new ArrayList<>();

	public SqlParserAssit(String defaultCatalog, String defaultDb, String sql) {
		this.sql = StringUtil.trimSpace(sql);
		this.defaultCatalog = StringUtil.hasNull(defaultCatalog, Conf.get("common.kubernetes.jdbc.catalogDefault"));
		this.defaultDb = defaultDb;
		SqlParser.Config mysqlConfig = SqlParser.config().withCaseSensitive(false).withQuotedCasing(Casing.TO_UPPER)
				.withUnquotedCasing(Casing.TO_LOWER).withQuoting(Quoting.BACK_TICK).withLex(Lex.MYSQL)
				.withParserFactory(SqlDdlParserImpl.FACTORY);
		SqlParser parser = SqlParser.create(this.sql, mysqlConfig);
		try {
			this.sqlNode = parser.parseQuery();
		} catch (SqlParseException e) {
			throw new ProjectExceptionRuntime(ExceptAll.param_error, "sql不能解析", e);
		}
	}

//	public SqlParserAssit(String defaultDb, String sql) {
//		this(null, defaultDb, sql);
//	}
//
//	public SqlParserAssit(String sql) {
//		this(null, null, sql);
//	}

	// 内部临时用，不需要做较验
	private SqlParserAssit(String defaultCatalog, String defaultDb, SqlNode sqlNode) {
		this.sql = sqlNode.toString();
		this.defaultCatalog = defaultCatalog;
		this.defaultDb = defaultDb;
		this.sqlNode = sqlNode;
	}

	public boolean isQuery() {
		// private static final List<String> QUERY_COMMANDS_START =
		// Arrays.asList("SELECT", "SHOW", "DESCRIBE", "DESC",
//	"EXPLAIN");
		return this.sqlNode instanceof SqlSelect;
	}

	// 暂时只支持简单的where条件
	public List<SqlWherePo> queryWhere() {
		List<SqlWherePo> retlist = new ArrayList<SqlWherePo>();
		if (this.sqlNode instanceof SqlSelect) {
			SqlSelect sqlSelect = (SqlSelect) sqlNode;
			SqlNode where = sqlSelect.getWhere();
			queryInner(where, retlist);
		}
		return retlist;
	}

	private void queryInner(SqlNode oriNode, List<SqlWherePo> retlist) {
		if (oriNode instanceof SqlBasicCall) {
			SqlBasicCall parseNode = (SqlBasicCall) oriNode;
			SqlOperator operator = parseNode.getOperator();
			List<SqlNode> operandList = parseNode.getOperandList();
			if (operandList.get(0) instanceof SqlBasicCall && operandList.get(1) instanceof SqlBasicCall) {// operator是and
																											// // 或 or
				queryInner(operandList.get(0), retlist);
				queryInner(operandList.get(1), retlist);
			} else {
				SqlWherePo temp = new SqlWherePo();
				if (operandList.get(0) instanceof SqlIdentifier) {
					SqlIdentifier sqlIdentifier = (SqlIdentifier) operandList.get(0);
					temp.setColName(sqlIdentifier.getSimple());
				} else if (operandList.get(0) instanceof SqlCharStringLiteral) {
					SqlCharStringLiteral sqlCharStringLiteral = (SqlCharStringLiteral) operandList.get(0);
					Object valueObj = sqlCharStringLiteral.getValue();
					temp.setColName(String.valueOf(valueObj).replace("'", ""));
				}
				temp.setOperator(operator.getName());
				if (operandList.get(1) instanceof SqlCharStringLiteral) {
					SqlCharStringLiteral sqlCharStringLiteral = (SqlCharStringLiteral) operandList.get(1);
					Object valueObj = sqlCharStringLiteral.getValue();
					temp.setValue(String.valueOf(valueObj).replace("'", ""));
				} else if (operandList.get(1) instanceof SqlNumericLiteral) {
					SqlNumericLiteral sqlCharStringLiteral = (SqlNumericLiteral) operandList.get(1);
					Object valueObj = sqlCharStringLiteral.getValue();
					temp.setValue(String.valueOf(valueObj));
				}
				retlist.add(temp);
			}
		}
	}

	// 操作DDL语法
	public void doDdl(KubeClientTams clientTams) throws SQLException {
		if (this.sqlNode instanceof SqlCreateSchema) {
			SqlCreateSchema rootNode = (SqlCreateSchema) this.sqlNode;
			TbSimple catalogDb = getCatalogDb(rootNode.getOperandList());
			if (rootNode.ifNotExists) {
				Namespace namespace = clientTams.getNamespace(catalogDb.getDb(), null);// 名称空间不能加限定catalogDb.getCatalog()
				if (namespace != null) {// 已存在就不需要创建了。
					return;
				}
			}
			Result namespace = clientTams.createNamespace(catalogDb.getDb(), catalogDb.getCatalog());
			if (!namespace.isSuc()) {
				throw new SQLException(namespace.getMessage());
			}
		} else if (this.sqlNode instanceof SqlDropSchema) {
			SqlDropSchema rootNode = (SqlDropSchema) this.sqlNode;
			TbSimple catalogDb = getCatalogDb(rootNode.getOperandList());
			if (rootNode.ifExists) {
				Namespace namespace = clientTams.getNamespace(catalogDb.getDb(), null);// 名称空间不能加限定catalogDb.getCatalog()
				if (namespace == null) {// 已存在就不需要创建了。
					return;
				}
			}
			clientTams.delNamespace(catalogDb.getDb(), catalogDb.getCatalog());
		} else if (this.sqlNode instanceof SqlInsert) {
			SqlInsert sqlInsert = (SqlInsert) this.sqlNode;
			TbSimple dbTb = getDbTb((SqlIdentifier) sqlInsert.getTargetTable(), null);
			ResourcesType resourcesType = ResourcesType.find(dbTb.getTb());
			List<KubernetesResultCol> crdColDef = resourcesType == ResourcesType.CRD
					? clientTams.getCrdColDef(dbTb.getTb())
					: resourcesType.getJdbcColDef();
			SqlNodeList targetColumnList = sqlInsert.getTargetColumnList();
			SqlBasicCall source = (SqlBasicCall) sqlInsert.getSource();
			List<Map<String, Object>> crds = new ArrayList<Map<String, Object>>();
			for (SqlNode sqlNode : source.getOperandList()) {
				SqlBasicCall valele = (SqlBasicCall) sqlNode;
				Map<String, Object> spec = new HashMap<String, Object>();
				int i = 0;
				for (SqlNode sqlNode2 : valele.getOperandList()) {
					Object targetVal = null;
					if (sqlNode2 instanceof SqlCharStringLiteral) {
						targetVal = String.valueOf(((SqlCharStringLiteral) sqlNode2).getValue()).replace("'", "");
					} else if (sqlNode2 instanceof SqlNumericLiteral) {
						targetVal = ((SqlNumericLiteral) sqlNode2).getValue();
					}
					String nameSql = ((SqlIdentifier) targetColumnList.get(i++)).getSimple();
					int indexOf = crdColDef.indexOf(new KubernetesResultCol(nameSql));
					if(indexOf<0) {
						throw new SQLException("表:"+dbTb.getTb()+"没有相关字段" + nameSql);
					}
					String name = ((KubernetesResultCol) crdColDef.get(indexOf)).getName();
					spec.put(name, targetVal);
				}
				crds.add(spec);
			}

			ICrdDef iCrdDef = KubeClientTams.cusCache.get(dbTb.getTb());
			try {
				for (Map<String, Object> crd : crds) {
					if (resourcesType == ResourcesType.CRD) {
						if (!crd.containsKey("name")) {
							throw new SQLException("新增记录需要传入name");
						}
						crd.remove("namespac");
						String name = String.valueOf(crd.get("name"));
						crd.remove("name");
						clientTams.createCusObject(iCrdDef, dbTb.getDb(), name, null,null, crd);
					} else {
						clientTams.installResource(resourcesType, dbTb.getDb(), crd);
					}
				}
			} catch (Exception e) {
				throw new SQLException("新增记录失败" + e.getMessage());
			}

		} else if (this.sqlNode instanceof SqlUpdate) {
			SqlUpdate sqlUpdate = (SqlUpdate) this.sqlNode;
			SqlNode condition = sqlUpdate.getCondition();
			TbSimple dbTb = getDbTb((SqlIdentifier) sqlUpdate.getTargetTable(), null);
			ResourcesType resourcesType = ResourcesType.find(dbTb.getTb());
			List<KubernetesResultCol> crdColDef = resourcesType == ResourcesType.CRD
					? clientTams.getCrdColDef(dbTb.getTb())
					: resourcesType.getJdbcColDef();

			List<SqlWherePo> retlist = new ArrayList<SqlWherePo>();
			this.queryInner(condition, retlist);
			// update暂时只能更新一条
			if (retlist.size() != 1 || !"name".equalsIgnoreCase(retlist.get(0).getColName())) {
				throw new SQLException("update暂只支持name的更新条件" + this.sql);
			}
			SqlNodeList targetColumnList = sqlUpdate.getTargetColumnList();
			SqlNodeList sourceExpressionList = sqlUpdate.getSourceExpressionList();
			Map<String, Object> updatedSpec = new HashMap<String, Object>();
			for (int i = 0; i < targetColumnList.size(); i++) {
				SqlIdentifier sqlNode2 = (SqlIdentifier) targetColumnList.get(i);
				int indexOf = crdColDef.indexOf(new KubernetesResultCol(sqlNode2.getSimple()));
				if(indexOf<0) {
					throw new SQLException("表:"+dbTb.getTb()+"没有相关字段" + sqlNode2.getSimple());
				}
				String name = ((KubernetesResultCol) crdColDef.get(indexOf)).getName();
				SqlNode sqlNode3 = sourceExpressionList.get(i);
				Object targetVal = null;
				if (sqlNode3 instanceof SqlCharStringLiteral) {
					targetVal = String.valueOf(((SqlCharStringLiteral) sqlNode3).getValue()).replace("'", "");
				} else if (sqlNode3 instanceof SqlNumericLiteral) {
					targetVal = ((SqlNumericLiteral) sqlNode3).getValue();
				}
				updatedSpec.put(name, targetVal);
			}		
			try {
				if (resourcesType == ResourcesType.CRD) {
					// 去掉元数据
					updatedSpec.remove("name");
					updatedSpec.remove("namespac");
					ICrdDef iCrdDef = KubeClientTams.cusCache.get(dbTb.getTb());
					clientTams.updateCrd(iCrdDef, dbTb.getDb(), retlist.get(0).getValue(), updatedSpec);
				} else {
					clientTams.updateResource(resourcesType, dbTb.getDb(),retlist.get(0).getValue(), updatedSpec);
				}
			} catch (Exception e) {
				throw new SQLException("修改记录失败" + e.getMessage());
			}
		} else if (this.sqlNode instanceof SqlDelete) {
			SqlDelete sqlDel = (SqlDelete) this.sqlNode;
			SqlNode condition = sqlDel.getCondition();
			TbSimple dbTb = getDbTb((SqlIdentifier) sqlDel.getTargetTable(), null);
			ResourcesType resourcesType = ResourcesType.find(dbTb.getTb());
			List<SqlWherePo> retlist = new ArrayList<SqlWherePo>();
			this.queryInner(condition, retlist);
			// update暂时只能删除一条
			if (retlist.size() != 1 || !"name".equalsIgnoreCase(retlist.get(0).getColName())) {
				throw new SQLException("update暂只支持name的更新条件" + this.sql);
			}
			if (resourcesType == ResourcesType.CRD) {
				ICrdDef iCrdDef = KubeClientTams.cusCache.get(dbTb.getTb());
				clientTams.deleteCusObject(iCrdDef, dbTb.getDb(), retlist.get(0).getValue());
			} else {
				clientTams.deleteResource(resourcesType, dbTb.getDb(), retlist.get(0).getValue());
			}

		} else {
			throw new SQLException("暂不支持此命令" + this.sql);
		}
	}

	// L:原别名，M：原字段名 R：新字段名
	public List<Triple<String, String, String>> findColNamesDetail() {
		List<Triple<String, String, String>> retlist = new ArrayList<Triple<String, String, String>>();
		SqlNode parseNode = this.sqlNode;
		if (this.sqlNode instanceof SqlBasicCall) {// UNION ALL语句支持
			parseNode = ((SqlBasicCall) this.sqlNode).getOperandList().get(0);
		}
		if (parseNode instanceof SqlSelect) {
			SqlNodeList collist = ((SqlSelect) parseNode).getSelectList();
			for (SqlNode col : collist) {
				String dbtbstr = null;
				String newColName = null;
				if (col instanceof SqlBasicCall) {
					List<SqlNode> operandList = ((SqlBasicCall) col).getOperandList();
					SqlNode sqlNode2 = operandList.get(0);
					if (sqlNode2 instanceof SqlBasicCall) {
						List<SqlNode> operandList2 = ((SqlBasicCall) sqlNode2).getOperandList();
						// TODO [`IF`(`ptc`.`Name` = u&'\9884\6536\6b3e\4f7f\7528', `pd`.`Amount`, 0)]
						// 没法处理
						dbtbstr = operandList2.get(0).toString();
					} else {
						dbtbstr = sqlNode2.toString();
					}
					if (operandList.size() > 1) {
						SqlNode sqlNode3 = operandList.get(1);
						newColName = sqlNode3.toString();
					}
				} else {
					dbtbstr = col.toString();
				}
				String[] colname = dbtbstr.split("\\.");
				retlist.add(Triple.of(colname.length == 1 ? null : colname[0],
						colname.length == 1 ? colname[0] : colname[1], newColName));
			}
		}
		return retlist;
	}

	public List<String> findColNames() {
		List<Triple<String, String, String>> colNamesDetail = this.findColNamesDetail();
		List<String> retlist = colNamesDetail.stream()
				.map((e) -> StringUtil.isNull(e.getRight()) ? e.getMiddle() : e.getRight())
				.collect(Collectors.toList());
		return retlist;
	}

	/**
	 * 得到SQL的DBTB
	 * 
	 * @return
	 */
	public List<TbSimple> findTbInfos() {
		if (this.usedTbs.isEmpty()) {
			synchronized (SqlParserAssit.class) {
				if (this.usedTbs.isEmpty()) {
					callSqlBasicCall(this.sqlNode, this.usedTbs);
				}
			}
		}
		return this.usedTbs;
	}

	public SqlNode getSqlNode() {
		return sqlNode;
	}

	// 递归取表名
	private void callSqlBasicCall(SqlNode parseNode, List<TbSimple> retobj) {
		if (parseNode instanceof SqlBasicCall) {
			List<SqlNode> sqlnodes = ((SqlBasicCall) parseNode).getOperandList();
			for (SqlNode sqlnode : sqlnodes) {
				callSqlBasicCall(sqlnode, retobj);
			}
		} else if (parseNode instanceof SqlSelect) {
			SqlSelect sqlSelect = (SqlSelect) parseNode;
			SqlNode from = sqlSelect.getFrom();
			if (from instanceof SqlBasicCall) {
				packageBasicCall(retobj, from);
			} else if (from instanceof SqlJoin) {
				findDbTbBySqlJoin(retobj, (SqlJoin) from, true);
				findDbTbBySqlJoin(retobj, (SqlJoin) from, false);
			} else {
				SqlIdentifier sqlIdentifier = (SqlIdentifier) from;
				TbSimple dbTb = getDbTb(sqlIdentifier, null);
				retobj.add(dbTb);
			}
		} else if (parseNode instanceof SqlOrderBy) {
			SqlOrderBy orderby = (SqlOrderBy) parseNode;
			SqlNode sqlNode2 = orderby.getOperandList().get(0);// 它应该是SqlSelect对象
			callSqlBasicCall(sqlNode2, retobj);
		} else if (parseNode instanceof SqlDrop) {
			SqlDrop drop = (SqlDrop) parseNode;
			List<SqlNode> operandList = drop.getOperandList();
			TbSimple dbTb = getDbTb(operandList);
			retobj.add(dbTb);
		} else if (parseNode instanceof SqlInsert) {
			SqlInsert sqlInsert = (SqlInsert) this.sqlNode;
			TbSimple dbTb = getDbTb((SqlIdentifier) sqlInsert.getTargetTable(), null);
			retobj.add(dbTb);
		} else if (parseNode instanceof SqlUpdate) {
			SqlUpdate sqlUpdate = (SqlUpdate) this.sqlNode;
			TbSimple dbTb = getDbTb((SqlIdentifier) sqlUpdate.getTargetTable(), null);
			retobj.add(dbTb);
		}else if (parseNode instanceof SqlDelete) {
			SqlDelete sqlDelete = (SqlDelete) this.sqlNode;
			TbSimple dbTb = getDbTb((SqlIdentifier) sqlDelete.getTargetTable(), null);
			retobj.add(dbTb);
		}
	}

	private void findDbTbBySqlJoin(List<TbSimple> retobj, SqlJoin fromjoin, boolean isLeft) {
		SqlNode sqlNode = isLeft ? fromjoin.getLeft() : fromjoin.getRight();
		if (sqlNode instanceof SqlJoin) {
			SqlJoin temp = (SqlJoin) sqlNode;
			findDbTbBySqlJoin(retobj, temp, true);
			findDbTbBySqlJoin(retobj, temp, false);
		} else if (sqlNode instanceof SqlBasicCall) {
			packageBasicCall(retobj, sqlNode);
		}
	}

	private void packageBasicCall(List<TbSimple> retobj, SqlNode sqlNode) {
		List<SqlNode> nodelist = ((SqlBasicCall) sqlNode).getOperandList();
		if (nodelist.get(0) instanceof SqlSelect) {// 子sql嵌套
			SqlParserAssit temp = new SqlParserAssit(this.defaultCatalog, this.defaultDb, nodelist.get(0));
			List<TbSimple> tbs = temp.findTbInfos();// 别名没办法兼容了，只能丢弃
			retobj.addAll(tbs);
		} else if (nodelist.get(0) instanceof SqlIdentifier) {
			SqlIdentifier sqlIdentifier = (SqlIdentifier) nodelist.get(0);
			TbSimple dbTbLeft = getDbTb(sqlIdentifier, nodelist.size() > 1 ? nodelist.get(1).toString() : null);
			retobj.add(dbTbLeft);
		}
	}

	private TbSimple getDbTb(SqlIdentifier sqlIdentifier, String alias) {
		TbSimple retobj = null;
		if (sqlIdentifier.names.size() == 1) {
			retobj = TbSimple.builder().catalog(this.defaultCatalog).db(this.defaultDb).tb(sqlIdentifier.names.get(0))
					.alias(alias).build();
		} else if (sqlIdentifier.names.size() == 2) {
			retobj = TbSimple.builder().catalog(this.defaultCatalog).db(sqlIdentifier.names.get(0))
					.tb(sqlIdentifier.names.get(1)).alias(alias).build();
		} else if (sqlIdentifier.names.size() == 3) {// catalog.db.tb
			retobj = TbSimple.builder().catalog(sqlIdentifier.names.get(0)).db(sqlIdentifier.names.get(1))
					.tb(sqlIdentifier.names.get(2)).alias(alias).build();
		}
		return retobj;
	}

	private TbSimple getDbTb(List<SqlNode> operandList) {
		SqlIdentifier sqlIdentifier = (SqlIdentifier) operandList.get(0);
		TbSimple dbTbLeft = getDbTb(sqlIdentifier, operandList.size() > 1 ? operandList.get(1).toString() : null);
		return dbTbLeft;
	}

	private TbSimple getCatalogDb(List<SqlNode> operandList) {
		SqlIdentifier sqlIdentifier = null;
		if (operandList.get(0) instanceof SqlIdentifier) {
			sqlIdentifier = (SqlIdentifier) operandList.get(0);
		} else if (operandList.get(1) instanceof SqlIdentifier) {
			sqlIdentifier = (SqlIdentifier) operandList.get(1);
		} else {
			throw new ProjectExceptionRuntime(ExceptAll.Project_default, "解析catalog/db出错");
		}
		TbSimple retobj = null;
		if (sqlIdentifier.names.size() == 1) {
			retobj = TbSimple.builder().catalog(this.defaultCatalog).db(sqlIdentifier.names.get(0)).build();
		} else if (sqlIdentifier.names.size() == 2) {
			retobj = TbSimple.builder().catalog(sqlIdentifier.names.get(0)).db(sqlIdentifier.names.get(1)).build();
		}
		return retobj;
	}

}
