package net.wicp.tams.common.kubernetes.convertvalue;

import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.callback.IConvertValue;
import net.wicp.tams.common.kubernetes.helm.HelmClient;
import net.wicp.tams.common.kubernetes.helm.HelmCmd;
import net.wicp.tams.common.kubernetes.helm.HelmFlags;
import net.wicp.tams.common.kubernetes.helm.IConvertParams;
import net.wicp.tams.common.kubernetes.helm.po.HelmInst;

@Slf4j
public class ConvertValueHelmStatus<T> implements IConvertValue<T> {
	private final IConvertParams<T> packer;
	private final String[] fitHelmNames;
	
	private  IConvertValue<Object> userConvert;

	
	public ConvertValueHelmStatus(IConvertParams<T> packer, String nameForNameCol) {
		this.packer = packer;
		this.fitHelmNames = null;
	}

	public ConvertValueHelmStatus(IConvertParams<T> packer, String[] fitHelmNames) {
		this.packer = packer;
		this.fitHelmNames = fitHelmNames;
	}

	@Override
	public String getStr(T keyObj) {
		Map<HelmFlags, String> values = this.packer.pack(keyObj);
		Result call = HelmClient.call(HelmCmd.list, values);
		String retstr="未部署";
		if (!call.isSuc()) {
			retstr= "异常";// call.getMessage();
		}else if (ArrayUtils.isEmpty(call.retObjs())) {
			retstr= "未部署";
		}else {
			for (Object obj : call.retObjs()) {
				HelmInst helmInst = (HelmInst) obj;
				try {
					if (ArrayUtils.isNotEmpty(fitHelmNames) && ArrayUtils.contains(fitHelmNames, helmInst.getName())) {
						retstr= helmInst.getStatus();
						break;
					} else if (helmInst.getName().equals(values.get(HelmFlags.name))) {
						retstr= helmInst.getStatus();
						break;
					}
				} catch (Exception e) {
					log.error("转换失败", e);
				}
			}
		}		
		if(userConvert!=null) {
			return  userConvert.getStr(Pair.of(keyObj, retstr));
		}else {
			return retstr;
		}
	}
	
	public void setUserConvert(IConvertValue<Object> userConvert) {
		this.userConvert = userConvert;
	}


}
