package net.wicp.tams.common.kubernetes.beans;

import lombok.Data;

@Data
public class KubernetesResultCol {
	private String name;
	private String comment;
	private String logicalType;
	private String jsonPath;// json路径
	private boolean logicalNullable;
	private long logicalLength;

	public KubernetesResultCol(String name) {
		this.name = name;
		this.logicalType = "VARCHAR";
		this.logicalNullable = true;
		this.logicalLength = Long.MAX_VALUE;
	}

	public KubernetesResultCol(String name, String logicalType) {
		this.name = name;
		this.logicalType = logicalType;
		this.logicalNullable = true;
		this.logicalLength = Long.MAX_VALUE;
	}

	public boolean equals(Object obj) {
		KubernetesResultCol temp=(KubernetesResultCol)obj;
		return this.name.equalsIgnoreCase(temp.getName());
	}
	
	@Override
	public int hashCode() {
		return name.toLowerCase().hashCode();
	}
	
}
