package net.wicp.tams.common.kubernetes.apiserver.crd;

import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;

/***
 * 自定义资源配置，ops等可以使用
 * 
 * @author Andy
 *
 */
public interface ICrdDef {
//描述
	public String getDesc();

//组
	public String getGroup();

//名
	public default String getCrdName() {
		return String.format("%s.%s", getPlural(), getGroup());
	}

	public String getPlural();

	public String getScope();

	public String getKind();
	
	public String[] getShortNames();

	public String[] getVersions();
	
	public default String getApiVersion(int versionIndex){
		return String.format("%s/%s", this.getGroup(),getVersions()[versionIndex]);
	}
	

	public default CustomResourceDefinitionContext getCrd() {
//		int indexOf = ArrayUtils.indexOf(this.versions, version);
//		if (indexOf < 0) {
//			throw new ProjectExceptionRuntime(ExceptAll.k8s_api_versionnotexit, "不存在这个版本:" + version);
//		}
		// 版本影响不大，跳过处理，暂不处理版本相关信息
		int indexOf = 0;
		CustomResourceDefinitionContext context = new CustomResourceDefinitionContext.Builder()
				.withGroup(this.getGroup()).withKind(getKind())
				// .withKind("Dummy")
				.withName(this.getCrdName()).withPlural(this.getPlural()).withScope(this.getScope())
				.withVersion(this.getVersions()[indexOf]).build();
		return context;
	}
}
