package net.wicp.tams.common.kubernetes.apiserver.crd;

import java.util.Map;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.StringUtil;

public class CrdDefConfig implements ICrdDef {
	private final Map<String, String> confmap;

	public CrdDefConfig(String crdName) {
		String confPre = String.format("common.kubernetes.crd.conf.%s.", crdName);
		this.confmap = Conf.getPre(confPre, true);
	}

	@Override
	public String getDesc() {
		return confmap.get("desc");
	}

	@Override
	public String getGroup() {
		return confmap.get("group");
	}

	@Override
	public String getPlural() {
		return confmap.get("plural");
	}

	@Override
	public String getScope() {
		return StringUtil.hasNull(confmap.get("scope"), "Namespaced");
	}

	@Override
	public String getKind() {
		return confmap.get("plural");
	}

	@Override
	public String[] getShortNames() {
		return confmap.get("shortNames").split(",");
	}

	@Override
	public String[] getVersions() {
		return confmap.get("versions").split(",");
	}

}
