/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.helm.po;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.wicp.tams.common.apiext.DateUtil;
import net.wicp.tams.common.apiext.StringUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelmInst {
    private static final Logger log = LoggerFactory.getLogger(HelmInst.class);
    private String name;
    private String namespace;
    private String revesion;
    private Date updated;
    private String status;
    private String chart;
    private String appVersion;

    public static List<HelmInst> splitList(String value) {
        String[] rows = value.split("\n");
        ArrayList<HelmInst> retlist = new ArrayList<HelmInst>();
        String[] head = null;
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i].startsWith("WARNING: ")) continue;
            String[] row = rows[i].split("\t");
            if (row.length < 7) {
                log.error("\u6b64\u7ed3\u679c\u4e0d\u80fd\u88ab\u89e3\u6790\uff1a" + rows[i]);
                continue;
            }
            log.info("\u8fd4\u56de\u503c:" + rows[i]);
            String col0 = StringUtil.trimSpace((String)row[0]);
            String col1 = StringUtil.trimSpace((String)row[1]);
            String col2 = StringUtil.trimSpace((String)row[2]);
            String col3 = StringUtil.trimSpace((String)row[3]);
            String col4 = StringUtil.trimSpace((String)row[4]);
            String col5 = StringUtil.trimSpace((String)row[5]);
            String col6 = StringUtil.trimSpace((String)row[6]);
            if (ArrayUtils.isEmpty(head) && "NAME".equals(col0) && "APP VERSION".equals(col6)) {
                head = new String[]{col0, col1, col2, col3, col4, col5, col6};
                continue;
            }
            HelmInst temp = new HelmInst();
            temp.setName(col0);
            temp.setNamespace(col1);
            temp.setRevesion(col2);
            try {
                temp.setUpdated(DateUtil.objToDate((Object)col3.subSequence(0, 19)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            temp.setStatus(col4);
            temp.setChart(col5);
            temp.setAppVersion(col6);
            retlist.add(temp);
        }
        return retlist;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getRevesion() {
        return this.revesion;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public String getStatus() {
        return this.status;
    }

    public String getChart() {
        return this.chart;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setRevesion(String revesion) {
        this.revesion = revesion;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setChart(String chart) {
        this.chart = chart;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HelmInst)) {
            return false;
        }
        HelmInst other = (HelmInst)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$revesion = this.getRevesion();
        String other$revesion = other.getRevesion();
        if (this$revesion == null ? other$revesion != null : !this$revesion.equals(other$revesion)) {
            return false;
        }
        Date this$updated = this.getUpdated();
        Date other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$chart = this.getChart();
        String other$chart = other.getChart();
        if (this$chart == null ? other$chart != null : !this$chart.equals(other$chart)) {
            return false;
        }
        String this$appVersion = this.getAppVersion();
        String other$appVersion = other.getAppVersion();
        return !(this$appVersion == null ? other$appVersion != null : !this$appVersion.equals(other$appVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HelmInst;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $revesion = this.getRevesion();
        result = result * 59 + ($revesion == null ? 43 : $revesion.hashCode());
        Date $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $chart = this.getChart();
        result = result * 59 + ($chart == null ? 43 : $chart.hashCode());
        String $appVersion = this.getAppVersion();
        result = result * 59 + ($appVersion == null ? 43 : $appVersion.hashCode());
        return result;
    }

    public String toString() {
        return "HelmInst(name=" + this.getName() + ", namespace=" + this.getNamespace() + ", revesion=" + this.getRevesion() + ", updated=" + this.getUpdated() + ", status=" + this.getStatus() + ", chart=" + this.getChart() + ", appVersion=" + this.getAppVersion() + ")";
    }
}

