/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.helm.po;

import java.util.ArrayList;
import net.wicp.tams.common.apiext.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartInst {
    private static final Logger log = LoggerFactory.getLogger(ChartInst.class);
    private String name;
    private String version;
    private String appVersion;
    private String description;

    public static ChartInst[] splitList(String value) {
        String[] rows = value.split("\n");
        ArrayList<ChartInst> retlist = new ArrayList<ChartInst>();
        if (rows.length > 1) {
            for (int i = 1; i < rows.length; ++i) {
                if (rows[i].startsWith("WARNING: ")) continue;
                String[] row = rows[i].split("\t");
                if (row.length < 4) {
                    log.error("\u6b64\u7ed3\u679c\u4e0d\u80fd\u88ab\u89e3\u6790\uff1a" + rows[i]);
                    continue;
                }
                log.info("\u8fd4\u56de\u503c:" + rows[i]);
                ChartInst inst = ChartInst.builder().name(StringUtil.trimSpace((String)row[0])).version(StringUtil.trimSpace((String)row[1])).appVersion(StringUtil.trimSpace((String)row[2])).description(StringUtil.trimSpace((String)row[3])).build();
                retlist.add(inst);
            }
        }
        return retlist.toArray(new ChartInst[retlist.size()]);
    }

    ChartInst(String name, String version, String appVersion, String description) {
        this.name = name;
        this.version = version;
        this.appVersion = appVersion;
        this.description = description;
    }

    public static ChartInstBuilder builder() {
        return new ChartInstBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartInst)) {
            return false;
        }
        ChartInst other = (ChartInst)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$appVersion = this.getAppVersion();
        String other$appVersion = other.getAppVersion();
        if (this$appVersion == null ? other$appVersion != null : !this$appVersion.equals(other$appVersion)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChartInst;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $appVersion = this.getAppVersion();
        result = result * 59 + ($appVersion == null ? 43 : $appVersion.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "ChartInst(name=" + this.getName() + ", version=" + this.getVersion() + ", appVersion=" + this.getAppVersion() + ", description=" + this.getDescription() + ")";
    }

    public static class ChartInstBuilder {
        private String name;
        private String version;
        private String appVersion;
        private String description;

        ChartInstBuilder() {
        }

        public ChartInstBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChartInstBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ChartInstBuilder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public ChartInstBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ChartInst build() {
            return new ChartInst(this.name, this.version, this.appVersion, this.description);
        }

        public String toString() {
            return "ChartInst.ChartInstBuilder(name=" + this.name + ", version=" + this.version + ", appVersion=" + this.appVersion + ", description=" + this.description + ")";
        }
    }
}

