/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.duckula;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.FreemarkUtil;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.jdbc.JdbcAssit;
import net.wicp.tams.common.apiext.jdbc.JdbcConnection;
import net.wicp.tams.common.constant.DbType;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.kubernetes.apiserver.KubeClientTams;
import net.wicp.tams.common.kubernetes.beans.DucklaHelmInfo;
import net.wicp.tams.common.kubernetes.beans.HelmChartInfo;
import net.wicp.tams.common.kubernetes.duckula.ConfigItem;
import net.wicp.tams.common.kubernetes.duckula.UploadSubDir;
import net.wicp.tams.common.kubernetes.helm.HelmClient;
import net.wicp.tams.common.kubernetes.helm.po.HelmInst;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuckulaInstall {
    private static final Logger log = LoggerFactory.getLogger(DuckulaInstall.class);
    private final Map<String, String> params;
    private final String initInstallPre = "duckula-init";
    private final KubeClientTams tams;
    private final HelmClient helmClient;
    private boolean isInitK8s = false;

    public Map<String, String> getParams() {
        return this.params;
    }

    public KubeClientTams getTams() {
        return this.tams;
    }

    public HelmClient getHelmClient() {
        return this.helmClient;
    }

    public DuckulaInstall(File k8sConfig, Properties properties) {
        Conf.overProp((Properties)properties);
        log.info("============\u6536\u5230\u7684\u914d\u7f6e\u9879======");
        for (Object object : properties.keySet()) {
            log.info("===={}={}", object, (Object)properties.getProperty(String.valueOf(object)));
        }
        log.info("============00 \u914d\u7f6e\u4fe1\u606f======");
        this.params = ConfigItem.proParams();
        for (String string : this.params.keySet()) {
            System.out.println("key=" + string + "   value=" + this.params.get(string));
        }
        if (k8sConfig == null) {
            this.tams = new KubeClientTams();
            File config = this.getConfig();
            this.helmClient = new HelmClient(config.getPath());
        } else {
            this.tams = new KubeClientTams(k8sConfig.getPath());
            this.helmClient = new HelmClient(k8sConfig.getPath());
        }
    }

    public DuckulaInstall(File k8sConfig, String configConext) {
        this(k8sConfig, IOUtil.StringToProperties((String)configConext));
    }

    public DuckulaInstall(String configConext) {
        this(null, configConext);
    }

    public DuckulaInstall(File k8sConfig, File config) {
        this(k8sConfig, IOUtil.fileToProperties((File)config));
    }

    public DuckulaInstall(File config) {
        this(null, config);
    }

    public Result install(DucklaHelmInfo ducklaHelmInfo) {
        List<HelmInst> listTenant;
        Object[] checkParams = ducklaHelmInfo.getChecker().checkParams(this.params);
        if (ArrayUtils.isNotEmpty((Object[])checkParams)) {
            return Result.getError((String)("\u4e0b\u5217\u53c2\u6570\u4e0d\u7b26\u5408\u8981\u6c42\uff1a" + CollectionUtil.arrayJoin((Object[])checkParams, (String)",")));
        }
        if (ducklaHelmInfo.isNeedInitK8s() && !this.isInitK8s) {
            this.initK8s();
        }
        if (CollectionUtils.isEmpty(listTenant = this.helmClient.listInstance(ducklaHelmInfo.getHelmInstanceName(), ConfigItem.k8s_namespace.getValue()))) {
            File osPathForValue = new File(UploadSubDir.helmvalue.getOsPathDir(ducklaHelmInfo.getHelmInstanceName() + ".yaml"));
            if (!osPathForValue.exists()) {
                String clustervalue = null;
                try {
                    clustervalue = IOUtil.slurp((InputStream)IOUtil.fileToInputStream((String)ducklaHelmInfo.getHelmValueTempPath(), ducklaHelmInfo.getHelmClassz()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                clustervalue = FreemarkUtil.getInst().doProcessByTemp(clustervalue, this.params);
                log.info(clustervalue);
                DuckulaInstall.saveFile(osPathForValue.getPath(), clustervalue);
            }
            File targetFile = new File(UploadSubDir.helmchart.getOsPathDir(ducklaHelmInfo.getHelmChartFileName()));
            File file = DuckulaInstall.copyCharts(ducklaHelmInfo.getHelmClassz(), ducklaHelmInfo.getHelmChartPath(), targetFile);
            HelmChartInfo helmChartInfoForTenant = HelmChartInfo.parseChartTgz(file.getPath());
            Result result = this.helmClient.install(ducklaHelmInfo.getHelmInstanceName(), helmChartInfoForTenant, osPathForValue.getPath());
            log.info("============\u5b8c\u6210\u5b89\u88c5\uff1a" + ducklaHelmInfo.getHelmInstanceName() + "======");
            return result;
        }
        log.info("============\u8df3\u8fc7\u5b89\u88c5\uff1a" + ducklaHelmInfo.getHelmInstanceName() + "======");
        return Result.getSuc();
    }

    public Result installNewDuckula() {
        UploadSubDir.clearDir();
        Result initK8s = this.initK8s();
        if (!initK8s.isSuc()) {
            return initK8s;
        }
        Result installOps = this.installOps();
        if (!installOps.isSuc()) {
            return installOps;
        }
        Result initTenant = this.initTenant();
        return initTenant;
    }

    public Result initTenant() {
        this.checkConfig(ConfigItem.k8s_namespace, ConfigItem.k8s_secret_docker_enable, ConfigItem.duckula_deployId, ConfigItem.k8s_secret_ssl_enable, ConfigItem.docker_image_repository, ConfigItem.duckula_defaultdb, ConfigItem.db_port, ConfigItem.db_host, ConfigItem.db_username, ConfigItem.db_password, ConfigItem.duckula_agent_imageGroup, ConfigItem.duckula_agent_imageVersion, ConfigItem.duckula_agent_ingress_enable, ConfigItem.duckula_agent_ingressHost, ConfigItem.duckula_operator_imageGroup, ConfigItem.duckula_operator_imageVersion);
        List<HelmInst> listTenant = this.helmClient.listInstance("duckula-init-tenant", ConfigItem.k8s_namespace.getValue());
        if (CollectionUtils.isEmpty(listTenant)) {
            File initTenantHelmValue = this.getTenantInitHelmValue();
            File file = DuckulaInstall.copyCharts("duckula-init-tenant-0.1.0.tgz");
            HelmChartInfo helmChartInfoForTenant = HelmChartInfo.parseChartTgz(file.getPath());
            Result result = this.helmClient.install("duckula-init-tenant", helmChartInfoForTenant, initTenantHelmValue.getPath());
            log.info("============15 \u6267\u884c\u79df\u6237\u521d\u59cb\u5316======");
            return result;
        }
        log.info("============15 \u8df3\u8fc7\u6267\u884c\u79df\u6237\u521d\u59cb\u5316======");
        return Result.getSuc();
    }

    public Result installDolphinscheduler() {
        this.checkConfig(ConfigItem.docker_image_repository, ConfigItem.ds_images_imageGroup, ConfigItem.ds_images_imageVersion, ConfigItem.db_host, ConfigItem.db_port, ConfigItem.db_username, ConfigItem.db_password, ConfigItem.ds_defaultdb, ConfigItem.ds_ingressHost);
        List<HelmInst> listTenant = this.helmClient.listInstance("dolphinscheduler", ConfigItem.k8s_namespace.getValue());
        if (CollectionUtils.isEmpty(listTenant)) {
            File osPathForValue = new File(UploadSubDir.helmvalue.getOsPathDir("ds.yaml"));
            if (!osPathForValue.exists()) {
                String clustervalue = null;
                try {
                    clustervalue = IOUtil.slurp((InputStream)IOUtil.fileToInputStream((String)"/duckula/values-dolphinscheduler.yaml", DuckulaInstall.class));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                clustervalue = FreemarkUtil.getInst().doProcessByTemp(clustervalue, this.params);
                log.info(clustervalue);
                DuckulaInstall.saveFile(UploadSubDir.helmvalue.getOsPathDir("ds.yaml"), clustervalue);
            }
            File file = DuckulaInstall.copyCharts("dolphinscheduler-2.0.3.tgz");
            HelmChartInfo helmChartInfoForTenant = HelmChartInfo.parseChartTgz(file.getPath());
            Result result = this.helmClient.install("dolphinscheduler", helmChartInfoForTenant, osPathForValue.getPath());
            log.info("============16 \u6267\u884cds\u914d\u7f6e======");
            return result;
        }
        log.info("============16 \u8df3\u8fc7\u6267\u884cds\u914d\u7f6e======");
        return Result.getSuc();
    }

    public Result installOps() {
        this.checkConfig(ConfigItem.docker_image_repository, ConfigItem.duckula_ops_imageGroup, ConfigItem.duckula_ops_imageVersion, ConfigItem.k8s_secret_docker_enable, ConfigItem.duckula_ops_cpu, ConfigItem.duckula_ops_memory, ConfigItem.duckula_ops_ingressHost, ConfigItem.duckula_ops_ingressHost, ConfigItem.db_host, ConfigItem.db_port, ConfigItem.duckula_defaultdb, ConfigItem.db_username, ConfigItem.db_password, ConfigItem.duckula_ops_ingressHost, ConfigItem.duckula_deployId, ConfigItem.k8s_namespace);
        Connection mysqlconn = this.initConn();
        log.info("============01 \u6570\u636e\u5e93\u8fde\u63a5\u68c0\u67e5\u901a\u8fc7======");
        List<HelmInst> listInstance = this.helmClient.listInstance("duckula-ops", ConfigItem.k8s_namespace.getValue());
        if (CollectionUtils.isEmpty(listInstance)) {
            try {
                DuckulaInstall.initOpsDb(mysqlconn);
            }
            finally {
                JdbcAssit.close((Connection)mysqlconn);
            }
            File opsHelmValue = this.getOpsHelmValue();
            File copyCharts = DuckulaInstall.copyCharts("duckula-ops-0.1.0.tgz");
            HelmChartInfo helmChartInfoForOps = HelmChartInfo.parseChartTgz(copyCharts.getPath());
            Result result = this.helmClient.install("duckula-ops", helmChartInfoForOps, opsHelmValue.getPath());
            log.info("============14 \u6267\u884cops\u914d\u7f6e======");
            return result;
        }
        log.info("============14 \u8df3\u8fc7\u6267\u884cops\u914d\u7f6e======");
        return Result.getSuc();
    }

    public Connection initConn() {
        boolean testConn = DbType.mysql.testConn(ConfigItem.db_host.getValue(), Integer.parseInt(ConfigItem.db_port.getValue()), ConfigItem.db_username.getValue(), ConfigItem.db_password.getValue());
        if (!testConn) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_conn_fail, "\u8bf7\u786e\u8ba4\u6570\u636e\u5e93\u7684\u8fde\u901a\uff0c\u5305\u62ec\u68c0\u67e5\u767d\u660e\u5355\uff0c\u4ee5mysql client\u80fd\u8fdb\u884c\u8fde\u63a5\u4e3a\u51c6\u3002");
        }
        String url = DbType.mysql.geturl(ConfigItem.db_host.getValue(), Integer.parseInt(ConfigItem.db_port.getValue()), ConfigItem.duckula_defaultdb.getValue());
        Connection mysqlconn = JdbcConnection.getConnectionMyql((String)url, (String)ConfigItem.db_username.getValue(), (String)ConfigItem.db_password.getValue());
        if (mysqlconn == null) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.jdbc_conn_fail, "\u8fde\u63a5\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u5730\u5740\uff1a" + url);
        }
        return mysqlconn;
    }

    public Result initK8s() {
        Result result;
        File clusterInitHelmValue;
        Map paramsmap;
        File copyCharts;
        ArrayList<String> errorItems = new ArrayList<String>();
        for (Object configItem : ConfigItem.findConfigItem("k8s_")) {
            if (!configItem.isNotNull() || !StringUtil.isNull((Object)this.params.get(configItem.name()))) continue;
            errorItems.add(configItem.getItemName());
        }
        if (errorItems.size() > 0) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u4e0b\u5217\u53c2\u6570\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff1a" + CollectionUtil.listJoin(errorItems, (String)","));
        }
        boolean hasCluster = false;
        ArrayList<String> initNamespaces = new ArrayList<String>();
        List<HelmInst> listInstanceGloble = this.helmClient.listInstanceGloble("duckula-init-");
        for (HelmInst helmInst : listInstanceGloble) {
            boolean bl = hasCluster = hasCluster || helmInst.getName().equals("duckula-init-cluster") || helmInst.getName().equals("duckula-init-all");
            if (!helmInst.getName().equals("duckula-init-namespace") && !helmInst.getName().equals("duckula-init-all")) continue;
            initNamespaces.add(helmInst.getNamespace());
        }
        if (!hasCluster) {
            copyCharts = DuckulaInstall.copyCharts("duckula-init-k8s-0.1.0.tgz");
            HelmChartInfo helmChartInfoForK8s = HelmChartInfo.parseChartTgz(copyCharts.getPath());
            paramsmap = CollectionUtil.newMapStr((String[])new String[]{"scope", "cluster", "namespace", ConfigItem.k8s_namespace.getValue()});
            clusterInitHelmValue = this.getClusterInitHelmValue();
            result = this.helmClient.install("duckula-init-cluster", ConfigItem.k8s_namespace.getValue(), helmChartInfoForK8s, clusterInitHelmValue.getPath(), paramsmap);
            log.info("============12 \u6267\u884ccluster\u914d\u7f6e======");
            if (!result.isSuc()) {
                this.isInitK8s = false;
                return result;
            }
        } else {
            log.info("============12 \u8df3\u8fc7\u6267\u884ccluster\u914d\u7f6e======");
        }
        if (!initNamespaces.contains(ConfigItem.k8s_namespace.getValue())) {
            copyCharts = DuckulaInstall.copyCharts("duckula-init-k8s-0.1.0.tgz");
            HelmChartInfo helmChartInfoForTeant = HelmChartInfo.parseChartTgz(copyCharts.getPath());
            paramsmap = CollectionUtil.newMapStr((String[])new String[]{"scope", "namespace", "namespace", ConfigItem.k8s_namespace.getValue(), "needsa", "no"});
            clusterInitHelmValue = this.getClusterInitHelmValue();
            result = this.helmClient.install("duckula-init-namespace", ConfigItem.k8s_namespace.getValue(), helmChartInfoForTeant, clusterInitHelmValue.getPath(), paramsmap);
            log.info("============13 \u6267\u884cnamespace\u914d\u7f6e======");
            if (!result.isSuc()) {
                this.isInitK8s = false;
                return result;
            }
        } else {
            log.info("============13 \u8df3\u8fc7\u6267\u884cnamespace\u914d\u7f6e======");
        }
        this.isInitK8s = true;
        return Result.getSuc();
    }

    public File getClusterInitHelmValue() {
        File osPathForValue = new File(UploadSubDir.helmvalue.getOsPathDir("cluster.yaml"));
        if (osPathForValue.exists()) {
            return osPathForValue;
        }
        String clustervalue = null;
        try {
            clustervalue = IOUtil.slurp((InputStream)IOUtil.fileToInputStream((String)"/duckula/values-duckula-init-k8s.yaml", DuckulaInstall.class));
        }
        catch (Exception e) {
            log.error("\u8bfbvalues-duckula-init-k8s.yaml\u5931\u8d25", (Throwable)e);
            return null;
        }
        clustervalue = FreemarkUtil.getInst().doProcessByTemp(clustervalue, this.params);
        log.info(clustervalue);
        DuckulaInstall.saveFile(UploadSubDir.helmvalue.getOsPathDir("cluster.yaml"), clustervalue);
        log.info("============02 \u751f\u6210cluster\u7684\u914d\u7f6e======");
        return osPathForValue;
    }

    public File getTenantInitHelmValue() {
        File osPathForValue = new File(UploadSubDir.helmvalue.getOsPathDir("tenant.yaml"));
        if (osPathForValue.exists()) {
            return osPathForValue;
        }
        String tenantvalue = null;
        try {
            tenantvalue = IOUtil.slurp((InputStream)IOUtil.fileToInputStream((String)"/duckula/values-duckula-init-tenant.yaml", DuckulaInstall.class));
        }
        catch (Exception e) {
            log.error("\u8bfbvalues-duckula-init-tenant.yaml\u5931\u8d25", (Throwable)e);
            return null;
        }
        tenantvalue = FreemarkUtil.getInst().doProcessByTemp(tenantvalue, this.params);
        log.info(tenantvalue);
        DuckulaInstall.saveFile(UploadSubDir.helmvalue.getOsPathDir("tenant.yaml"), tenantvalue);
        log.info("============03 \u751f\u6210namespace\u7684\u914d\u7f6e======");
        return osPathForValue;
    }

    public File getOpsHelmValue() {
        File osPathForValue = new File(UploadSubDir.helmvalue.getOsPathDir("ops.yaml"));
        if (osPathForValue.exists()) {
            return osPathForValue;
        }
        String opsvalue = null;
        try {
            opsvalue = IOUtil.slurp((InputStream)IOUtil.fileToInputStream((String)"/duckula/values-duckula3-ops.yaml", DuckulaInstall.class));
        }
        catch (Exception e) {
            log.error("\u8bfbvalues-duckula3-ops.yaml\u5931\u8d25", (Throwable)e);
            return null;
        }
        opsvalue = FreemarkUtil.getInst().doProcessByTemp(opsvalue, this.params);
        log.info(opsvalue);
        DuckulaInstall.saveFile(UploadSubDir.helmvalue.getOsPathDir("ops.yaml"), opsvalue);
        log.info("============04 \u751f\u6210ops\u7684\u914d\u7f6e======");
        return osPathForValue;
    }

    private File getConfig() {
        Result namespace;
        File file = new File(UploadSubDir.k8sconfig.getOsPathDir("config"));
        if (file.exists()) {
            return file;
        }
        boolean exitNamespace = this.tams.exitNamespace(ConfigItem.k8s_namespace.getValue());
        if (!exitNamespace && !(namespace = this.tams.createNamespace(ConfigItem.k8s_namespace.getValue())).isSuc()) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u521b\u5efa\u540d\u79f0\u7a7a\u95f4" + ConfigItem.k8s_namespace.getValue() + "\u5931\u8d25");
        }
        Result proKubeConfig = this.tams.proKubeConfig("duckula", ConfigItem.k8s_namespace.getValue(), "duckula-init", true);
        if (proKubeConfig.isSuc()) {
            try {
                FileUtils.write((File)file, (CharSequence)String.valueOf(proKubeConfig.retObjs(0)));
            }
            catch (IOException e) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u4e0d\u80fd\u521b\u5efa\u96c6\u7fa4\u7684config", (Throwable)e);
            }
        }
        return file;
    }

    private void checkConfig(ConfigItem ... checkItems) {
        ArrayList<String> errorItems = new ArrayList<String>();
        for (ConfigItem configItem : checkItems) {
            if (!configItem.isNotNull() || !StringUtil.isNull((Object)this.params.get(configItem.name()))) continue;
            errorItems.add(configItem.getItemName());
        }
        if (errorItems.size() > 0) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u4e0b\u5217\u53c2\u6570\u68c0\u67e5\u4e0d\u901a\u8fc7\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff1a" + CollectionUtil.listJoin(errorItems, (String)","));
        }
        if (!this.isInitK8s) {
            this.initK8s();
        }
    }

    private static <T> File copyCharts(Class<T> classz, String oriPath, File targetFile) {
        if (!targetFile.exists()) {
            try {
                FileUtils.copyInputStreamToFile((InputStream)IOUtil.fileToInputStream((String)oriPath, classz), (File)targetFile);
            }
            catch (IOException e) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u4e0d\u5b58\u5728\u6b64\u6587\u4ef6:" + targetFile.getPath(), (Throwable)e);
            }
        }
        return targetFile;
    }

    private static <T> File copyCharts(String fileName) {
        File file = new File(UploadSubDir.helmchart.getOsPathDir(fileName));
        String path = IOUtil.mergeFolderAndFilePath((String)"/duckula/charts", (String[])new String[]{fileName});
        return DuckulaInstall.copyCharts(DuckulaInstall.class, path, file);
    }

    private static void saveFile(String path, String context) {
        try {
            File file = new File(path);
            if (file.exists()) {
                FileUtils.forceDelete((File)file);
            }
            FileUtils.write((File)file, (CharSequence)context);
        }
        catch (IOException e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u5199\u6587\u4ef6\u3010" + path + "\u3011\u5931\u8d25", (Throwable)e);
        }
    }

    private static void initOpsDb(Connection mysqlconn) {
        try {
            JdbcAssit.exeSQLScript((Connection)mysqlconn, (String)"/duckula/duckula-init.sql", DuckulaInstall.class, (boolean)false, (boolean)true);
            int indexOf = ConfigItem.duckula_flink_ingressHost.getValue().indexOf(".");
            String ingressFlinkSubdomain = ConfigItem.duckula_flink_ingressHost.getValue().substring(0, indexOf);
            String ingressSuffix = ConfigItem.duckula_flink_ingressHost.getValue().substring(indexOf);
            String configContext = "";
            mysqlconn.setAutoCommit(false);
            String deployInsertSql = "REPLACE INTO  `common_deploy` VALUES (1344624860489924610, 'bigdata-idc', 'k8s', 'idc', '" + ConfigItem.k8s_namespace.getValue() + "', '', '', '" + ConfigItem.k8s_secret_docker_configjson.getValue() + "', '" + ConfigItem.docker_image_repository.getValue() + "', '', '', '" + ingressSuffix + "', '" + ingressFlinkSubdomain + "', '" + configContext + "', '/data/duckula-data/upload/k8sconfig/cluster/1344624860489924610', NULL, '', 22, '', '', '" + ConfigItem.k8s_nas_storageClass.getValue() + "', 'yes', 64, '', '', NULL, '\u79c1\u6709\u5316\u90e8\u7f72', now(), now(), 1, 1)";
            Result execSql = JdbcAssit.execSql((Connection)mysqlconn, (String)deployInsertSql);
            if (!execSql.isSuc() && !execSql.getMessage().contains("Duplicate entry")) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u6267\u884cSQL\u5931\u8d25\uff1a" + execSql.getMessage());
            }
            String agentUrl = StringUtil.isNull((Object)ConfigItem.duckula_agent_ingressHost.getValue()) ? "" : String.format("%s://%s", "true".equals(ConfigItem.k8s_ingress_ssl_enable.getValue()) ? "https" : "http", ConfigItem.duckula_agent_ingressHost.getValue());
            Result execTenantSql = JdbcAssit.execSql((Connection)mysqlconn, (String)("REPLACE INTO `sys_tenant` VALUES (0, 'common', '\u516c\u5171\u8d44\u6e90', 'admin', 'yes', '2021-06-27 09:39:16', 'test', 1344624860489924610, '" + ConfigItem.k8s_namespace.getValue() + "', NULL, '" + agentUrl + "', '', '', '')"));
            if (!execTenantSql.isSuc() && !execTenantSql.getMessage().contains("Duplicate entry")) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u6267\u884cSQL\u5931\u8d25\uff1a" + execTenantSql.getMessage());
            }
            Result agentSql = JdbcAssit.execSql((Connection)mysqlconn, (String)("REPLACE INTO `common_version` VALUES (6, 'duckula\u79df\u6237agent', NULL, 'rjzjh/duckulaagent', 'duckula-agent', '" + ConfigItem.duckula_agent_imageVersion.getValue() + "', '', 'duckula', 'duckulaagent', 'yes', '2022-05-28 21:16:39', 'yes', '" + ConfigItem.duckula_agent_imageVersion.getValue() + "', NULL, 'yes', '\u7528\u6237\u4e0a\u4f20\u6587\u4ef6\u7b49\u7ba1\u7406')"));
            if (!agentSql.isSuc() && !agentSql.getMessage().contains("Duplicate entry")) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u6267\u884cSQL\u5931\u8d25\uff1a" + agentSql.getMessage());
            }
            Result operatorSql = JdbcAssit.execSql((Connection)mysqlconn, (String)("REPLACE INTO `common_version` VALUES (7, 'duckula\u79df\u6237\u7684operator', NULL, 'rjzjh/duckulaoperator', 'operator-flink', '" + ConfigItem.duckula_operator_imageVersion.getValue() + "', '', 'duckula', 'duckulaoperator', 'yes', '2023-06-05 18:38:24', 'yes', '" + ConfigItem.duckula_operator_imageVersion.getValue() + "', '', 'yes', '\u79df\u6237\u7684k8s\u7ba1\u7406')"));
            if (!operatorSql.isSuc() && !operatorSql.getMessage().contains("Duplicate entry")) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u6267\u884cSQL\u5931\u8d25\uff1a" + operatorSql.getMessage());
            }
            Result opsSql = JdbcAssit.execSql((Connection)mysqlconn, (String)("REPLACE INTO `common_version` VALUES (12, 'ops\u63a7\u5236\u53f0', NULL, 'rjzjh/duckulaops', 'duckula-ops', '" + ConfigItem.duckula_ops_imageVersion.getValue() + "', '', 'duckula', 'duckulaops', 'yes', '2023-06-27 18:14:04', 'yes', '" + ConfigItem.duckula_ops_imageVersion.getValue() + "', '', 'yes', 'ops\u63a7\u5236\u53f0')"));
            if (!opsSql.isSuc() && !opsSql.getMessage().contains("Duplicate entry")) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u6267\u884cSQL\u5931\u8d25\uff1a" + opsSql.getMessage());
            }
            mysqlconn.commit();
            log.info("============14.0 \u6570\u636e\u5e93\u521d\u59cb\u5316======");
        }
        catch (Throwable e) {
            try {
                mysqlconn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            log.info("============14.0 \u6570\u636e\u5e93\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u6267\u884c======");
        }
    }
}

