/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.beans;

import io.kubernetes.client.openapi.models.V1PodStatus;
import org.apache.commons.lang3.StringUtils;

public enum PodPhase {
    Running("\u8fd0\u884c\u4e2d"),
    Pending("\u6b63\u5728\u542f\u52a8"),
    Succeeded("\u6267\u884c\u5b8c\u6210"),
    Failed("\u8fd0\u884c\u5931\u8d25"),
    Unknown("\u672a\u77e5\u72b6\u6001"),
    noExit("\u672a\u5e03\u7f72");

    public final String desc;

    private PodPhase(String desc) {
        this.desc = desc;
    }

    public static PodPhase find(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return noExit;
        }
        for (PodPhase ele : PodPhase.values()) {
            if (!name.equalsIgnoreCase(ele.name())) continue;
            return ele;
        }
        return noExit;
    }

    public static PodPhase find(V1PodStatus.PhaseEnum name) {
        if (name == null) {
            return noExit;
        }
        for (PodPhase ele : PodPhase.values()) {
            if (!name.name().equalsIgnoreCase(ele.name())) continue;
            return ele;
        }
        return noExit;
    }

    public String retStatusMessage() {
        return this == noExit ? this.desc : String.format("%s\u3010%s\u3011", this.desc, this.name());
    }
}

