/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.beans;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.TarUtil;
import net.wicp.tams.common.apiext.yaml.YamlAssist;
import net.wicp.tams.common.constant.PathType;

public class HelmChartInfo {
    private String name;
    private Integer apiVersion;
    private String appVersion;
    private String chartVersion;
    private String description;
    private String repoName;
    private String uploadFilePath;
    private String valueDefault;

    public static HelmChartInfo parseChartTgz(String pathTypePath) {
        String osPath = PathType.getPath((String)pathTypePath);
        File chartFile = new File(osPath);
        if (!chartFile.exists()) {
            return null;
        }
        String dir = TarUtil.deCompressTGZFile((String)osPath);
        JSONObject readYaml = YamlAssist.readYaml((String)IOUtil.mergeFolderAndFilePath((String)dir, (String[])new String[]{"/Chart.yaml"}));
        String valuePath = IOUtil.mergeFolderAndFilePath((String)dir, (String[])new String[]{"/values.yaml"});
        String slurpContext = IOUtil.slurp((String)valuePath);
        String apiVersionStr = readYaml.getString("apiVersion");
        HelmChartInfo chartInfo = HelmChartInfo.builder().uploadFilePath(osPath).apiVersion(new Integer(apiVersionStr.replace("v", ""))).name(StringUtil.trimSpace((String)readYaml.getString("name"))).description(StringUtil.trimSpace((String)readYaml.getString("description"))).chartVersion(StringUtil.trimSpace((String)readYaml.getString("version"))).appVersion(StringUtil.trimSpace((String)readYaml.getString("appVersion"))).valueDefault(slurpContext).build();
        return chartInfo;
    }

    HelmChartInfo(String name, Integer apiVersion, String appVersion, String chartVersion, String description, String repoName, String uploadFilePath, String valueDefault) {
        this.name = name;
        this.apiVersion = apiVersion;
        this.appVersion = appVersion;
        this.chartVersion = chartVersion;
        this.description = description;
        this.repoName = repoName;
        this.uploadFilePath = uploadFilePath;
        this.valueDefault = valueDefault;
    }

    public static HelmChartInfoBuilder builder() {
        return new HelmChartInfoBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Integer getApiVersion() {
        return this.apiVersion;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getChartVersion() {
        return this.chartVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public String getUploadFilePath() {
        return this.uploadFilePath;
    }

    public String getValueDefault() {
        return this.valueDefault;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setApiVersion(Integer apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public void setChartVersion(String chartVersion) {
        this.chartVersion = chartVersion;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRepoName(String repoName) {
        this.repoName = repoName;
    }

    public void setUploadFilePath(String uploadFilePath) {
        this.uploadFilePath = uploadFilePath;
    }

    public void setValueDefault(String valueDefault) {
        this.valueDefault = valueDefault;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HelmChartInfo)) {
            return false;
        }
        HelmChartInfo other = (HelmChartInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$apiVersion = this.getApiVersion();
        Integer other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !((Object)this$apiVersion).equals(other$apiVersion)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$appVersion = this.getAppVersion();
        String other$appVersion = other.getAppVersion();
        if (this$appVersion == null ? other$appVersion != null : !this$appVersion.equals(other$appVersion)) {
            return false;
        }
        String this$chartVersion = this.getChartVersion();
        String other$chartVersion = other.getChartVersion();
        if (this$chartVersion == null ? other$chartVersion != null : !this$chartVersion.equals(other$chartVersion)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$repoName = this.getRepoName();
        String other$repoName = other.getRepoName();
        if (this$repoName == null ? other$repoName != null : !this$repoName.equals(other$repoName)) {
            return false;
        }
        String this$uploadFilePath = this.getUploadFilePath();
        String other$uploadFilePath = other.getUploadFilePath();
        if (this$uploadFilePath == null ? other$uploadFilePath != null : !this$uploadFilePath.equals(other$uploadFilePath)) {
            return false;
        }
        String this$valueDefault = this.getValueDefault();
        String other$valueDefault = other.getValueDefault();
        return !(this$valueDefault == null ? other$valueDefault != null : !this$valueDefault.equals(other$valueDefault));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HelmChartInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : ((Object)$apiVersion).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $appVersion = this.getAppVersion();
        result = result * 59 + ($appVersion == null ? 43 : $appVersion.hashCode());
        String $chartVersion = this.getChartVersion();
        result = result * 59 + ($chartVersion == null ? 43 : $chartVersion.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $repoName = this.getRepoName();
        result = result * 59 + ($repoName == null ? 43 : $repoName.hashCode());
        String $uploadFilePath = this.getUploadFilePath();
        result = result * 59 + ($uploadFilePath == null ? 43 : $uploadFilePath.hashCode());
        String $valueDefault = this.getValueDefault();
        result = result * 59 + ($valueDefault == null ? 43 : $valueDefault.hashCode());
        return result;
    }

    public String toString() {
        return "HelmChartInfo(name=" + this.getName() + ", apiVersion=" + this.getApiVersion() + ", appVersion=" + this.getAppVersion() + ", chartVersion=" + this.getChartVersion() + ", description=" + this.getDescription() + ", repoName=" + this.getRepoName() + ", uploadFilePath=" + this.getUploadFilePath() + ", valueDefault=" + this.getValueDefault() + ")";
    }

    public static class HelmChartInfoBuilder {
        private String name;
        private Integer apiVersion;
        private String appVersion;
        private String chartVersion;
        private String description;
        private String repoName;
        private String uploadFilePath;
        private String valueDefault;

        HelmChartInfoBuilder() {
        }

        public HelmChartInfoBuilder name(String name) {
            this.name = name;
            return this;
        }

        public HelmChartInfoBuilder apiVersion(Integer apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public HelmChartInfoBuilder appVersion(String appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public HelmChartInfoBuilder chartVersion(String chartVersion) {
            this.chartVersion = chartVersion;
            return this;
        }

        public HelmChartInfoBuilder description(String description) {
            this.description = description;
            return this;
        }

        public HelmChartInfoBuilder repoName(String repoName) {
            this.repoName = repoName;
            return this;
        }

        public HelmChartInfoBuilder uploadFilePath(String uploadFilePath) {
            this.uploadFilePath = uploadFilePath;
            return this;
        }

        public HelmChartInfoBuilder valueDefault(String valueDefault) {
            this.valueDefault = valueDefault;
            return this;
        }

        public HelmChartInfo build() {
            return new HelmChartInfo(this.name, this.apiVersion, this.appVersion, this.chartVersion, this.description, this.repoName, this.uploadFilePath, this.valueDefault);
        }

        public String toString() {
            return "HelmChartInfo.HelmChartInfoBuilder(name=" + this.name + ", apiVersion=" + this.apiVersion + ", appVersion=" + this.appVersion + ", chartVersion=" + this.chartVersion + ", description=" + this.description + ", repoName=" + this.repoName + ", uploadFilePath=" + this.uploadFilePath + ", valueDefault=" + this.valueDefault + ")";
        }
    }
}

