/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.apiserver.crd;

import io.fabric8.kubernetes.api.model.DefaultKubernetesResourceList;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerFactory;
import io.fabric8.kubernetes.client.informers.cache.Cache;
import io.fabric8.kubernetes.client.informers.cache.Lister;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.ReflectAssist;
import net.wicp.tams.common.constant.OptType;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.kubernetes.apiserver.KubeClientTams;
import net.wicp.tams.common.kubernetes.apiserver.crd.ICrdRealize;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CRDController<CR extends CustomResource<S, T>, CRS extends DefaultKubernetesResourceList<CR>, S, T> {
    private static final Logger log = LoggerFactory.getLogger(CRDController.class);
    protected final KubeClientTams client;
    protected final MixedOperation<CR, CRS, Resource<CR>> crClient;
    protected final SharedInformerFactory informerFactory;
    protected final SharedIndexInformer<CR> crSharedIndexInformer;
    protected final Lister<CR> crLister;
    protected final String namespace;
    protected final ICrdRealize crdRealize;
    protected final BlockingQueue<Pair<String, OptType>> workqueue;

    public abstract void init();

    public abstract Result reconcile(CR var1, Pair<String, OptType> var2);

    public abstract T getCrStatus(CR var1);

    public abstract Result checkWithPreRun();

    public abstract Result needReconcile(S var1, T var2, S var3, T var4);

    public CRDController(final ICrdRealize crdRealize, KubeClientTams client, String namespace) {
        this.client = client;
        this.informerFactory = client.getClient().informers();
        this.namespace = namespace;
        this.crdRealize = crdRealize;
        this.crClient = client.getClient().resources(this.crdRealize.getCrClass(), this.crdRealize.getCrsClass());
        this.crSharedIndexInformer = this.informerFactory.sharedIndexInformerFor(this.crdRealize.getCrClass(), 600000L);
        this.workqueue = new ArrayBlockingQueue<Pair<String, OptType>>(1024);
        this.crLister = new Lister(this.crSharedIndexInformer.getIndexer(), namespace);
        this.crSharedIndexInformer.addEventHandler(new ResourceEventHandler<CR>(){
            Map<String, String> addUidVersionMap = new HashMap<String, String>();

            public void onAdd(CR cr) {
                log.info("add: the resource[{}],name[{}] ", (Object)crdRealize.getCrClass().getSimpleName(), (Object)cr.getMetadata().getName());
                if (crdRealize.getCrdName().equals(cr.getCRDName())) {
                    this.addUidVersionMap.put(cr.getMetadata().getUid(), cr.getMetadata().getResourceVersion());
                }
                CRDController.this.enqueuePodSet(cr, OptType.insert);
            }

            public void onUpdate(CR oldCR, CR newCR) {
                if (crdRealize.getCrdName().equals(newCR.getCRDName()) && this.addUidVersionMap.containsKey(newCR.getMetadata().getUid()) && this.addUidVersionMap.get(newCR.getMetadata().getUid()).equals(oldCR.getMetadata().getResourceVersion())) {
                    this.addUidVersionMap.remove(newCR.getMetadata().getUid());
                    return;
                }
                if (!CRDController.this.needReconcile(oldCR.getSpec(), oldCR.getStatus(), newCR.getSpec(), newCR.getStatus()).isSuc()) {
                    return;
                }
                log.info("update: the old resource[{}],new resource[{}] ", oldCR.getSpec(), newCR.getSpec());
                CRDController.this.enqueuePodSet(newCR, OptType.update);
            }

            public void onDelete(CR cr, boolean b) {
                log.info("delete: the resource[{}],name[{}] ", (Object)crdRealize.getCrClass().getSimpleName(), (Object)cr.getMetadata().getName());
                CRDController.this.enqueuePodSet(cr, OptType.delete);
            }
        });
        this.init();
        this.informerFactory.startAllRegisteredInformers();
        this.crSharedIndexInformer.stop();
    }

    public final void run() {
        log.info("Starting CR controller");
        while (!this.crSharedIndexInformer.hasSynced()) {
        }
        Result checkRs = (Result)ReflectAssist.invokeMothedRetry((Object)this, (String)"checkWithPreRun", (int)5, (Object[])new Object[0]);
        if (!checkRs.isSuc()) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u68c0\u67e5\u4e0d\u6210\u529f\uff0c\u4e0d\u80fd\u542f\u52a8");
        }
        while (true) {
            try {
                while (true) {
                    T crStatus;
                    log.info("trying to fetch item from workqueue...");
                    if (this.workqueue.isEmpty()) {
                        log.info("Work Queue is empty");
                    }
                    Pair<String, OptType> key = this.workqueue.take();
                    Objects.requireNonNull((String)key.getLeft(), "key can't be null");
                    log.info(String.format("Got %s", key.getLeft()));
                    if (key != null && ((String)key.getLeft()).isEmpty() || !((String)key.getLeft()).contains("/")) {
                        log.warn(String.format("invalid resource key: %s", key));
                        continue;
                    }
                    Result rcRs = null;
                    if (key.getRight() == OptType.delete) {
                        rcRs = this.reconcile(null, key);
                        continue;
                    }
                    String name = ((String)key.getLeft()).split("/")[1];
                    CustomResource cr = (CustomResource)this.crLister.get(((String)key.getLeft()).split("/")[1]);
                    if (cr == null) {
                        log.info(String.format("CR %s in workqueue no longer exists", name));
                        return;
                    }
                    rcRs = this.reconcile(cr, key);
                    if (!rcRs.isSuc() || (crStatus = this.getCrStatus(cr)) == null) continue;
                    cr.setStatus(crStatus);
                    ((Resource)((NonNamespaceOperation)this.crClient.inNamespace(cr.getMetadata().getNamespace())).resource((Object)cr)).patchStatus();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                log.info("controller interrupted..");
                continue;
            }
            break;
        }
    }

    private void enqueuePodSet(CR cr, OptType opt) {
        log.info("enqueueCR(" + cr.getMetadata().getName() + ")");
        String key = Cache.metaNamespaceKeyFunc(cr);
        log.info(String.format("Going to enqueue key %s", key));
        if (key != null && !key.isEmpty()) {
            log.info("Adding item to workqueue");
            this.workqueue.add((Pair<String, OptType>)Pair.of((Object)key, (Object)opt));
        }
    }
}

