/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes.apiserver;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaFluent;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.FilterNested;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceAccountResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.kubernetes.client.Exec;
import io.kubernetes.client.PodLogs;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.RbacAuthorizationV1Api;
import io.kubernetes.client.openapi.models.V1ClusterRoleBinding;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1DeploymentList;
import io.kubernetes.client.openapi.models.V1DeploymentSpec;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1RoleBinding;
import io.kubernetes.client.openapi.models.V1RoleRef;
import io.kubernetes.client.openapi.models.V1Subject;
import io.kubernetes.client.util.Yaml;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.FreemarkUtil;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.NumberUtil;
import net.wicp.tams.common.apiext.PwdUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.apiext.yaml.YamlAssist;
import net.wicp.tams.common.beans.StreamCopyBean;
import net.wicp.tams.common.callback.IProcess;
import net.wicp.tams.common.constant.dic.YesOrNo;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.IExcept;
import net.wicp.tams.common.exception.ProjectException;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;
import net.wicp.tams.common.http.HttpClient;
import net.wicp.tams.common.http.HttpResult;
import net.wicp.tams.common.kubernetes.K8sAssit;
import net.wicp.tams.common.kubernetes.apiserver.ApiClientCreator;
import net.wicp.tams.common.kubernetes.apiserver.ApiClientManager;
import net.wicp.tams.common.kubernetes.apiserver.crd.ICrdDef;
import net.wicp.tams.common.kubernetes.beans.PodPhase;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeClientTams {
    private static final Logger log = LoggerFactory.getLogger(KubeClientTams.class);
    private final KubernetesClient client;
    private final ApiClient apiClient;

    private void apiClientInit(ApiClient apiClient) {
        Configuration.setDefaultApiClient((ApiClient)apiClient);
        this.apiClient.setReadTimeout(300000);
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public KubeClientTams() {
        String k8sConfig;
        String incluster = Conf.get((String)"common.kubernetes.incluster");
        log.info("\u662f\u5426\u5728\u5bb9\u5668\u4e2d\u8fd0\u884c:{}", (Object)incluster);
        if (!YesOrNo.yes.name().equals(incluster) && !new File(k8sConfig = IOUtil.mergeFolderAndFilePath((String)System.getProperty("user.home"), (String[])new String[]{"/.kube/config"})).exists()) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.Project_default, "\u6ca1\u6709\u5728k8s\u5bb9\u5668\u4e2d\u8fd0\u884c\uff0c\u9700\u8981\u6709k8s\u7684\u8ba4\u8bc1\u6587\u4ef6\uff1a~/.kube/config");
        }
        this.client = this.initClient();
        this.apiClient = ApiClientManager.getApiClient();
        this.apiClientInit(this.apiClient);
    }

    public KubeClientTams(String kubeconfigstr, String context) {
        Validate.notEmpty((CharSequence)kubeconfigstr, (String)"k8s\u7684\u8ba4\u8bc1\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.client = this.getClientForKube(kubeconfigstr, context);
        this.apiClient = new ApiClientCreator(kubeconfigstr, context).createObject();
        this.apiClientInit(this.apiClient);
    }

    public KubeClientTams(String pathTypePath) {
        this(IOUtil.slurpPathTypePath((String)pathTypePath), null);
    }

    public KubeClientTams(KubernetesClient client, ApiClient apiClient) {
        this.client = client;
        this.apiClient = apiClient;
        this.apiClientInit(apiClient);
    }

    private KubernetesClient initClient() {
        KubernetesClient client = null;
        if (StringUtil.isNotNull((Object)Conf.get((String)"common.kubernetes.kubeconfig.path"))) {
            String kubeconfigstr = IOUtil.slurp((String)Conf.get((String)"common.kubernetes.kubeconfig.path"));
            String context = IOUtil.slurp((String)Conf.get((String)"common.kubernetes.kubeconfig.context"));
            client = this.getClientForKube(kubeconfigstr, context);
        } else if (StringUtil.isNotNull((Object)Conf.get((String)"common.kubernetes.apiserver.master.url"))) {
            ConfigBuilder config = (ConfigBuilder)new ConfigBuilder().withMasterUrl(Conf.get((String)"common.kubernetes.apiserver.master.url"));
            if (StringUtil.isNotNull((Object)Conf.get((String)"common.kubernetes.apiserver.master.username"))) {
                config.withUsername(Conf.get((String)"common.kubernetes.apiserver.master.username"));
                config.withPassword(Conf.get((String)"common.kubernetes.apiserver.master.password"));
            }
            config.withTrustCerts(true);
            client = new KubernetesClientBuilder().withConfig(config.build()).build();
        } else {
            client = new KubernetesClientBuilder().build();
        }
        return client;
    }

    private KubernetesClient getClientForKube(String kubeconfigstr, String context) {
        try {
            Config config = StringUtil.isNull((Object)context) ? Config.fromKubeconfig((String)kubeconfigstr) : Config.fromKubeconfig((String)context, (String)kubeconfigstr, null);
            KubernetesClient client = new KubernetesClientBuilder().withConfig(config).build();
            return client;
        }
        catch (Exception e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_conn_error, "", (Throwable)e);
        }
    }

    private String getUseNamespaceName(String namespace) {
        String namespaceTrue = StringUtil.isNull((Object)namespace) ? Conf.get((String)"common.kubernetes.apiserver.namespace.default") : namespace;
        return namespaceTrue;
    }

    public Namespace getNamespace(String namespace) {
        Namespace myns = (Namespace)((Resource)this.client.namespaces().withName(namespace)).get();
        return myns;
    }

    public ServiceList getServices(String namespace) {
        ServiceList myNsServices = (ServiceList)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).list();
        return myNsServices;
    }

    public ServiceList getServices() {
        return this.getServices(null);
    }

    public Service getService(String namespace, String serviceName) {
        Service myservice = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).withName(serviceName)).get();
        return myservice;
    }

    public GenericKubernetesResource createCusObject(ICrdDef crdVesion, String version, String namespace, InputStream fileInputStream) {
        try {
            CustomResourceDefinitionContext context = crdVesion.getCrd();
            NonNamespaceOperation inNamespace = (NonNamespaceOperation)this.client.genericKubernetesResources((ResourceDefinitionContext)context).inNamespace(namespace);
            Resource dummyObject = (Resource)inNamespace.load(fileInputStream);
            GenericKubernetesResource create = (GenericKubernetesResource)dummyObject.create();
            return create;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("404 page not found")) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_pagenotfound, "\u6ca1\u6709\u5e03\u7f72api:" + e.getMessage());
            }
            if (e.getMessage().contains("already exists")) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_exists, "\u5df2\u5b58\u5728\u6b64\u7c7b\u578b\u7684\u540c\u540d\u8d44\u6e90:" + e.getMessage());
            }
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u5e03\u7f72\u81ea\u5b9a\u4e49\u7684\u7c7b\u578b\u5931\u8d25", e);
        }
    }

    public GenericKubernetesResource createCusObject(ICrdDef crdVesion, String namespace, InputStream fileInputStream) {
        return this.createCusObject(crdVesion, null, namespace, fileInputStream);
    }

    public InputStream viewLog(Pod pod) {
        PodLogs logs = new PodLogs(this.apiClient);
        this.apiClient.setReadTimeout(300000);
        try {
            InputStream is = logs.streamNamespacedPodLog(pod.getMetadata().getNamespace(), pod.getMetadata().getName(), ((Container)pod.getSpec().getContainers().get(0)).getName(), null, Integer.valueOf(500), false);
            return is;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u65e5\u5fd7\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public InputStream viewLog(String namespace, String deploymentName) {
        Pod pod = this.getPodByDeployment(namespace, deploymentName, new String[0]);
        return this.viewLog(pod);
    }

    public Boolean copyFileToPod(String namespace, String deploymentName, String osFilepath, String podFilePath) {
        Pod pod = this.getPodByDeployment(namespace, deploymentName, new String[0]);
        Boolean upload = ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(pod.getMetadata().getNamespace())).withName(pod.getMetadata().getName())).file(osFilepath).upload(new File(podFilePath).toPath());
        return upload;
    }

    public InputStream copyFileFromPod(String namespace, String deploymentName, String podFilePath) {
        Pod pod = this.getPodByDeployment(namespace, deploymentName, new String[0]);
        InputStream inputStream = ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(pod.getMetadata().getNamespace())).withName(pod.getMetadata().getName())).file(podFilePath).read();
        return inputStream;
    }

    public Process execshell(String namespace, String podname, String ... cmdargs) {
        Validate.notBlank((CharSequence)podname, (String)"\u8282\u70b9\u540d\u5fc5\u586b", (Object[])new Object[0]);
        Validate.notEmpty((Object[])cmdargs, (String)"\u547d\u4ee4\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String[] args = null;
        args = cmdargs[0] != "sh" ? (String[])CollectionUtil.arrayMerge(String[].class, (Object[])new String[]{"sh", "-c"}, (Object[])cmdargs, (boolean)false) : cmdargs;
        Process proc = this.execPod(namespace, podname, args);
        return proc;
    }

    private Process execPod(String namespace, String podname, String[] args) {
        Process proc;
        Exec exec = new Exec(this.apiClient);
        boolean tty = System.console() != null;
        try {
            proc = exec.exec(StringUtil.hasNull((String[])new String[]{namespace, "default"}), podname, args, true, tty);
        }
        catch (ApiException e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u6267\u884cshell\u5931\u8d25\uff1a" + CollectionUtil.arrayJoin((Object[])args, (String)" "));
        }
        catch (IOException e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u6267\u884cshell\u5931\u8d25,\u7f51\u7edc\u6216io\u65b9\u9762\u95ee\u9898");
        }
        return proc;
    }

    public Process execFlinkSqlClient(String namespace, String podname, String shellcmd) {
        String[] paramsTrue = StringUtil.isNull((Object)shellcmd) ? new String[]{"sh", "-c", "/opt/flink/bin/sql-client.sh embedded"} : new String[]{"sh", "-c", shellcmd};
        return this.execshell(namespace, podname, paramsTrue);
    }

    public Process execFlinkSqlClientTams(String namespace, String podname, String params, String initFilePath) {
        String cmd = String.format("/opt/flink/bin/sql-client.sh embedded  -i   " + initFilePath + " -p %s", params);
        return this.execFlinkSqlClient(namespace, podname, cmd);
    }

    public Process execPod(String namespace, String podname) {
        String[] paramsTrue = new String[]{"sh", "-s", "/bin/bash"};
        return this.execPod(namespace, podname, paramsTrue);
    }

    public void execShellToSystemIO(String namespace, String podname, String ... cmdargs) {
        Process proc = this.execshell(namespace, podname, cmdargs);
        this.execShellToCallback(proc, (IProcess)StreamCopyBean.procToSystem((Process)proc), cmdargs);
    }

    public String execShellToResult(String namespace, String podname, boolean needError, String cmd) {
        Process proc = this.execshell(namespace, podname, cmd);
        try {
            String retstr = IOUtil.slurp((InputStream)proc.getInputStream());
            return retstr;
        }
        catch (IOException e) {
            log.error("\u6267\u884c\u547d\u4ee4\u5931\u8d25:" + cmd, (Throwable)e);
            return null;
        }
    }

    public String execShellToResult(String namespace, String podname, String cmd) {
        return this.execShellToResult(namespace, podname, false, cmd);
    }

    public String callRestServiceToResult(boolean isLocalCluser, Integer port, String namespace, String serviceName, String relaUrl) {
        String retstr = null;
        if (!isLocalCluser) {
            retstr = this.callRestServiceToResultForExecGet(null, port, namespace, serviceName, relaUrl, new String[0]);
        } else {
            HttpResult doGet = this.callRestServiceToResult(port, namespace, serviceName, relaUrl, new String[0]);
            if (doGet.getResult(null).isSuc()) {
                retstr = doGet.getBodyStr();
            }
        }
        return retstr;
    }

    public HttpResult callRestServiceToResult(Integer port, String namespace, String serviceName, String relaUrl, String ... params) {
        String httpurl = K8sAssit.getInnerUrl(port, namespace, serviceName, relaUrl, params);
        HttpResult doGet = HttpClient.doGet((String)httpurl);
        return doGet;
    }

    private String callRestServiceToResultForExec(Pod pod, Integer port, String namespace, String serviceName, String relaUrl, String modth, String ... params) {
        Pod podTrue = pod == null ? this.getPodByService(namespace, serviceName) : pod;
        String relaUrlTrue = StringUtil.packageUrlParams((String)relaUrl, (String[])params);
        String serviceUrl = pod == null ? "localhost" : String.format("%s.%s", serviceName, namespace);
        int portTrue = port == null ? 80 : port;
        String modthPathStr = "";
        if ("PATCH".equalsIgnoreCase(modth)) {
            modthPathStr = "--request PATCH";
        }
        String retstr = this.execShellToResult(podTrue.getMetadata().getNamespace(), podTrue.getMetadata().getName(), "curl  \"" + modthPathStr + IOUtil.mergeFolderAndFilePath((String)("http://" + serviceUrl + ":" + portTrue), (String[])new String[]{relaUrlTrue}) + "\"");
        return retstr;
    }

    public String callRestServiceToResultForExecGet(Pod pod, Integer port, String namespace, String serviceName, String relaUrl, String ... params) {
        return this.callRestServiceToResultForExec(pod, port, namespace, serviceName, relaUrl, "GET", params);
    }

    public String callRestServiceToResultForExecPatch(Pod pod, Integer port, String namespace, String serviceName, String relaUrl, String ... params) {
        return this.callRestServiceToResultForExec(pod, port, namespace, serviceName, relaUrl, "PATCH", params);
    }

    public void execShellToCallback(final Process proc, final IProcess callback, String ... cmdargs) {
        Thread in = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.doOutputStream(proc.getOutputStream());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        in.start();
        Thread out = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.doInputStream(proc.getInputStream());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        out.start();
        Thread error = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.doErrorStream(proc.getErrorStream());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        error.start();
        try {
            proc.waitFor();
            out.join();
            error.join();
        }
        catch (InterruptedException e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u542f\u52a8\u7ebf\u7a0b\u6709\u95ee\u9898");
        }
        proc.destroy();
    }

    public boolean deleteCusObject(ICrdDef crdVesion, String version, String namespace, String name) {
        try {
            CustomResourceDefinitionContext context = crdVesion.getCrd();
            boolean empty = ((Resource)((NonNamespaceOperation)this.client.genericKubernetesResources((ResourceDefinitionContext)context).inNamespace(namespace)).withName(name)).delete().isEmpty();
            return !empty;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() == 404) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_pagenotfound, "\u6ca1\u6709\u5e03\u7f72\u5e94\u7528:" + name + ": " + e.getMessage());
            }
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u5e03\u7f72\u81ea\u5b9a\u4e49\u7684\u7c7b\u578b\u5931\u8d25");
        }
        catch (Throwable e) {
            if (e.getMessage().contains("already exists")) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_exists, "\u5df2\u5b58\u5728\u6b64\u7c7b\u578b\u7684\u540c\u540d\u8d44\u6e90:" + e.getMessage());
            }
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, "\u5e03\u7f72\u81ea\u5b9a\u4e49\u7684\u7c7b\u578b\u5931\u8d25");
        }
    }

    public boolean deleteCusObject(ICrdDef crdVesion, String namespace, String name) {
        return this.deleteCusObject(crdVesion, null, namespace, name);
    }

    public List<GenericKubernetesResource> selCusObject(ICrdDef crdVesion, String version, String namespace, String name) {
        CustomResourceDefinitionContext context = crdVesion.getCrd();
        ArrayList retlist = null;
        if (StringUtil.isNotNull((Object)namespace) && StringUtil.isNotNull((Object)name)) {
            GenericKubernetesResource resource = (GenericKubernetesResource)((Resource)((NonNamespaceOperation)this.client.genericKubernetesResources((ResourceDefinitionContext)context).inNamespace(namespace)).withName(name)).get();
            retlist = resource == null ? new ArrayList() : Arrays.asList(resource);
        } else if (StringUtil.isNotNull((Object)namespace) && StringUtil.isNull((Object)name)) {
            retlist = ((GenericKubernetesResourceList)((NonNamespaceOperation)this.client.genericKubernetesResources((ResourceDefinitionContext)context).inNamespace(namespace)).list()).getItems();
        } else if (StringUtil.isNull((Object)namespace) && StringUtil.isNotNull((Object)name)) {
            GenericKubernetesResource resource = (GenericKubernetesResource)((Resource)this.client.genericKubernetesResources((ResourceDefinitionContext)context).withName(name)).get();
            retlist = resource == null ? new ArrayList() : Arrays.asList(resource);
        } else if (StringUtil.isNull((Object)namespace) && StringUtil.isNull((Object)name)) {
            retlist = ((GenericKubernetesResourceList)this.client.genericKubernetesResources((ResourceDefinitionContext)context).list()).getItems();
        }
        return retlist;
    }

    public List<GenericKubernetesResource> selCusObject(ICrdDef crdVesion, String namespace, String name) {
        return this.selCusObject(crdVesion, crdVesion.getVersions()[0], namespace, name);
    }

    public Service getService(String serviceName) {
        return this.getService(null, serviceName);
    }

    public ReplicationController getRC(String namespace, String rcName) {
        ReplicationController gotRc = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.getUseNamespaceName(namespace))).withName(rcName)).get();
        return gotRc;
    }

    public ReplicationController getRC(String rcName) {
        return this.getRC(null, rcName);
    }

    public Service getSVC(String namespace, String rcName) {
        Service service = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).withName(rcName)).get();
        return service;
    }

    public boolean delService(String namespace, String serviceName) {
        boolean optResult = !((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).withName(serviceName)).delete().isEmpty();
        return optResult;
    }

    public boolean delService(String serviceName) {
        return this.delService(null, serviceName);
    }

    public Result createNamespace(String namespace) {
        try {
            Namespace namespaceRet = (Namespace)((Resource)this.client.namespaces().resource((Object)((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(namespace)).endMetadata()).build())).create();
            return Result.getSuc().setRetObjs((Object[])new Namespace[]{namespaceRet});
        }
        catch (Exception e) {
            return Result.getError((String)e.getMessage());
        }
    }

    public boolean exitNamespace(String namespace) {
        Namespace namespace2 = (Namespace)((Resource)this.client.namespaces().withName(namespace)).get();
        return namespace2 != null;
    }

    public boolean delNamespace(String namespace) {
        boolean retobj = !((Resource)this.client.namespaces().withName(namespace)).delete().isEmpty();
        return retobj;
    }

    public boolean delPodByName(String namespace, String podName) {
        return !((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(this.getUseNamespaceName(namespace))).withName(podName)).delete().isEmpty();
    }

    public boolean delPodByName(String podName) {
        return this.delPodByName(null, podName);
    }

    public boolean delPodByLabel(String namespace, String key, String value) {
        return !((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(this.getUseNamespaceName(namespace))).withLabel(key, value)).delete().isEmpty();
    }

    public boolean delPodByLabel(String key, String value) {
        return this.delPodByLabel(null, key, value);
    }

    public Pod getPodByDeployment(String namespace, String deploymentName, String ... status) {
        List<Pod> items = this.getPodListByDeployment(namespace, deploymentName, status);
        return CollectionUtils.isEmpty(items) ? null : items.get(NumberUtil.random((int)items.size()));
    }

    public List<Pod> getPodListByDeployment(String namespace, String deploymentName, String ... status) {
        String[] stringArray;
        Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).withName(deploymentName)).get();
        if (deployment == null) {
            return null;
        }
        Map matchLabels = deployment.getSpec().getTemplate().getMetadata().getLabels();
        if (ArrayUtils.isEmpty((Object[])status)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "Running";
        } else {
            stringArray = status;
        }
        final String[] podAry = stringArray;
        List items = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabels(matchLabels)).list()).getItems();
        CollectionUtils.filter((Collection)items, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Pod pod = (Pod)object;
                return ArrayUtils.contains((Object[])podAry, (Object)pod.getStatus().getPhase());
            }
        });
        return items;
    }

    public Pod getPodByJob(String namespace, String jobName, String ... status) {
        List<Pod> items = this.getPodListByJob(namespace, jobName, status);
        return CollectionUtils.isEmpty(items) ? null : items.get(NumberUtil.random((int)items.size()));
    }

    public List<Pod> getPodListByJob(String namespace, String jobName, String ... status) {
        String[] stringArray;
        Job job = (Job)((ScalableResource)((NonNamespaceOperation)this.client.batch().v1().jobs().inNamespace(namespace)).withName(jobName)).get();
        if (job == null) {
            return null;
        }
        Map matchLabels = job.getSpec().getTemplate().getMetadata().getLabels();
        if (ArrayUtils.isEmpty((Object[])status)) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "Running";
        } else {
            stringArray = status;
        }
        final String[] podAry = stringArray;
        List items = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabels(matchLabels)).list()).getItems();
        CollectionUtils.filter((Collection)items, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Pod pod = (Pod)object;
                return ArrayUtils.contains((Object[])podAry, (Object)pod.getStatus().getPhase());
            }
        });
        return items;
    }

    public Pod getPodByService(String namespace, String serviceName) {
        List<Pod> items = this.getPodListByService(namespace, serviceName);
        return CollectionUtils.isEmpty(items) ? null : items.get(NumberUtil.random((int)items.size()));
    }

    public List<Pod> getPodListByService(String namespace, String serviceName) {
        Map matchLabels = ((Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceName)).get()).getSpec().getSelector();
        List items = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withLabels(matchLabels)).list()).getItems();
        CollectionUtils.filter((Collection)items, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Pod pod = (Pod)object;
                return "Running".equals(pod.getStatus().getPhase());
            }
        });
        return items;
    }

    public List<Pod> getPodListByIds(String namespace, Map<String, String> filtermap, String lable, String ... ids) {
        FilterNested withLabels = ((NonNamespaceOperation)this.client.pods().inNamespace(namespace)).withNewFilter();
        if (MapUtils.isNotEmpty(filtermap)) {
            withLabels = (FilterNested)withLabels.withLabels(filtermap);
            if (ArrayUtils.isNotEmpty((Object[])ids)) {
                withLabels = (FilterNested)withLabels.withLabelIn(lable, ids);
            }
        } else if (ArrayUtils.isNotEmpty((Object[])ids)) {
            withLabels = (FilterNested)withLabels.withLabelIn(lable, ids);
        }
        FilterWatchListDeletable endFilter = (FilterWatchListDeletable)withLabels.endFilter();
        PodList list = (PodList)endFilter.list();
        return list.getItems();
    }

    public List<Job> getJobListByIds(String namespace, Map<String, String> filtermap, String lable, String ... ids) {
        NonNamespaceOperation withLabels = (NonNamespaceOperation)this.client.batch().v1().jobs().inNamespace(namespace);
        FilterWatchListDeletable queryListWatch = null;
        if (MapUtils.isNotEmpty(filtermap)) {
            queryListWatch = (FilterWatchListDeletable)withLabels.withLabels(filtermap);
            if (ArrayUtils.isNotEmpty((Object[])ids)) {
                queryListWatch = (FilterWatchListDeletable)queryListWatch.withLabelIn(lable, ids);
            }
        } else if (ArrayUtils.isNotEmpty((Object[])ids)) {
            queryListWatch = (FilterWatchListDeletable)withLabels.withLabelIn(lable, ids);
        }
        return queryListWatch == null ? new ArrayList() : ((JobList)queryListWatch.list()).getItems();
    }

    public List<Pair<String, PodPhase>> queryPodStatus(String namespace, Map<String, String> filtermap, String lable, String[] lableNames) {
        List<Pod> pods = this.getPodListByIds(namespace, filtermap, lable, lableNames);
        ArrayList<Pair<String, PodPhase>> retlist = new ArrayList<Pair<String, PodPhase>>();
        for (String lableName : lableNames) {
            PodPhase elePhase = PodPhase.noExit;
            for (Pod pod : pods) {
                Object[] groups;
                Object[] subgroups;
                String podname = pod.getMetadata().getName();
                if (!podname.startsWith(lableName + "-") || !CollectionUtil.arrayJoin((Object[])(subgroups = (String[])ArrayUtils.subarray((Object[])(groups = podname.split("-")), (int)0, (int)(groups.length - 2))), (String)"-").equals(lableName)) continue;
                elePhase = PodPhase.valueOf(pod.getStatus().getPhase());
                break;
            }
            retlist.add((Pair<String, PodPhase>)Pair.of((Object)lableName, (Object)((Object)elePhase)));
        }
        return retlist;
    }

    public List<Pair<String, PodPhase>> queryJobStatus(String namespace, Map<String, String> filtermap, String lable, String[] lableNames) {
        List<Job> jobList = this.getJobListByIds(namespace, filtermap, lable, lableNames);
        ArrayList<Pair<String, PodPhase>> retlist = new ArrayList<Pair<String, PodPhase>>();
        for (String lableName : lableNames) {
            PodPhase elePhase = PodPhase.noExit;
            for (Job job : jobList) {
                if (!job.getMetadata().getName().equals(lableName)) continue;
                if (job.getStatus().getActive() != null && job.getStatus().getActive() == 1) {
                    elePhase = PodPhase.Running;
                    break;
                }
                if (job.getStatus().getSucceeded() != null && job.getStatus().getSucceeded() == 1) {
                    elePhase = PodPhase.Succeeded;
                    break;
                }
                elePhase = PodPhase.Unknown;
                break;
            }
            retlist.add((Pair<String, PodPhase>)Pair.of((Object)lableName, (Object)((Object)elePhase)));
        }
        return retlist;
    }

    public List<String> selPodNameByLabel(String namespace, Map<String, String> labelmap) {
        List<Pod> podList = this.getPodListByIds(namespace, labelmap, null, new String[0]);
        ArrayList<String> retlist = new ArrayList<String>();
        for (Pod pod : podList) {
            retlist.add(pod.getMetadata().getName());
        }
        return retlist;
    }

    public List<String> selServiceByLabel(String namespace, Map<String, String> labelmap) {
        NonNamespaceOperation serviceSel = (NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace));
        FilterWatchListDeletable withLabel = null;
        for (String key : labelmap.keySet()) {
            if (withLabel == null) {
                withLabel = (FilterWatchListDeletable)serviceSel.withLabel(key, labelmap.get(key));
                continue;
            }
            withLabel = (FilterWatchListDeletable)withLabel.withLabel(key, labelmap.get(key));
        }
        ServiceList list = (ServiceList)withLabel.list();
        ArrayList<String> retlist = new ArrayList<String>();
        for (Service service : list.getItems()) {
            retlist.add(service.getMetadata().getName());
        }
        return retlist;
    }

    public void createRc(String namespace, String filePath) throws ProjectException {
        FileInputStream inputstream;
        try {
            inputstream = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new ProjectException((IExcept)ExceptAll.Project_default, "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        this.createRc(namespace, inputstream);
    }

    public void createRc(String namespace, FileInputStream fileInputStream) throws ProjectException {
        JSONObject jsonObject = YamlAssist.readYaml((FileInputStream)fileInputStream);
        ReplicationController rc = new ReplicationController();
        if (jsonObject.containsKey((Object)"metadata")) {
            JSONObject metadataJson = jsonObject.getJSONObject("metadata");
            if (!metadataJson.containsKey((Object)"name")) {
                throw new ProjectException((IExcept)ExceptAll.param_error, "metadata\u9700\u8981\u6709name\u5143\u7d20");
            }
            ObjectMeta metadata = new ObjectMeta();
            metadata.setName(metadataJson.getString("name"));
            if (metadataJson.containsKey((Object)"labels")) {
                JSONObject labels = metadataJson.getJSONObject("labels");
                HashMap<String, String> lables = new HashMap<String, String>();
                for (String key : labels.keySet()) {
                    lables.put(key, labels.getString(key));
                }
                metadata.setLabels(lables);
            }
            rc.setMetadata(metadata);
        }
        JSONObject specJson = jsonObject.getJSONObject("spec");
        ReplicationControllerSpec spec = rc.getSpec();
        if (specJson.containsKey((Object)"replicas")) {
            spec.setReplicas(specJson.getInteger("replicas"));
        }
        if (specJson.containsKey((Object)"selector")) {
            Map selector = (Map)JSONObject.toJavaObject((JSON)specJson.getJSONObject("selector"), Map.class);
            spec.setSelector(selector);
        }
        PodTemplateSpec newTemplate = spec.getTemplate();
        JSONObject templateJson = specJson.getJSONObject("template");
        if (templateJson.containsKey((Object)"metadata")) {
            ObjectMeta withNewMetadata = newTemplate.getMetadata();
            JSONObject jsonObject2 = templateJson.getJSONObject("metadata").getJSONObject("labels");
            Map labels = (Map)JSON.toJavaObject((JSON)jsonObject2, Map.class);
            withNewMetadata.setLabels(labels);
        }
        JSONObject innerSpecJson = templateJson.getJSONObject("spec");
        JSONArray containersJson = innerSpecJson.getJSONArray("containers");
        for (int i = 0; i < containersJson.size(); ++i) {
            JSONObject containerJson = containersJson.getJSONObject(i);
            Container addNewContainer = new Container();
            addNewContainer.setName(containerJson.getString("name"));
            addNewContainer.setImage(containerJson.getString("image"));
            JSONArray portAry = containerJson.getJSONArray("ports");
            ArrayList<ContainerPort> ports = new ArrayList<ContainerPort>();
            for (int j = 0; j < portAry.size(); ++j) {
                ContainerPort temport = new ContainerPort();
                temport.setContainerPort(portAry.getJSONObject(i).getInteger("containerPort"));
                ports.add(temport);
            }
            addNewContainer.setPorts(ports);
        }
        rc = (ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.getUseNamespaceName(namespace))).resource((Object)rc)).create();
    }

    public void createSvc(String namespace, FileInputStream fileInputStream) throws ProjectException {
        JSONObject jsonObject = YamlAssist.readYaml((FileInputStream)fileInputStream);
        Service createNew = new ServiceBuilder().build();
        JSONObject metadata = jsonObject.getJSONObject("metadata");
        ObjectMeta meta = new ObjectMeta();
        meta.setName(metadata.getString("name"));
        createNew.setMetadata(meta);
        JSONObject specjson = jsonObject.getJSONObject("spec");
        ServiceSpec withNewSpec = createNew.getSpec();
        if (specjson.containsKey((Object)"type")) {
            withNewSpec.setType(specjson.getString("type"));
        }
        if (specjson.containsKey((Object)"selector")) {
            Map seleMap = (Map)JSON.toJavaObject((JSON)specjson.getJSONObject("selector"), Map.class);
            withNewSpec.setSelector(seleMap);
        }
        if (specjson.containsKey((Object)"ports")) {
            JSONArray array = specjson.getJSONArray("ports");
            ArrayList<ServicePort> ports = new ArrayList<ServicePort>();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject tempobj = array.getJSONObject(i);
                ServicePort temp = new ServicePort();
                if (tempobj.containsKey((Object)"name")) {
                    temp.setName(tempobj.getString("name"));
                }
                if (tempobj.containsKey((Object)"nodePort")) {
                    temp.setNodePort(tempobj.getInteger("nodePort"));
                }
                if (tempobj.containsKey((Object)"port")) {
                    temp.setPort(tempobj.getInteger("port"));
                }
                if (tempobj.containsKey((Object)"protocol")) {
                    temp.setProtocol(tempobj.getString("protocol"));
                }
                if (tempobj.containsKey((Object)"targetPort")) {
                    IntOrString input = new IntOrString((Object)tempobj.getInteger("targetPort"));
                    temp.setTargetPort(input);
                }
                ports.add(temp);
            }
            withNewSpec.setPorts(ports);
        }
        Service service = ((ServiceBuilder)new ServiceBuilder().withSpec(withNewSpec)).build();
        service = (Service)((ServiceResource)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).resource((Object)service)).create();
    }

    public void createSvc(String namespace, String filePath) throws ProjectException {
        FileInputStream inputstream;
        try {
            inputstream = new FileInputStream(filePath);
        }
        catch (FileNotFoundException e) {
            throw new ProjectException((IExcept)ExceptAll.Project_default, "\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        this.createSvc(namespace, inputstream);
    }

    public void createResourcequota(String namespace, int minCpu, int minMemory, int maxCpu, int maxMemory, int pods) {
        HashMap<String, Quantity> parma = new HashMap<String, Quantity>();
        parma.put("pods", new Quantity(String.valueOf(pods)));
        parma.put("requests.cpu", new Quantity(String.valueOf(minCpu)));
        parma.put("requests.memory", new Quantity(String.valueOf(minMemory)));
        parma.put("limits.cpu", new Quantity(String.valueOf(maxCpu)));
        parma.put("limits.memory", new Quantity(String.valueOf(maxMemory)));
        ResourceQuota quota = ((ResourceQuotaBuilder)((ResourceQuotaFluent.SpecNested)((ResourceQuotaBuilder)((ResourceQuotaFluent.MetadataNested)new ResourceQuotaBuilder().withNewMetadata().withName(this.getUseNamespaceName(namespace))).endMetadata()).withNewSpec().addToHard(parma)).endSpec()).build();
        ((Resource)((NonNamespaceOperation)this.client.resourceQuotas().inNamespace(this.getUseNamespaceName(namespace))).resource((Object)quota)).create();
    }

    public void delResourcequota(String namespace) {
        ((NonNamespaceOperation)this.client.resourceQuotas().inNamespace(this.getUseNamespaceName(namespace))).delete();
    }

    public boolean delRc(String namespace, String rcName) {
        return !((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.getUseNamespaceName(namespace))).withName(rcName)).delete().isEmpty();
    }

    public boolean delSvc(String namespace, String svcName) {
        return !((FilterWatchListDeletable)((NonNamespaceOperation)this.client.services().inNamespace(this.getUseNamespaceName(namespace))).withField("metadata.name", svcName)).delete().isEmpty();
    }

    public void updateRcImage(String namespace, String rcName, int containerIndex, String imageValue) {
        ReplicationControllerSpec spec = ((ReplicationController)((RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(this.getUseNamespaceName(namespace))).withName(rcName)).edit(new Visitor[0])).getSpec();
        Container container = (Container)spec.getTemplate().getSpec().getContainers().get(containerIndex);
        container.setImage(imageValue);
        RollableScalableResource withName = (RollableScalableResource)((NonNamespaceOperation)this.getClient().replicationControllers().inNamespace(this.getUseNamespaceName(namespace))).withName(rcName);
        withName.updateImage(imageValue);
        withName.rolling();
    }

    public void scaleDeployment(String namespace, String deploymentName, int numberOfReplicas) throws ApiException {
        AppsV1Api appsV1Api = new AppsV1Api(this.apiClient);
        V1DeploymentList listNamespacedDeployment = appsV1Api.listNamespacedDeployment(this.getUseNamespaceName(namespace), deploymentName, null, null, null, null, null, null, null, null, Boolean.FALSE);
        List appsV1DeploymentItems = listNamespacedDeployment.getItems();
        Optional<V1Deployment> findedDeployment = appsV1DeploymentItems.stream().filter(deployment -> deployment.getMetadata().getName().equals(deploymentName)).findFirst();
        findedDeployment.ifPresent(deploy -> {
            try {
                V1DeploymentSpec newSpec = deploy.getSpec().replicas(Integer.valueOf(numberOfReplicas));
                V1Deployment newDeploy = deploy.spec(newSpec);
                appsV1Api.replaceNamespacedDeployment(deploymentName, this.getUseNamespaceName(namespace), newDeploy, null, null, null, null);
            }
            catch (ApiException ex) {
                log.warn("Scale the pod failed for Deployment:" + deploymentName, (Throwable)ex);
            }
        });
    }

    public Result updateImageRolling(String namespace, String rcName, String imageValue) {
        try {
            RollableScalableResource withName = (RollableScalableResource)((NonNamespaceOperation)this.client.replicationControllers().inNamespace(namespace)).withName(rcName);
            withName.updateImage(imageValue);
            withName.rolling();
            return Result.getSuc();
        }
        catch (Exception e) {
            return Result.getError((String)e.getMessage());
        }
    }

    public Result createOrUpdateImageRolling(String namespace, String imageValue, String rcPath) {
        JSONObject json = YamlAssist.readYaml((String)rcPath);
        String rcName = json.getJSONObject("metadata").getString("name");
        ReplicationController queryRc = this.getRC(namespace, rcName);
        if (queryRc == null) {
            try {
                this.createRc(namespace, rcPath);
                return Result.getSuc();
            }
            catch (ProjectException e) {
                return Result.getError((String)e.getMessage());
            }
        }
        return this.updateImageRolling(namespace, rcName, imageValue);
    }

    public Deployment getDeploymentByName(String namespace, String name) {
        Deployment deployment = (Deployment)((RollableScalableResource)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(StringUtil.hasNull((String[])new String[]{namespace, "default"}))).withName(name)).get();
        return deployment;
    }

    public Deployment getDeploymentByLabelOne(String namespace, String label, String value) {
        DeploymentList list = this.getDeploymentByLabel(namespace, label, value);
        if (list == null || list.getItems().size() != 1) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.param_notfit, "Deployment\u9884\u671f\u53ea\u6709\u4e00\u4e2a\uff0c\u73b0\u5df2\u67e5\u51fa:" + list.getItems().size());
        }
        return (Deployment)list.getItems().get(0);
    }

    public DeploymentList getDeploymentByLabel(String namespace, String label, String value) {
        DeploymentList deployments = (DeploymentList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(StringUtil.hasNull((String[])new String[]{namespace, "default"}))).withLabel(label, value)).list();
        return deployments;
    }

    public DeploymentList getDeploymentByLabel(String namespace, String label) {
        DeploymentList deployments = (DeploymentList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(StringUtil.hasNull((String[])new String[]{namespace, "default"}))).withLabel(label)).list();
        return deployments;
    }

    public V1Deployment installDeploymentByTemp(String namespace, String context, Map<String, Object> params) {
        try {
            String result = FreemarkUtil.getInst().doProcessByTemp(context, params);
            V1Deployment yamlSvc = (V1Deployment)Yaml.load((String)result);
            AppsV1Api appsV1Api = new AppsV1Api(this.apiClient);
            V1Deployment v1Deployment = appsV1Api.createNamespacedDeployment(namespace, yamlSvc, "true", null, null, null);
            return v1Deployment;
        }
        catch (ApiException e) {
            if ("Conflict".equals(e.getMessage())) {
                throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_deploy_conflict);
            }
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_api_other, e.getMessage());
        }
        catch (Exception e) {
            throw new ProjectExceptionRuntime((IExcept)ExceptAll.k8s_deploy_excetion, "\u90e8\u7f72task\u5931\u8d25", (Throwable)e);
        }
    }

    public OwnerReference getControllerOf(HasMetadata md) {
        List ownerReferences = md.getMetadata().getOwnerReferences();
        for (OwnerReference ownerReference : ownerReferences) {
            if (!ownerReference.getController().equals(Boolean.TRUE)) continue;
            return ownerReference;
        }
        return null;
    }

    public ServiceAccount findCreateSa(String namespace, String saName) {
        ServiceAccount serviceAccount = (ServiceAccount)((ServiceAccountResource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(namespace)).withName(saName)).get();
        if (serviceAccount == null) {
            ServiceAccount sa = new ServiceAccount();
            ObjectMeta objectMeta = new ObjectMeta();
            objectMeta.setName(saName);
            sa.setMetadata(objectMeta);
            serviceAccount = (ServiceAccount)((ServiceAccountResource)((NonNamespaceOperation)this.client.serviceAccounts().inNamespace(namespace)).resource((Object)sa)).create();
        }
        return serviceAccount;
    }

    public Result bindAdminRoleForSa(String namespace, String bindname, String ... sas) {
        RbacAuthorizationV1Api rolebind = new RbacAuthorizationV1Api(this.apiClient);
        V1RoleBinding body = new V1RoleBinding();
        body.setKind("RoleBinding");
        body.setApiVersion("rbac.authorization.k8s.io/v1");
        V1ObjectMeta metadata = new V1ObjectMeta();
        metadata.setName(bindname);
        metadata.setNamespace(namespace);
        body.setMetadata(metadata);
        V1RoleRef roleRef = new V1RoleRef();
        roleRef.setApiGroup("rbac.authorization.k8s.io");
        roleRef.setKind("ClusterRole");
        roleRef.setName("admin");
        body.setRoleRef(roleRef);
        ArrayList<V1Subject> subjects = new ArrayList<V1Subject>();
        for (String sa : sas) {
            V1Subject temp = new V1Subject();
            temp.setKind("ServiceAccount");
            temp.setName(sa);
            temp.setNamespace(namespace);
            subjects.add(temp);
        }
        body.setSubjects(subjects);
        try {
            rolebind.createNamespacedRoleBinding(namespace, body, "true", null, null, null);
            return Result.getSuc();
        }
        catch (ApiException e) {
            if (e.getCode() == 409) {
                return Result.getSuc();
            }
            log.error("\u521b\u5efa\u89d2\u8272\u7ed1\u5b9a\u5173\u7cfb\u5931\u8d25:" + e.getResponseBody(), (Throwable)e);
            return Result.getError((String)("\u521b\u5efa\u89d2\u8272\u7ed1\u5b9a\u5173\u7cfb\u5931\u8d25" + e.getMessage()));
        }
    }

    public Result bindClusterAdminRoleForSa(String namespace, String bindname, String ... sas) {
        RbacAuthorizationV1Api rolebind = new RbacAuthorizationV1Api(this.apiClient);
        V1ClusterRoleBinding body = new V1ClusterRoleBinding();
        body.setKind("ClusterRoleBinding");
        body.setApiVersion("rbac.authorization.k8s.io/v1");
        V1ObjectMeta metadata = new V1ObjectMeta();
        metadata.setName(bindname);
        metadata.setNamespace(namespace);
        body.setMetadata(metadata);
        V1RoleRef roleRef = new V1RoleRef();
        roleRef.setApiGroup("rbac.authorization.k8s.io");
        roleRef.setKind("ClusterRole");
        roleRef.setName("cluster-admin");
        body.setRoleRef(roleRef);
        ArrayList<V1Subject> subjects = new ArrayList<V1Subject>();
        for (String sa : sas) {
            V1Subject temp = new V1Subject();
            temp.setKind("ServiceAccount");
            temp.setName(sa);
            temp.setNamespace(namespace);
            subjects.add(temp);
        }
        body.setSubjects(subjects);
        try {
            rolebind.createClusterRoleBinding(body, "true", null, null, null);
            return Result.getSuc();
        }
        catch (ApiException e) {
            if (e.getCode() == 409) {
                return Result.getSuc();
            }
            log.error("\u521b\u5efa\u89d2\u8272\u7ed1\u5b9a\u5173\u7cfb\u5931\u8d25:" + e.getResponseBody(), (Throwable)e);
            return Result.getError((String)("\u521b\u5efa\u89d2\u8272\u7ed1\u5b9a\u5173\u7cfb\u5931\u8d25" + e.getMessage()));
        }
    }

    public Secret getSecretAccount(String namespace, final String accountName) {
        SecretList list = (SecretList)((NonNamespaceOperation)this.client.secrets().inNamespace(namespace)).list();
        List items = list.getItems();
        CollectionUtils.filter((Collection)items, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                Secret temp = (Secret)object;
                return MapUtils.isNotEmpty((Map)temp.getMetadata().getAnnotations()) && accountName.equals(temp.getMetadata().getAnnotations().get("kubernetes.io/service-account.name"));
            }
        });
        return CollectionUtils.isEmpty((Collection)items) ? null : (Secret)items.get(0);
    }

    public Result proKubeConfig(String clusterName, String namespace, String accountName, boolean isCluster) {
        Result result;
        ServiceAccount account = this.findCreateSa(namespace, accountName);
        String bindName = isCluster ? String.format("%s-%s-clusteradmin-binder", account.getMetadata().getName(), namespace) : String.format("%s-%s-admin-binder", account.getMetadata().getName(), namespace);
        Result result2 = result = isCluster ? this.bindClusterAdminRoleForSa(namespace, bindName, account.getMetadata().getName()) : this.bindAdminRoleForSa(namespace, bindName, account.getMetadata().getName());
        if (!result.isSuc()) {
            return result;
        }
        Secret accountSecret = this.getSecretAccount(namespace, account.getMetadata().getName());
        String proKubeConfig = this.proKubeConfig(clusterName, accountSecret);
        Result suc = Result.getSuc();
        suc.setRetObjs((Object[])new String[]{proKubeConfig});
        return suc;
    }

    public String proKubeConfig(String clusterName, Secret secret) {
        try {
            HashMap params = new HashMap();
            params.put("cluster_certificate_authority_data", secret.getData().get("ca.crt"));
            params.put("cluster_server", this.client.getMasterUrl());
            params.put("cluster_name", clusterName);
            params.put("user_name", secret.getMetadata().getAnnotations().get("kubernetes.io/service-account.name"));
            params.put("namespace", secret.getMetadata().getNamespace());
            params.put("context_name", clusterName);
            params.put("user_token", new String(PwdUtil.fromBase64((String)((String)secret.getData().get("token")))));
            String slurp = IOUtil.slurp((InputStream)IOUtil.fileToInputStream((String)"/template/configSingle.yaml", KubeClientTams.class));
            String doProcessByTemp = FreemarkUtil.getInst().doProcessByTemp(slurp, params);
            return doProcessByTemp;
        }
        catch (IOException e) {
            log.error("\u751f\u6210config\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

