/*
 * Decompiled with CFR 0.152.
 */
package net.wicp.tams.common.kubernetes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import net.wicp.tams.common.apiext.IOUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.constant.ContentType;
import net.wicp.tams.common.http.HttpCallThread;
import net.wicp.tams.common.http.HttpClient;
import net.wicp.tams.common.http.HttpResult;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpRequestBase;

public abstract class K8sAssit {
    public static String getInnerUrl(Integer port, String namespace, String serviceName, String relaUrl, String ... params) {
        String httpurl = String.format("http://%s.%s:%s", serviceName, namespace, port == null ? 80 : port);
        httpurl = IOUtil.mergeFolderAndFilePath((String)httpurl, (String[])new String[]{relaUrl});
        return StringUtil.packageUrlParams((String)httpurl, (String[])params);
    }

    public static String getInnerUrl(String namespace, String serviceName, String relaUrl, String ... params) {
        return K8sAssit.getInnerUrl(null, namespace, serviceName, relaUrl, params);
    }

    public static HttpResult uploadFile(String namespace, String serviceName, String relaUrl, ContentType contentType, String fileName, InputStream in) {
        String innerUrl = K8sAssit.getInnerUrl(namespace, serviceName, relaUrl, new String[0]);
        HttpCallThread doPostJar = new HttpCallThread((HttpRequestBase)HttpClient.doPostFile((String)innerUrl, (String)fileName, (InputStream)in, (ContentType)contentType, (Header[])new Header[0]));
        HttpResult httpResult = doPostJar.call();
        return httpResult;
    }

    public static HttpResult uploadFile(String namespace, String serviceName, String relaUrl, String fileName, InputStream in) {
        ContentType contentType = ContentType.findByFileName((String)fileName);
        return K8sAssit.uploadFile(namespace, serviceName, relaUrl, contentType, fileName, in);
    }

    public static HttpResult uploadFile(String namespace, String serviceName, String relaUrl, File file) {
        if (!file.exists()) {
            return null;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return K8sAssit.uploadFile(namespace, serviceName, relaUrl, file.getName(), in);
    }
}

