package net.wicp.tams.common.kubernetes.helm.po;

import java.util.ArrayList;
import java.util.List;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.apiext.StringUtil;

@Data
@Slf4j
public class RepoInst {
	private String name;
	private String url;
	private String username;
	private String password;

	public RepoInst(String name, String url, String username, String password) {
		super();
		this.name = name;
		this.url = url;
		this.username = username;
		this.password = password;
	}

	public static RepoInst[] splitList(String value) {
		String[] rows = value.split("\n");
		List<RepoInst> retlist = new ArrayList<RepoInst>();
		if (rows.length > 1) {// 第一行是：NAME URL
			for (int i = 1; i < rows.length; i++) {
				if (rows[i].startsWith("WARNING: ")) {// WARNING: Kubernetes configuration file is world-readable. This
														// is insecure. Location: ***
					continue;// 警告信息不理
				}
				String[] row = rows[i].split("\t");
				if (row.length < 2) {
					log.error("此结果不能被解析：" + rows[i]);
					continue;
				} else {
					log.info("返回值:" + rows[i]);
				}
				RepoInst temp =new RepoInst(StringUtil.trimSpace(row[0]), StringUtil.trimSpace(row[1]), null, null);
				retlist.add(temp);
			}
		}
		RepoInst[] insts = retlist.toArray(new RepoInst[retlist.size()]);
		return insts;
	}

}
