/*
 * **********************************************************************
 * Copyright (c) 2022 .
 * All rights reserved.
 * 项目名称：common-apiext
 * 项目描述：工具
 * 版权说明：本软件属andy.zhou(rjzjh@163.com)所有。
 * ***********************************************************************
 */
package net.wicp.tams.common.kubernetes.duckula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

import net.wicp.tams.common.Conf;
import net.wicp.tams.common.apiext.CollectionUtil;
import net.wicp.tams.common.apiext.StringUtil;
import net.wicp.tams.common.callback.ICallBack;
import net.wicp.tams.common.constant.dic.intf.IEnumCombobox;
import net.wicp.tams.common.exception.ExceptAll;
import net.wicp.tams.common.exception.ProjectExceptionRuntime;

/***
 * 部署配置项
 * 
 * @author andy.zhou
 * 
 */
public enum ConfigItem implements IEnumCombobox {
	k8s_namespace("部署的名称空间", "k8s_namespace", "bigdata"),

	k8s_nas_storageClass("nas盘的创建类", "k8s_nas_storageClass", true),

	k8s_nas_size("nas盘大小", "k8s_nas_size", "100Gi"),

	k8s_secret_ssl_key("sslSecret的key", "k8s_secret_ssl_key", false),

	k8s_secret_ssl_crt("nas盘大小", "k8s_secret_ssl_crt", false),

	k8s_ingress_slbssh("slb是否启用了ssh", "k8s_ingress_slbssh", "yes"), // 默认启用了ssh(一般私有化环境都会启用,但IDC dev环境下并没有启用)

	k8s_secret_docker_configjson("推镜像的secret的configjson", "k8s_secret_docker_configjson", false),

	duckula_deployId("平台的common_deploy表的id", "duckula_deployId", "1344624860489924610"),

	docker_image_repository("dock镜像的repository", "docker_image_repository",
			"lk-acr-registry.cn-hangzhou.cr.aliyuncs.com/bigdata"),

	duckula_defaultdb("默认库名", "duckula_defaultdb", "duckula"),

	ds_defaultdb("默认库名", "ds_defaultdb", "dolphinscheduler"),

	db_port("端口", "db_port", "3306"),

	db_host("主机", "db_host", true),

	db_username("用户名", "db_username", true),

	db_password("密码", "db_password", true),

	duckula_agent_imageGroup("agent模块的镜像组", "duckula_agent_imageGroup", "/duckula-agent"),

	duckula_agent_imageVersion("agent模块的版本", "duckula_agent_imageVersion", true),

	duckula_agent_ingressHost("agent模块的域名", "duckula_agent_ingressHost", true),

	duckula_operator_imageGroup("operator模块的镜像组", "duckula_operator_imageGroup", "/operator-flink"),

	duckula_operator_imageVersion("operator模块的版本", "duckula_operator_imageVersion", true),

	duckula_ops_imageGroup("ops模块的镜像组", "duckula_ops_imageGroup", "/duckula-ops"),

	duckula_ops_imageVersion("operator模块的版本", "duckula_ops_imageVersion", true),

	duckula_ops_cpu("opsCPU", "duckula_ops_cpu", "1000m"),

	duckula_ops_memory("operator模块的版本", "duckula_ops_memory", "1024Mi"),

	duckula_ops_ingressHost("ops模块的域名", "duckula_ops_ingressHost", true),

	duckula_flink_ingressHost("flink的JM注册域名", "duckula_flink_ingressHost", true),

	ds_images_imageGroup("ds镜像仓库", "ds_images_imageGroup", "/dolphinscheduler"),

	ds_images_imageVersion("ds镜像版本", "ds_images_imageVersion", "2.0.4"),

	ds_ingressHost("ds域名", "ds_ingressHost", true),

	//////////////////////////////////////////// 下面为派生的配置，不需要在配置文件中出现///////////////////////////////////////////////////////////
	k8s_secret_docker_enable("是否启用镜像的secret", "k8s_secret_docker_enable", new ICallBack<String>() {

		@Override
		public String getObj() {
			String configjson = k8s_secret_docker_configjson.getValue();
			return StringUtil.isNull(configjson) ? "false" : "true";
		}

	}),

	duckula_agent_ingress_enable("agent模块是否需要外部域名（有时可能没有提供）", "duckula_agent_ingress_enable", new ICallBack<String>() {

		@Override
		public String getObj() {
			return StringUtil.isNull(duckula_agent_ingressHost.getValue()) ? "false" : "true";
		}

	}),

	// 它会影响资源的
	k8s_ingress_ssl_enable("ingress里是否要使用https", "k8s_ingress_ssl_enable", new ICallBack<String>() {

		@Override
		public String getObj() {
			String secretssl = k8s_secret_ssl_enable.getValue();// 启用了secret ssl证书
			String ingressSsl = k8s_ingress_slbssh.getValue();// ingress里启用了https
			return ("true".equals(secretssl) || "yes".equals(ingressSsl)) ? "true" : "false";
		}
	}),

	k8s_secret_ssl_enable("是否启用SSL认证secret", "k8s_secret_ssl_enable", new ICallBack<String>() {

		@Override
		public String getObj() {
			String key = k8s_secret_ssl_key.getValue();
			String crt = k8s_secret_ssl_crt.getValue();
			return StringUtil.isNotNull(key) && StringUtil.isNotNull(crt) ? "true" : "false";
		}
	}),

	;

	private final String desc;

	private final String itemName;// 配置项名

	private final String defaultVal;// 默认值

	private final boolean notNull;

	private final ICallBack<String> convert;// 转换器,小心不要死循环

	private ConfigItem(String desc, String itemName, boolean notNull) {
		this.desc = desc;
		this.itemName = itemName;
		this.defaultVal = "";
		this.convert = null;
		this.notNull = notNull;
	}

	private ConfigItem(String desc, String itemName, ICallBack<String> convert) {
		this.desc = desc;
		this.itemName = itemName;
		this.defaultVal = "";
		this.convert = convert;
		this.notNull = false;
	}

	private ConfigItem(String desc, String itemName, String defaultVal) {
		this.desc = desc;
		this.itemName = itemName;
		this.defaultVal = defaultVal;
		this.convert = null;
		this.notNull = false;// 有默认值，不是必需
	}

	public String getDesc() {
		return desc;
	}

	public String getName() {
		return this.name();
	}

	public String getValue() {
		String retval = null;
		if (this.convert == null) {
			retval = Conf.get(this.getItemName(), this.defaultVal);
		} else {
			retval = this.convert.getObj();
		}
		return retval;
	}

	@Override
	public String getDesc_zh() {
		return this.desc;
	}

	@Override
	public String getDesc_en() {
		return this.name();
	}

	public boolean isNotNull() {
		return this.notNull;
	}

	public static ConfigItem find(String name) {
		if (StringUtils.isEmpty(name)) {
			return null;
		}
		for (ConfigItem ele : ConfigItem.values()) {
			if (name.equalsIgnoreCase(ele.name())) {
				return ele;
			}
		}
		return null;
	}

	public static ConfigItem[] findConfigItem(String pre) {
		List<ConfigItem> checkItems = new ArrayList<>();
		for (ConfigItem configItem : ConfigItem.values()) {
			if (configItem.name().startsWith(pre)) {
				checkItems.add(configItem);
			}
		}
		return checkItems.toArray(new ConfigItem[checkItems.size()]);
	}

	// 生成参数
	public static Map<String, String> proParams() {
		Map<String, String> retmap = new HashMap<>();
		for (ConfigItem ele : ConfigItem.values()) {
			retmap.put(ele.name(), ele.getValue());
		}
		return retmap;
	}

	protected String getItemName() {
		return itemName;
	}

	protected String getDefaultVal() {
		return defaultVal;
	}
}
